<?php

namespace App\Http\Controllers;

use App\Services\BadgeService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BadgeController extends Controller
{
    protected $badgeService;

    public function __construct(BadgeService $badgeService)
    {
        $this->badgeService = $badgeService;
    }

    /**
     * Get all badges with user's earned status
     */
    public function index()
    {
        $user = Auth::user();
        $badges = $this->badgeService->getAllBadgesWithUserStatus($user);
        $stats = $this->badgeService->getUserBadgeStats($user);

        return response()->json([
            'success' => true,
            'badges' => $badges,
            'stats' => $stats
        ]);
    }

    /**
     * Get user's earned badges only
     */
    public function earned()
    {
        $user = Auth::user();
        $earnedBadges = $user->badges()
            ->orderBy('user_badges.earned_at', 'desc')
            ->get()
            ->map(function ($badge) {
                return [
                    'id' => $badge->id,
                    'name' => $badge->name,
                    'description' => $badge->description,
                    'icon' => $badge->icon,
                    'points' => $badge->points,
                    'color' => $badge->color,
                    'earned_at' => $badge->pivot->earned_at,
                ];
            });

        return response()->json([
            'success' => true,
            'badges' => $earnedBadges
        ]);
    }

    /**
     * Get badge statistics for user
     */
    public function stats()
    {
        $user = Auth::user();
        $stats = $this->badgeService->getUserBadgeStats($user);

        return response()->json([
            'success' => true,
            'stats' => $stats
        ]);
    }
}
