<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CheckAccessCodeRequirement
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        try {
            $isRequired = (bool) DB::table('settings')->where('id', 1)->value('access_code_required');
        } catch (\Exception $e) {
            $isRequired = false;
        }

        view()->share('accessCodeRequired', $isRequired);

        return $next($request);
    }
}
