<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RoleRedirect
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Only redirect if user is authenticated and trying to access the root/dashboard
        if (Auth::check() && ($request->is('/') || $request->is('dashboard'))) {
            $user = Auth::user();

            // Use is_admin field for now
            if ($user->is_admin) {
                return redirect('/dashboard/admin');
            } else {
                // Default to user dashboard for regular users
                return redirect('/dashboard/user');
            }
        }

        return $next($request);
    }
}
