<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CertificateAssignment extends Model
{
    use HasFactory;

    protected $fillable = [
        'certificate_template_id',
        'assignable_type',
        'assignable_id',
    ];

    public function template()
    {
        return $this->belongsTo(CertificateTemplate::class, 'certificate_template_id');
    }

    public function assignable()
    {
        return $this->morphTo();
    }
}