<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CourseSurveyResponse extends Model
{
    protected $fillable = [
        'survey_id',
        'user_id',
        'course_id',
        'response',
        'rating',
        'completed_at',
    ];

    protected $casts = [
        'response' => 'array',
        'rating' => 'integer',
        'completed_at' => 'datetime',
    ];

    public function survey()
    {
        return $this->belongsTo(CourseSurvey::class, 'survey_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function course()
    {
        return $this->belongsTo(Course::class);
    }
}
