<?php

namespace App\Models;

use App\Traits\HasSlug;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lesson extends Model
{
    use HasFactory, HasSlug;

    protected $fillable = [
        'course_id',
        'name',
        'slug',
        'intro',
        'order_index',
        'share_enabled',
        'share_type',
        'share_url',
        'share_filename',
        'share_size',
        'has_quiz',
        'has_certificate',
        'certificate_id',
    ];

    protected $casts = [
        'share_enabled' => 'boolean',
        'has_quiz' => 'boolean',
        'has_certificate' => 'boolean',
    ];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function topics()
    {
        return $this->hasMany(Topic::class)->orderBy('order_index');
    }

    public function quizQuestions()
    {
        return $this->hasMany(QuizQuestion::class)->orderBy('order_index');
    }

    /**
     * Get the attribute to use for slug generation
     */
    public function getSlugSourceAttribute()
    {
        return $this->name;
    }

    /**
     * Get the scope key for unique slug within parent
     */
    public function getSlugScope()
    {
        return 'course_id';
    }
}