<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PenaltyHistory extends Model
{
    use HasFactory;

    const UPDATED_AT = null; // History records are immutable

    protected $table = 'penalty_history';

    protected $fillable = [
        'user_id',
        'penalty_card_id',
        'action_type',
        'card_type',
        'points_affected',
        'description',
        'action_by',
        'metadata'
    ];

    protected $casts = [
        'user_id' => 'integer',
        'penalty_card_id' => 'integer',
        'points_affected' => 'integer',
        'action_by' => 'integer',
        'metadata' => 'array',
        'created_at' => 'datetime'
    ];

    /**
     * Get the user this history belongs to
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the penalty card related to this history
     */
    public function penaltyCard()
    {
        return $this->belongsTo(UserPenaltyCard::class, 'penalty_card_id');
    }

    /**
     * Get the user who performed the action
     */
    public function actionBy()
    {
        return $this->belongsTo(User::class, 'action_by');
    }

    /**
     * Scope for specific action type
     */
    public function scopeActionType($query, $type)
    {
        return $query->where('action_type', $type);
    }

    /**
     * Scope for issued actions
     */
    public function scopeIssued($query)
    {
        return $query->where('action_type', 'issued');
    }

    /**
     * Scope for escalated actions
     */
    public function scopeEscalated($query)
    {
        return $query->where('action_type', 'escalated');
    }

    /**
     * Scope for revoked actions
     */
    public function scopeRevoked($query)
    {
        return $query->where('action_type', 'revoked');
    }
}