<?php

namespace App\Models;

use App\Traits\HasSlug;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Topic extends Model
{
    use HasFactory, HasSlug;

    protected $fillable = [
        'lesson_id',
        'title',
        'slug',
        'body',
        'video_url',
        'image_url',
        'order_index',
        'is_published',
    ];

    protected $casts = [
        'is_published' => 'boolean',
    ];

    public function lesson()
    {
        return $this->belongsTo(Lesson::class, 'lesson_id');
    }

    // Alias for backwards compatibility
    public function section()
    {
        return $this->lesson();
    }

    public function quizQuestions()
    {
        return $this->hasMany(QuizQuestion::class)->orderBy('order_index');
    }

    public function userProgress()
    {
        return $this->hasMany(UserProgress::class);
    }

    /**
     * Get the attribute to use for slug generation
     */
    public function getSlugSourceAttribute()
    {
        return $this->title;
    }

    /**
     * Get the scope key for unique slug within parent
     */
    public function getSlugScope()
    {
        return 'lesson_id';
    }
}