<?php

namespace App\View\Composers;

use App\Models\CustomPage;
use Illuminate\View\View;

class NavigationComposer
{
    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        // Get published pages ordered by their order column
        $navigationPages = CustomPage::published()
            ->ordered()
            ->get(['id', 'title', 'slug', 'order']);

        $view->with('navigationPages', $navigationPages);
    }
}
