<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('short_description')->nullable();
            $table->text('certificate_template')->nullable();
            $table->text('completion_instructions')->nullable();
            $table->boolean('has_prerequisite')->default(false);
            $table->unsignedBigInteger('prerequisite_course_id')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('chunk_words')->default(150);
            $table->timestamps();

            $table->foreign('prerequisite_course_id')->references('id')->on('courses');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};