<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lessons', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('course_id');
            $table->string('name');
            $table->text('intro')->nullable();
            $table->integer('order_index')->default(0);
            $table->boolean('share_enabled')->default(false);
            $table->enum('share_type', ['upload', 'link'])->nullable();
            $table->string('share_url', 1024)->nullable();
            $table->string('share_filename')->nullable();
            $table->integer('share_size')->nullable();
            $table->timestamps();

            $table->foreign('course_id')->references('id')->on('courses');
            $table->index(['course_id', 'order_index', 'id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lessons');
    }
};