<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('site_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique(); // Setting key (e.g., 'site_name', 'logo_path')
            $table->text('value')->nullable(); // Setting value
            $table->string('type')->default('text'); // text, image, color, textarea, etc.
            $table->string('group')->default('general'); // Group settings (general, seo, branding, theme)
            $table->text('description')->nullable(); // Help text for admins
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('site_settings');
    }
};
