<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('course_survey_responses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('course_survey_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('course_id')->constrained()->onDelete('cascade');
            $table->json('responses')->comment('Student answers to survey questions');
            $table->integer('overall_rating')->nullable()->comment('1-5 star rating');
            $table->text('suggestions')->nullable()->comment('Student suggestions for improvement');
            $table->timestamps();
            
            // Student can only submit once per survey
            $table->unique(['course_survey_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('course_survey_responses');
    }
};
