<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->string('survey_mode')->default('feedback')->after('enable_course_survey'); // 'feedback' or 'survey'
            $table->string('survey_title')->nullable()->after('survey_mode');
            $table->text('survey_description')->nullable()->after('survey_title');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->dropColumn(['survey_mode', 'survey_title', 'survey_description']);
        });
    }
};
