<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            // Check if columns don't exist before adding
            if (!Schema::hasColumn('course_enrollments', 'user_id')) {
                $table->foreignId('user_id')->after('id')->constrained()->onDelete('cascade');
            }
            if (!Schema::hasColumn('course_enrollments', 'course_id')) {
                $table->foreignId('course_id')->after('user_id')->constrained()->onDelete('cascade');
            }
            if (!Schema::hasColumn('course_enrollments', 'status')) {
                $table->enum('status', ['enrolled', 'in-progress', 'completed', 'dropped'])->after('course_id')->default('enrolled');
            }
            if (!Schema::hasColumn('course_enrollments', 'enrolled_at')) {
                $table->timestamp('enrolled_at')->after('status')->useCurrent();
            }
            if (!Schema::hasColumn('course_enrollments', 'completed_at')) {
                $table->timestamp('completed_at')->after('enrolled_at')->nullable();
            }
            if (!Schema::hasColumn('course_enrollments', 'progress')) {
                $table->decimal('progress', 5, 2)->after('completed_at')->default(0);
            }
        });
        
        // Add unique constraint if it doesn't exist
        try {
            Schema::table('course_enrollments', function (Blueprint $table) {
                $table->unique(['user_id', 'course_id']);
            });
        } catch (\Exception $e) {
            // Unique constraint might already exist
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['course_id']);
            $table->dropUnique(['user_id', 'course_id']);
            $table->dropColumn(['user_id', 'course_id', 'status', 'enrolled_at', 'completed_at', 'progress']);
        });
    }
};
