<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->unsignedBigInteger('language_id')->nullable()->after('created_by');
            $table->foreign('language_id')->references('id')->on('languages')->onDelete('set null');
            $table->index(['language_id', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->dropForeign(['language_id']);
            $table->dropIndex(['language_id', 'is_active']);
            $table->dropColumn('language_id');
        });
    }
};
