<?php

namespace Database\Seeders;

use App\Models\Badge;
use Illuminate\Database\Seeder;

class BadgeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $badges = [
            // BEGINNER BADGES
            [
                'name' => 'First Steps',
                'description' => 'Complete your first course',
                'icon' => '🎯',
                'type' => 'achievement',
                'category' => 'course',
                'criteria' => ['type' => 'course_completion', 'first_course' => true],
                'points' => 10,
                'color' => '#4CAF50',
                'order' => 1,
            ],
            [
                'name' => 'Quick Learner',
                'description' => 'Complete 5 courses',
                'icon' => '⚡',
                'type' => 'achievement',
                'category' => 'course',
                'criteria' => ['type' => 'course_count', 'required_count' => 5],
                'points' => 50,
                'color' => '#FFC107',
                'required_count' => 5,
                'order' => 2,
            ],
            [
                'name' => 'Dedicated Student',
                'description' => 'Complete 10 courses',
                'icon' => '📚',
                'type' => 'achievement',
                'category' => 'course',
                'criteria' => ['type' => 'course_count', 'required_count' => 10],
                'points' => 100,
                'color' => '#2196F3',
                'required_count' => 10,
                'order' => 3,
            ],
            [
                'name' => 'Master Learner',
                'description' => 'Complete 25 courses',
                'icon' => '🏆',
                'type' => 'achievement',
                'category' => 'course',
                'criteria' => ['type' => 'course_count', 'required_count' => 25],
                'points' => 250,
                'color' => '#FF9800',
                'required_count' => 25,
                'order' => 4,
            ],
            [
                'name' => 'Legend',
                'description' => 'Complete 50 courses',
                'icon' => '👑',
                'type' => 'achievement',
                'category' => 'course',
                'criteria' => ['type' => 'course_count', 'required_count' => 50],
                'points' => 500,
                'color' => '#9C27B0',
                'required_count' => 50,
                'order' => 5,
            ],

            // LESSON BADGES
            [
                'name' => 'Lesson Explorer',
                'description' => 'Complete 10 lessons',
                'icon' => '🗺️',
                'type' => 'achievement',
                'category' => 'lesson',
                'criteria' => ['type' => 'lesson_count', 'required_count' => 10],
                'points' => 25,
                'color' => '#00BCD4',
                'required_count' => 10,
                'order' => 6,
            ],
            [
                'name' => 'Knowledge Seeker',
                'description' => 'Complete 50 lessons',
                'icon' => '🔍',
                'type' => 'achievement',
                'category' => 'lesson',
                'criteria' => ['type' => 'lesson_count', 'required_count' => 50],
                'points' => 100,
                'color' => '#3F51B5',
                'required_count' => 50,
                'order' => 7,
            ],
            [
                'name' => 'Content Master',
                'description' => 'Complete 100 lessons',
                'icon' => '📖',
                'type' => 'achievement',
                'category' => 'lesson',
                'criteria' => ['type' => 'lesson_count', 'required_count' => 100],
                'points' => 200,
                'color' => '#673AB7',
                'required_count' => 100,
                'order' => 8,
            ],

            // QUIZ BADGES
            [
                'name' => 'Perfect Score',
                'description' => 'Get 100% on any quiz',
                'icon' => '💯',
                'type' => 'achievement',
                'category' => 'quiz',
                'criteria' => ['type' => 'perfect_score'],
                'points' => 20,
                'color' => '#4CAF50',
                'order' => 9,
            ],
            [
                'name' => 'High Achiever',
                'description' => 'Score 90% or above on a quiz',
                'icon' => '⭐',
                'type' => 'achievement',
                'category' => 'quiz',
                'criteria' => ['type' => 'quiz_score', 'min_score' => 90],
                'points' => 15,
                'color' => '#FFEB3B',
                'order' => 10,
            ],
            [
                'name' => 'Quiz Master',
                'description' => 'Score 80% or above on a quiz',
                'icon' => '🎓',
                'type' => 'achievement',
                'category' => 'quiz',
                'criteria' => ['type' => 'quiz_score', 'min_score' => 80],
                'points' => 10,
                'color' => '#8BC34A',
                'order' => 11,
            ],

            // SPEED BADGES
            [
                'name' => 'Speed Demon',
                'description' => 'Complete a course in less than 24 hours',
                'icon' => '🏃',
                'type' => 'achievement',
                'category' => 'speed',
                'criteria' => ['type' => 'speed_completion', 'max_hours' => 24],
                'points' => 30,
                'color' => '#FF5722',
                'order' => 12,
            ],
            [
                'name' => 'Lightning Fast',
                'description' => 'Complete a course in less than 12 hours',
                'icon' => '⚡',
                'type' => 'achievement',
                'category' => 'speed',
                'criteria' => ['type' => 'speed_completion', 'max_hours' => 12],
                'points' => 50,
                'color' => '#FF9800',
                'order' => 13,
            ],

            // SPECIAL BADGES
            [
                'name' => 'Early Bird',
                'description' => 'Complete a lesson before 8 AM',
                'icon' => '🌅',
                'type' => 'special',
                'category' => 'time',
                'criteria' => ['type' => 'early_completion'],
                'points' => 15,
                'color' => '#FF6F00',
                'order' => 14,
            ],
            [
                'name' => 'Night Owl',
                'description' => 'Complete a lesson after 10 PM',
                'icon' => '🦉',
                'type' => 'special',
                'category' => 'time',
                'criteria' => ['type' => 'late_completion'],
                'points' => 15,
                'color' => '#512DA8',
                'order' => 15,
            ],
            [
                'name' => 'Weekend Warrior',
                'description' => 'Complete a course on weekend',
                'icon' => '🎖️',
                'type' => 'special',
                'category' => 'time',
                'criteria' => ['type' => 'weekend_completion'],
                'points' => 20,
                'color' => '#00695C',
                'order' => 16,
            ],
            [
                'name' => 'Comeback Kid',
                'description' => 'Return after 30 days and complete a course',
                'icon' => '🔄',
                'type' => 'special',
                'category' => 'engagement',
                'criteria' => ['type' => 'return_completion'],
                'points' => 25,
                'color' => '#00897B',
                'order' => 17,
            ],

            // ELECTRICAL ENGINEERING SPECIFIC
            [
                'name' => 'Circuit Breaker',
                'description' => 'Complete 3 circuit-related courses',
                'icon' => '⚡',
                'type' => 'achievement',
                'category' => 'ee_specific',
                'criteria' => ['type' => 'category_courses', 'category' => 'circuit', 'required_count' => 3],
                'points' => 75,
                'color' => '#FFD700',
                'required_count' => 3,
                'order' => 18,
            ],
            [
                'name' => 'Power Pro',
                'description' => 'Complete 3 power systems courses',
                'icon' => '🔌',
                'type' => 'achievement',
                'category' => 'ee_specific',
                'criteria' => ['type' => 'category_courses', 'category' => 'power', 'required_count' => 3],
                'points' => 75,
                'color' => '#FF4081',
                'required_count' => 3,
                'order' => 19,
            ],
            [
                'name' => 'Digital Guru',
                'description' => 'Complete 3 digital electronics courses',
                'icon' => '💻',
                'type' => 'achievement',
                'category' => 'ee_specific',
                'criteria' => ['type' => 'category_courses', 'category' => 'digital', 'required_count' => 3],
                'points' => 75,
                'color' => '#1E88E5',
                'required_count' => 3,
                'order' => 20,
            ],
        ];

        foreach ($badges as $badge) {
            Badge::updateOrCreate(
                ['name' => $badge['name']],
                $badge
            );
        }

        $this->command->info('✅ Created ' . count($badges) . ' badges successfully!');
        $this->command->line('');
        $this->command->info('Badge Categories:');
        $this->command->line('  🎯 Course Completion Badges: 5');
        $this->command->line('  📚 Lesson Badges: 3');
        $this->command->line('  💯 Quiz Badges: 3');
        $this->command->line('  ⚡ Speed Badges: 2');
        $this->command->line('  🌟 Special Badges: 4');
        $this->command->line('  ⚡ EE-Specific Badges: 3');
        $this->command->line('');
        $this->command->info('Total Points Available: ' . collect($badges)->sum('points'));
    }
}
