<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class LanguagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $languages = [
            [
                'name' => 'English',
                'code' => 'en',
                'native_name' => 'English',
                'flag_emoji' => '🇬🇧',
                'is_active' => true,
                'is_default' => true,
                'order_index' => 1,
            ],
            [
                'name' => 'French',
                'code' => 'fr',
                'native_name' => 'Français',
                'flag_emoji' => '🇫🇷',
                'is_active' => true,
                'is_default' => false,
                'order_index' => 2,
            ],
            [
                'name' => 'Spanish',
                'code' => 'es',
                'native_name' => 'Español',
                'flag_emoji' => '🇪🇸',
                'is_active' => true,
                'is_default' => false,
                'order_index' => 3,
            ],
            [
                'name' => 'German',
                'code' => 'de',
                'native_name' => 'Deutsch',
                'flag_emoji' => '🇩🇪',
                'is_active' => false,
                'is_default' => false,
                'order_index' => 4,
            ],
            [
                'name' => 'Portuguese',
                'code' => 'pt',
                'native_name' => 'Português',
                'flag_emoji' => '🇵🇹',
                'is_active' => false,
                'is_default' => false,
                'order_index' => 5,
            ],
        ];

        foreach ($languages as $language) {
            \App\Models\Language::updateOrCreate(
                ['code' => $language['code']],
                $language
            );
        }

        // Add multi-language setting
        \App\Models\SiteSetting::updateOrCreate(
            ['key' => 'enable_multi_language'],
            [
                'value' => 'false',
                'type' => 'boolean',
                'group' => 'courses',
                'description' => 'Enable multi-language course system'
            ]
        );

        // Set all existing courses to default language (English)
        $defaultLanguage = \App\Models\Language::where('is_default', true)->first();
        if ($defaultLanguage) {
            \App\Models\Course::whereNull('language_id')->update(['language_id' => $defaultLanguage->id]);
        }
    }
}
