<?php

namespace Database\Seeders;

use App\Models\PenaltyRule;
use Illuminate\Database\Seeder;

class PenaltyRuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $rules = [
            [
                'name' => '3-Day Inactivity Yellow Card',
                'description' => 'Yellow card issued after 3 consecutive days of inactivity',
                'card_type' => 'yellow',
                'trigger_type' => 'inactivity_days',
                'threshold_value' => 3,
                'points_deduction' => 5,
                'escalation_days' => 7,
                'escalation_points' => 10,
                'is_active' => true,
                'order' => 1
            ],
            [
                'name' => '7-Day Inactivity Second Yellow Card',
                'description' => 'Second yellow card after 7 days of continued inactivity',
                'card_type' => 'yellow',
                'trigger_type' => 'inactivity_days',
                'threshold_value' => 7,
                'points_deduction' => 10,
                'escalation_days' => 5,
                'escalation_points' => 20,
                'is_active' => true,
                'order' => 2
            ],
            [
                'name' => '14-Day Inactivity Red Card',
                'description' => 'Red card issued after 14 days of total inactivity - all points removed',
                'card_type' => 'red',
                'trigger_type' => 'inactivity_days',
                'threshold_value' => 14,
                'points_deduction' => 100, // Effectively removes all typical badge points
                'escalation_days' => null,
                'escalation_points' => null,
                'is_active' => true,
                'order' => 3
            ],
            [
                'name' => '5-Day Inactivity Yellow Card (Strict)',
                'description' => 'Stricter yellow card for students who need more accountability',
                'card_type' => 'yellow',
                'trigger_type' => 'inactivity_days',
                'threshold_value' => 5,
                'points_deduction' => 8,
                'escalation_days' => 3,
                'escalation_points' => 15,
                'is_active' => false, // Disabled by default
                'order' => 4
            ],
            [
                'name' => 'Weekend Missed Yellow Card',
                'description' => 'Yellow card for missing scheduled weekend lessons',
                'card_type' => 'yellow',
                'trigger_type' => 'missed_deadline',
                'threshold_value' => 2,
                'points_deduction' => 10,
                'escalation_days' => 7,
                'escalation_points' => 15,
                'is_active' => false, // Disabled by default (requires deadline tracking)
                'order' => 5
            ],
        ];

        foreach ($rules as $rule) {
            PenaltyRule::create($rule);
        }

        $this->command->info('✅ Penalty rules seeded successfully!');
        $this->command->info('');
        $this->command->info('Created penalty rules:');
        $this->command->info('  ⚠️  Yellow Cards: ' . PenaltyRule::where('card_type', 'yellow')->count());
        $this->command->info('  🚫 Red Cards: ' . PenaltyRule::where('card_type', 'red')->count());
        $this->command->info('  ✅ Active Rules: ' . PenaltyRule::where('is_active', true)->count());
        $this->command->info('  ⏸️  Inactive Rules: ' . PenaltyRule::where('is_active', false)->count());
    }
}
