<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\CustomPage;
use App\Models\User;

class StaticPagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get first admin user or create a system user
        $adminUser = User::where('is_admin', 1)->first();
        $userId = $adminUser ? $adminUser->id : 1;

        // Home Page - Complete frontend sections
        CustomPage::updateOrCreate(
            ['slug' => 'home'],
            [
                'title' => 'Home',
                'content' => [
                    // 1. Hero Section with Stats
                    [
                        'type' => 'hero',
                        'content' => [
                            'heading' => 'Transform Your Future with Quality Education',
                            'subheading' => 'Join thousands of learners worldwide. Access premium courses, earn certificates, and unlock your potential with our comprehensive learning platform.',
                            'background' => 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                            'text_color' => '#ffffff',
                            'button_text' => 'Get Started Free',
                            'button_link' => '/register'
                        ]
                    ],
                    [
                        'type' => 'stats',
                        'content' => [
                            'stats' => [
                                ['number' => '10,000+', 'label' => 'Active Students'],
                                ['number' => '500+', 'label' => 'Expert Instructors'],
                                ['number' => '1,200+', 'label' => 'Quality Courses']
                            ]
                        ]
                    ],
                    [
                        'type' => 'spacer',
                        'content' => ['height' => '50px']
                    ],
                    
                    // 2. Features Section (6 features like frontend)
                    [
                        'type' => 'features',
                        'content' => [
                            'heading' => 'Why Choose EE Micro LMS?',
                            'features' => [
                                [
                                    'icon' => '🎥',
                                    'title' => 'HD Video Lessons',
                                    'description' => 'Crystal clear video content with interactive elements to enhance your learning experience.'
                                ],
                                [
                                    'icon' => '📜',
                                    'title' => 'Verified Certificates',
                                    'description' => 'Earn industry-recognized certificates upon course completion to boost your career.'
                                ],
                                [
                                    'icon' => '�‍🏫',
                                    'title' => 'Expert Instructors',
                                    'description' => 'Learn from industry professionals with years of real-world experience.'
                                ],
                                [
                                    'icon' => '📱',
                                    'title' => 'Mobile Learning',
                                    'description' => 'Access your courses anytime, anywhere on any device with our mobile-friendly platform.'
                                ],
                                [
                                    'icon' => '💬',
                                    'title' => 'Community Support',
                                    'description' => 'Connect with fellow learners and instructors in our vibrant learning community.'
                                ],
                                [
                                    'icon' => '♾️',
                                    'title' => 'Lifetime Access',
                                    'description' => 'Get unlimited access to course materials with no time restrictions.'
                                ]
                            ]
                        ]
                    ],
                    [
                        'type' => 'spacer',
                        'content' => ['height' => '80px']
                    ],
                    
                    // 3. Popular Courses Section - using course_list
                    [
                        'type' => 'heading',
                        'content' => [
                            'text' => 'Popular Courses',
                            'level' => 'h2',
                            'align' => 'center'
                        ]
                    ],
                    [
                        'type' => 'text',
                        'content' => [
                            'html' => '<p style="text-align: center; color: #6c757d; font-size: 18px; margin-bottom: 40px;">Discover our most-loved courses that are transforming careers</p>'
                        ]
                    ],
                    [
                        'type' => 'course_list',
                        'content' => [
                            'heading' => 'Featured Courses',
                            'description' => 'Showing top rated courses',
                            'limit' => 3,
                            'show_images' => true
                        ]
                    ],
                    [
                        'type' => 'spacer',
                        'content' => ['height' => '80px']
                    ],
                    
                    // 4. Testimonials Section (3 testimonials like frontend)
                    [
                        'type' => 'testimonials',
                        'content' => [
                            'heading' => 'What Our Students Say',
                            'testimonials' => [
                                [
                                    'text' => 'EE Micro LMS transformed my career! The courses are well-structured, and the instructors are incredibly knowledgeable. I landed my dream job within 3 months of completing the bootcamp.',
                                    'author' => 'Sarah Johnson',
                                    'role' => 'Full Stack Developer',
                                    'avatar' => 'SJ',
                                    'rating' => 5
                                ],
                                [
                                    'text' => 'The flexibility of learning at my own pace while working full-time was a game-changer. The community support and practical projects made all the difference in my learning journey.',
                                    'author' => 'Michael Patel',
                                    'role' => 'Data Analyst',
                                    'avatar' => 'MP',
                                    'rating' => 5
                                ],
                                [
                                    'text' => 'Best investment I\'ve made in my education! The quality of content, hands-on projects, and career support exceeded my expectations. Highly recommend to anyone looking to upskill.',
                                    'author' => 'Emily Chen',
                                    'role' => 'UX Designer',
                                    'avatar' => 'EC',
                                    'rating' => 5
                                ]
                            ]
                        ]
                    ],
                    [
                        'type' => 'spacer',
                        'content' => ['height' => '80px']
                    ],
                    
                    // 5. CTA Banner
                    [
                        'type' => 'cta',
                        'content' => [
                            'heading' => 'Ready to Start Your Learning Journey?',
                            'text' => 'Join thousands of students already learning on EE Micro LMS',
                            'button_text' => 'Create Free Account',
                            'button_link' => '/register',
                            'background' => '#667eea'
                        ]
                    ]
                ],
                'meta_description' => 'Welcome to EE Micro LMS - Your complete learning management solution with comprehensive courses and certificates.',
                'meta_keywords' => 'learning, courses, education, online learning, LMS',
                'template' => 'full-width',
                'is_published' => 1,
                'is_static' => 1, // Mark as system page
                'order' => 0,
                'published_at' => now(),
                'created_by' => $userId,
                'updated_by' => $userId,
            ]
        );

        // About Page
        CustomPage::updateOrCreate(
            ['slug' => 'about'],
            [
                'title' => 'About Us',
                'content' => [
                    [
                        'type' => 'hero',
                        'content' => [
                            'heading' => 'About EE Micro LMS',
                            'subheading' => 'Empowering learners worldwide',
                            'background' => 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                            'text_color' => '#ffffff'
                        ]
                    ],
                    [
                        'type' => 'text',
                        'content' => [
                            'html' => '<h2>Our Mission</h2><p>We are dedicated to providing high-quality education and training through our innovative learning management system. Our mission is to make learning accessible, engaging, and effective for everyone.</p><h3>What We Offer</h3><ul><li>Industry-leading courses</li><li>Expert instructors</li><li>Interactive learning experiences</li><li>Recognized certifications</li><li>24/7 support</li></ul>'
                        ]
                    ],
                    [
                        'type' => 'stats',
                        'content' => [
                            'stats' => [
                                ['number' => '10,000+', 'label' => 'Students'],
                                ['number' => '500+', 'label' => 'Courses'],
                                ['number' => '50+', 'label' => 'Instructors'],
                                ['number' => '95%', 'label' => 'Success Rate']
                            ]
                        ]
                    ]
                ],
                'meta_description' => 'Learn about EE Micro LMS - Our mission, values, and commitment to quality education.',
                'meta_keywords' => 'about, company, mission, education, learning platform',
                'template' => 'default',
                'is_published' => 1,
                'is_static' => 1,
                'order' => 10,
                'published_at' => now(),
                'created_by' => $userId,
                'updated_by' => $userId,
            ]
        );

        // Courses Page
        CustomPage::updateOrCreate(
            ['slug' => 'courses'],
            [
                'title' => 'Courses',
                'content' => [
                    [
                        'type' => 'hero',
                        'content' => [
                            'heading' => 'Our Courses',
                            'subheading' => 'Choose from hundreds of courses in various categories',
                            'background' => 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                            'text_color' => '#ffffff'
                        ]
                    ],
                    [
                        'type' => 'text',
                        'content' => [
                            'html' => '<p>Explore our comprehensive course catalog. Each course is designed by industry experts and includes interactive lessons, quizzes, and hands-on projects.</p>'
                        ]
                    ],
                    [
                        'type' => 'course_list',
                        'content' => [
                            'heading' => 'Available Courses',
                            'description' => 'Browse all available courses below. Click on any course to learn more and enroll.'
                        ]
                    ]
                ],
                'meta_description' => 'Browse all available courses on EE Micro LMS - Find the perfect course to advance your skills.',
                'meta_keywords' => 'courses, training, learning, education, online courses',
                'template' => 'default',
                'is_published' => 1,
                'is_static' => 1,
                'order' => 20,
                'published_at' => now(),
                'created_by' => $userId,
                'updated_by' => $userId,
            ]
        );

        // Contact Page
        CustomPage::updateOrCreate(
            ['slug' => 'contact'],
            [
                'title' => 'Contact Us',
                'content' => [
                    [
                        'type' => 'hero',
                        'content' => [
                            'heading' => 'Get in Touch',
                            'subheading' => 'We\'d love to hear from you',
                            'background' => 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                            'text_color' => '#ffffff'
                        ]
                    ],
                    [
                        'type' => 'two_column',
                        'content' => [
                            'left' => [
                                'type' => 'contact_info',
                                'html' => '<h3>Contact Information</h3><p><strong>Email:</strong> support@eelms.com</p><p><strong>Phone:</strong> +1 (555) 123-4567</p><p><strong>Address:</strong> 123 Learning Street, Education City, EC 12345</p><p><strong>Hours:</strong> Monday - Friday, 9:00 AM - 5:00 PM EST</p>'
                            ],
                            'right' => [
                                'type' => 'contact_form',
                                'html' => '<h3>Send us a Message</h3><form class="contact-form"><div class="form-group"><label>Name</label><input type="text" name="name" required></div><div class="form-group"><label>Email</label><input type="email" name="email" required></div><div class="form-group"><label>Subject</label><input type="text" name="subject" required></div><div class="form-group"><label>Message</label><textarea name="message" rows="5" required></textarea></div><button type="submit" class="btn btn-primary">Send Message</button></form>'
                            ]
                        ]
                    ]
                ],
                'meta_description' => 'Contact EE Micro LMS - Get in touch with our team for support, inquiries, or feedback.',
                'meta_keywords' => 'contact, support, help, inquiries, customer service',
                'template' => 'default',
                'is_published' => 1,
                'is_static' => 1,
                'order' => 30,
                'published_at' => now(),
                'created_by' => $userId,
                'updated_by' => $userId,
            ]
        );

        $this->command->info('Static pages seeded successfully!');
    }
}
