<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create roles if they don't exist
        if (!DB::table('roles')->where('name', 'admin')->exists()) {
            DB::table('roles')->insert([
                ['name' => 'admin', 'guard_name' => 'web', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'tutor', 'guard_name' => 'web', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'user', 'guard_name' => 'web', 'created_at' => now(), 'updated_at' => now()],
            ]);
        }

        // Create admin user
        $admin = User::create([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
        ]);

        // Assign admin role
        DB::table('model_has_roles')->insert([
            'role_id' => DB::table('roles')->where('name', 'admin')->value('id'),
            'model_type' => 'App\Models\User',
            'model_id' => $admin->id,
        ]);

        // Create tutor user
        $tutor = User::create([
            'name' => 'Tutor User',
            'email' => 'tutor@example.com',
            'password' => Hash::make('password'),
        ]);

        // Assign tutor role
        DB::table('model_has_roles')->insert([
            'role_id' => DB::table('roles')->where('name', 'tutor')->value('id'),
            'model_type' => 'App\Models\User',
            'model_id' => $tutor->id,
        ]);

        // Create regular user
        $user = User::create([
            'name' => 'Regular User',
            'email' => 'user@example.com',
            'password' => Hash::make('password'),
        ]);

        // Assign user role
        DB::table('model_has_roles')->insert([
            'role_id' => DB::table('roles')->where('name', 'user')->value('id'),
            'model_type' => 'App\Models\User',
            'model_id' => $user->id,
        ]);
    }
}
