#!/bin/bash

echo "=========================================="
echo "EE Induction LMS - Quick Installer"
echo "=========================================="
echo ""

# Check if .env exists
if [ ! -f .env ]; then
    echo "Creating .env file from example..."
    cp .env.example .env
    echo "✓ .env file created"
else
    echo "! .env file already exists, skipping..."
fi

# Install PHP dependencies
echo ""
echo "Installing PHP dependencies..."
if command -v composer &> /dev/null; then
    composer install --optimize-autoloader --no-dev
    echo "✓ PHP dependencies installed"
else
    echo "! Composer not found. Please install manually:"
    echo "  composer install --optimize-autoloader --no-dev"
fi

# Generate application key
echo ""
echo "Generating application key..."
php artisan key:generate
echo "✓ Application key generated"

# Install Node dependencies
echo ""
echo "Installing Node.js dependencies..."
if command -v npm &> /dev/null; then
    npm install
    echo "✓ Node dependencies installed"
else
    echo "! npm not found. Please install manually:"
    echo "  npm install"
fi

# Build assets
echo ""
echo "Building frontend assets..."
if command -v npm &> /dev/null; then
    npm run build
    echo "✓ Assets built successfully"
else
    echo "! Please build assets manually:"
    echo "  npm run build"
fi

# Set permissions
echo ""
echo "Setting file permissions..."
chmod -R 775 storage bootstrap/cache
echo "✓ Permissions set"

# Create storage link
echo ""
echo "Creating storage link..."
php artisan storage:link
echo "✓ Storage link created"

echo ""
echo "=========================================="
echo "Installation Complete!"
echo "=========================================="
echo ""
echo "Next steps:"
echo "1. Configure your .env file with database credentials"
echo "2. Run: php artisan migrate --force"
echo "3. Run: php artisan optimize"
echo "4. Visit your domain in a browser"
echo ""
echo "See DEPLOYMENT_PACKAGE_GUIDE.txt for detailed instructions."
echo ""
