<style>
    .payment-settings-wrapper {
        padding: 20px;
        background: #f5f5f5;
        min-height: 400px;
    }

    .payment-header {
        margin-bottom: 30px;
    }

    .payment-header h2 {
        color: #2c3e50;
        font-size: 1.8em;
        margin-bottom: 10px;
        font-weight: 600;
    }

    .payment-header p {
        color: #7f8c8d;
        font-size: 1em;
        margin: 0;
    }

    .gateway-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
        gap: 25px;
        margin-top: 30px;
    }

    .gateway-card {
        background: white;
        border-radius: 15px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        transition: all 0.3s;
    }

    .gateway-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 40px rgba(0,0,0,0.3);
    }

    .gateway-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 25px;
        padding-bottom: 20px;
        border-bottom: 2px solid #f0f0f0;
    }

    .gateway-title {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .gateway-icon {
        width: 50px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 10px;
        font-size: 24px;
    }

    .gateway-icon.stripe { background: linear-gradient(135deg, #635bff 0%, #4f46e5 100%); color: white; }
    .gateway-icon.paypal { background: linear-gradient(135deg, #0070ba 0%, #003087 100%); color: white; }
    .gateway-icon.paystack { background: linear-gradient(135deg, #00c3f8 0%, #0097d6 100%); color: white; }
    .gateway-icon.crypto { background: linear-gradient(135deg, #f7931a 0%, #f2a900 100%); color: white; }

    .gateway-name h3 {
        color: #333;
        font-size: 1.5em;
        margin: 0;
    }

    .gateway-status {
        font-size: 0.85em;
        padding: 5px 15px;
        border-radius: 20px;
        font-weight: 600;
        display: inline-block;
        margin-top: 5px;
    }

    .status-enabled {
        background: #d4edda;
        color: #155724;
    }

    .status-disabled {
        background: #f8d7da;
        color: #721c24;
    }

    .toggle-switch {
        position: relative;
        width: 60px;
        height: 30px;
        background: #ccc;
        border-radius: 15px;
        cursor: pointer;
        transition: all 0.3s;
    }

    .toggle-switch.active {
        background: #4CAF50;
    }

    .toggle-switch-slider {
        position: absolute;
        top: 3px;
        left: 3px;
        width: 24px;
        height: 24px;
        background: white;
        border-radius: 50%;
        transition: all 0.3s;
    }

    .toggle-switch.active .toggle-switch-slider {
        left: 33px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        color: #333;
        font-weight: 600;
        margin-bottom: 8px;
        font-size: 0.95em;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 0.95em;
        transition: all 0.3s;
        box-sizing: border-box;
    }

    .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-select {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 0.95em;
        background: white;
        cursor: pointer;
        box-sizing: border-box;
    }

    .btn {
        padding: 12px 25px;
        border: none;
        border-radius: 8px;
        font-size: 1em;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        justify-content: center;
    }

    .btn-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
    }

    .alert {
        padding: 15px 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        display: none;
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border-left: 4px solid #28a745;
    }

    .alert-error {
        background: #f8d7da;
        color: #721c24;
        border-left: 4px solid #dc3545;
    }

    .mode-badge {
        display: inline-block;
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 0.8em;
        font-weight: 600;
        margin-left: 10px;
    }

    .mode-sandbox {
        background: #fff3cd;
        color: #856404;
    }

    .mode-live {
        background: #d4edda;
        color: #155724;
    }

    .webhook-url {
        background: #f8f9fa;
        padding: 12px 15px;
        border-radius: 8px;
        font-family: 'Courier New', monospace;
        font-size: 0.85em;
        color: #495057;
        word-break: break-all;
        border: 1px solid #dee2e6;
    }

    .copy-btn {
        padding: 8px 15px;
        background: #6c757d;
        color: white;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        font-size: 0.85em;
        margin-top: 8px;
        transition: all 0.3s;
    }

    .copy-btn:hover {
        background: #5a6268;
    }

    .info-box {
        background: #e7f3ff;
        border-left: 4px solid #2196F3;
        padding: 15px;
        border-radius: 8px;
        margin-top: 15px;
    }

    .info-box h4 {
        color: #1976D2;
        margin-bottom: 8px;
        font-size: 0.95em;
        margin-top: 0;
    }

    .info-box p {
        color: #666;
        font-size: 0.85em;
        line-height: 1.6;
        margin: 0;
    }

    @media (max-width: 768px) {
        .gateway-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="payment-settings-wrapper">
    <div class="payment-header">
        <h2>
            <i class="fas fa-credit-card"></i>
            Payment Gateway Settings
        </h2>
        <p>Configure and manage payment gateways for course purchases</p>
        <button type="button" onclick="console.log('Test button clicked'); window.showPaymentAlert('Test alert working!', 'success')" class="btn btn-primary" style="margin-top: 10px; font-size: 0.8em;">Test Functions</button>
    </div>

    <div id="alertContainer"></div>

    <div class="gateway-grid">
        @foreach($settings as $key => $setting)
        <div class="gateway-card" data-gateway="{{ $key }}">
            <div class="gateway-header">
                <div class="gateway-title">
                    <div class="gateway-icon {{ $key }}">
                        @if($key === 'stripe')
                            <i class="fab fa-stripe"></i>
                        @elseif($key === 'paypal')
                            <i class="fab fa-paypal"></i>
                        @elseif($key === 'paystack')
                            <i class="fas fa-wallet"></i>
                        @elseif($key === 'crypto')
                            <i class="fab fa-bitcoin"></i>
                        @endif
                    </div>
                    <div class="gateway-name">
                        <h3>{{ $gateways[$key] }}</h3>
                        <span class="gateway-status {{ $setting->is_enabled ? 'status-enabled' : 'status-disabled' }}">
                            {{ $setting->is_enabled ? 'Enabled' : 'Disabled' }}
                        </span>
                        <span class="mode-badge {{ $setting->mode === 'live' ? 'mode-live' : 'mode-sandbox' }}">
                            {{ strtoupper($setting->mode) }}
                        </span>
                    </div>
                </div>
                <div class="toggle-switch {{ $setting->is_enabled ? 'active' : '' }}" 
                     onclick="console.log('Toggle clicked for {{ $key }}'); window.toggleGateway('{{ $key }}', this)">
                    <div class="toggle-switch-slider"></div>
                </div>
            </div>

            <form id="form-{{ $key }}" onsubmit="console.log('Form submitted for {{ $key }}'); window.saveGatewaySettings(event, '{{ $key }}')">
                <div class="form-group">
                    <label>Mode</label>
                    <select name="mode" class="form-select" required>
                        <option value="sandbox" {{ $setting->mode === 'sandbox' ? 'selected' : '' }}>Sandbox (Test)</option>
                        <option value="live" {{ $setting->mode === 'live' ? 'selected' : '' }}>Live (Production)</option>
                    </select>
                </div>

                @if($key === 'stripe')
                <div class="form-group">
                    <label>Publishable Key</label>
                    <input type="text" name="public_key" class="form-control" 
                           placeholder="pk_test_..." {{ $setting->is_enabled ? 'required' : '' }}
                           value="{{ $setting->public_key ? Crypt::decryptString($setting->public_key) : '' }}">
                </div>
                <div class="form-group">
                    <label>Secret Key</label>
                    <input type="password" name="secret_key" class="form-control" 
                           placeholder="sk_test_..." {{ $setting->is_enabled ? 'required' : '' }}
                           value="{{ $setting->secret_key ? Crypt::decryptString($setting->secret_key) : '' }}">
                </div>
                <div class="form-group">
                    <label>Webhook Secret</label>
                    <input type="password" name="webhook_secret" class="form-control" 
                           placeholder="whsec_..."
                           value="{{ $setting->webhook_secret ? Crypt::decryptString($setting->webhook_secret) : '' }}">
                </div>

                @elseif($key === 'paypal')
                <div class="form-group">
                    <label>Client ID</label>
                    <input type="text" name="public_key" class="form-control" 
                           placeholder="Your PayPal Client ID" {{ $setting->is_enabled ? 'required' : '' }}
                           value="{{ $setting->public_key ? Crypt::decryptString($setting->public_key) : '' }}">
                </div>
                <div class="form-group">
                    <label>Secret</label>
                    <input type="password" name="secret_key" class="form-control" 
                           placeholder="Your PayPal Secret" {{ $setting->is_enabled ? 'required' : '' }}
                           value="{{ $setting->secret_key ? Crypt::decryptString($setting->secret_key) : '' }}">
                </div>

                @elseif($key === 'paystack')
                <div class="form-group">
                    <label>Public Key</label>
                    <input type="text" name="public_key" class="form-control" 
                           placeholder="pk_test_..." {{ $setting->is_enabled ? 'required' : '' }}
                           value="{{ $setting->public_key ? Crypt::decryptString($setting->public_key) : '' }}">
                </div>
                <div class="form-group">
                    <label>Secret Key</label>
                    <input type="password" name="secret_key" class="form-control" 
                           placeholder="sk_test_..." {{ $setting->is_enabled ? 'required' : '' }}
                           value="{{ $setting->secret_key ? Crypt::decryptString($setting->secret_key) : '' }}">
                </div>

                @elseif($key === 'crypto')
                <div class="form-group">
                    <label>API Key</label>
                    <input type="text" name="public_key" class="form-control" 
                           placeholder="Your API Key" {{ $setting->is_enabled ? 'required' : '' }}
                           value="{{ $setting->public_key ? Crypt::decryptString($setting->public_key) : '' }}">
                </div>
                <div class="form-group">
                    <label>API Secret</label>
                    <input type="password" name="secret_key" class="form-control" 
                           placeholder="Your API Secret" {{ $setting->is_enabled ? 'required' : '' }}
                           value="{{ $setting->secret_key ? Crypt::decryptString($setting->secret_key) : '' }}">
                </div>
                @endif

                <div class="info-box">
                    <h4><i class="fas fa-link"></i> Webhook URL</h4>
                    <div class="webhook-url">{{ url('/api/webhooks/' . $key) }}</div>
                    <button type="button" class="copy-btn" onclick="copyWebhookUrl('{{ url('/api/webhooks/' . $key) }}')">
                        <i class="fas fa-copy"></i> Copy URL
                    </button>
                    <p style="margin-top: 10px;">Configure this URL in your {{ $gateways[$key] }} dashboard to receive payment notifications.</p>
                </div>

                <button type="submit" class="btn btn-primary" style="margin-top: 20px; width: 100%;">
                    <i class="fas fa-save"></i>
                    Save {{ $gateways[$key] }} Settings
                </button>
            </form>
        </div>
        @endforeach
    </div>
</div>

<script>
    (function() {
        // Get CSRF token from global variable or meta tag
        const csrfToken = window.csrfToken || document.querySelector('meta[name="csrf-token"]')?.content || '{{ csrf_token() }}';
        
        console.log('Payment settings script loaded, CSRF token:', csrfToken ? 'Found (' + csrfToken.substring(0, 10) + '...)' : 'Missing');
        console.log('Using global csrfToken:', !!window.csrfToken);
        console.log('Meta tag found:', !!document.querySelector('meta[name="csrf-token"]'));
        
        // Define functions in window scope so they're accessible from inline onclick handlers
        window.showPaymentAlert = function(message, type = 'success') {
            const alertContainer = document.getElementById('alertContainer');
            if (!alertContainer) {
                console.error('Alert container not found');
                return;
            }
            
            const alert = document.createElement('div');
            alert.className = `alert alert-${type}`;
            alert.style.display = 'block';
            alert.innerHTML = `
                <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'}"></i>
                ${message}
            `;
            alertContainer.innerHTML = '';
            alertContainer.appendChild(alert);
            
            setTimeout(() => {
                alert.style.display = 'none';
            }, 5000);
        };

        window.toggleGateway = async function(gateway, element) {
            console.log('Toggle gateway called:', gateway, 'Current element classes:', element.className);
            
            // Prevent multiple clicks
            if (element.classList.contains('toggling')) {
                console.log('Toggle already in progress');
                return;
            }
            
            element.classList.add('toggling');
            
            try {
                const response = await fetch('/admin/payment-settings/' + gateway + '/toggle', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken,
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    credentials: 'same-origin'
                });

                const data = await response.json();
                console.log('Toggle response:', data);

                if (data.success) {
                    // Update the toggle switch appearance
                    if (data.is_enabled) {
                        element.classList.add('active');
                    } else {
                        element.classList.remove('active');
                    }
                    
                    // Update the status badge
                    const card = element.closest('.gateway-card');
                    const statusBadge = card.querySelector('.gateway-status');
                    
                    if (data.is_enabled) {
                        statusBadge.textContent = 'Enabled';
                        statusBadge.className = 'gateway-status status-enabled';
                    } else {
                        statusBadge.textContent = 'Disabled';
                        statusBadge.className = 'gateway-status status-disabled';
                    }

                    window.showPaymentAlert(data.message, 'success');
                } else {
                    window.showPaymentAlert('Failed to toggle gateway', 'error');
                }
            } catch (error) {
                console.error('Error toggling gateway:', error);
                window.showPaymentAlert('An error occurred: ' + error.message, 'error');
            } finally {
                element.classList.remove('toggling');
            }
        };

        window.saveGatewaySettings = async function(event, gateway) {
            event.preventDefault();
            console.log('Save gateway settings called:', gateway);
            
            const form = event.target;
            const formData = new FormData(form);
            
            // Get the current toggle state from the UI
            const toggleElement = form.closest('.gateway-card').querySelector('.toggle-switch');
            const isEnabled = toggleElement.classList.contains('active');
            
            const data = {
                is_enabled: isEnabled,
                mode: formData.get('mode'),
                public_key: formData.get('public_key') || null,
                secret_key: formData.get('secret_key') || null,
                webhook_secret: formData.get('webhook_secret') || null
            };

            console.log('Sending data:', { ...data, secret_key: data.secret_key ? '***' : null, webhook_secret: data.webhook_secret ? '***' : null });

            try {
                const response = await fetch('/admin/payment-settings/' + gateway, {
                    method: 'PUT',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken,
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    credentials: 'same-origin',
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                console.log('Save response:', result);

                if (result.success) {
                    window.showPaymentAlert(result.message, 'success');
                    
                    // Update mode badge
                    const card = form.closest('.gateway-card');
                    const modeBadge = card.querySelector('.mode-badge');
                    modeBadge.textContent = data.mode.toUpperCase();
                    modeBadge.className = `mode-badge mode-${data.mode}`;
                    
                    // Update status badge based on the returned data
                    if (result.data && typeof result.data.is_enabled !== 'undefined') {
                        const statusBadge = card.querySelector('.gateway-status');
                        if (result.data.is_enabled) {
                            statusBadge.textContent = 'Enabled';
                            statusBadge.className = 'gateway-status status-enabled';
                            toggleElement.classList.add('active');
                        } else {
                            statusBadge.textContent = 'Disabled';
                            statusBadge.className = 'gateway-status status-disabled';
                            toggleElement.classList.remove('active');
                        }
                    }
                    
                    // Clear password fields for security
                    form.querySelectorAll('input[type="password"]').forEach(input => {
                        input.value = '';
                    });
                } else {
                    window.showPaymentAlert('Failed to save settings', 'error');
                }
            } catch (error) {
                console.error('Error saving gateway:', error);
                window.showPaymentAlert('An error occurred while saving: ' + error.message, 'error');
            }
        };

        window.copyWebhookUrl = function(url) {
            console.log('Copy webhook URL:', url);
            navigator.clipboard.writeText(url).then(() => {
                window.showPaymentAlert('Webhook URL copied to clipboard!', 'success');
            }).catch(err => {
                console.error('Failed to copy:', err);
                window.showPaymentAlert('Failed to copy URL', 'error');
            });
        };

        console.log('Payment settings functions registered on window object');
    })();
</script>
