<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Notification Settings - Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 12px;
            margin-bottom: 25px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header h1 {
            font-size: 28px;
            color: #1e293b;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .header h1 i {
            background: linear-gradient(135deg, #667eea, #764ba2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .back-btn {
            background: #f1f5f9;
            color: #64748b;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .back-btn:hover {
            background: #e2e8f0;
            transform: translateX(-3px);
        }

        .card {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 25px;
        }

        .card h3 {
            font-size: 20px;
            color: #1e293b;
            margin-bottom: 8px;
        }

        .card > p {
            color: #64748b;
            margin-bottom: 20px;
        }

        .toggle-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .toggle-card {
            border-radius: 12px;
            padding: 25px;
            text-align: center;
            transition: all 0.3s;
            border: 2px solid;
        }

        .toggle-card.email {
            background: linear-gradient(135deg, rgba(16, 185, 129, 0.05), rgba(16, 185, 129, 0.1));
            border-color: rgba(16, 185, 129, 0.3);
        }

        .toggle-card.push {
            background: linear-gradient(135deg, rgba(59, 130, 246, 0.05), rgba(59, 130, 246, 0.1));
            border-color: rgba(59, 130, 246, 0.3);
        }

        .toggle-card.sms {
            background: linear-gradient(135deg, rgba(245, 158, 11, 0.05), rgba(245, 158, 11, 0.1));
            border-color: rgba(245, 158, 11, 0.3);
        }

        .toggle-card i {
            font-size: 42px;
            margin-bottom: 15px;
        }

        .toggle-card.email i { color: #10b981; }
        .toggle-card.push i { color: #3b82f6; }
        .toggle-card.sms i { color: #f59e0b; }

        .toggle-card h5 {
            font-size: 18px;
            color: #1e293b;
            margin-bottom: 6px;
        }

        .toggle-card small {
            color: #64748b;
            font-size: 13px;
            display: block;
            margin-bottom: 15px;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 56px;
            height: 28px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #cbd5e1;
            transition: .4s;
            border-radius: 28px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 20px;
            width: 20px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }

        input:checked + .slider {
            background: linear-gradient(135deg, #667eea, #764ba2);
        }

        input:checked + .slider:before {
            transform: translateX(28px);
        }

        input:disabled + .slider {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .tabs {
            display: flex;
            gap: 10px;
            border-bottom: 2px solid #e2e8f0;
            margin-bottom: 25px;
            flex-wrap: wrap;
        }

        .tab {
            background: transparent;
            border: none;
            padding: 12px 24px;
            border-radius: 8px 8px 0 0;
            cursor: pointer;
            font-size: 15px;
            font-weight: 600;
            color: #64748b;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .tab:hover {
            background: #f8fafc;
            color: #1e293b;
        }

        .tab.active {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
            animation: fadeIn 0.3s;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            font-weight: 600;
            color: #334155;
            margin-bottom: 8px;
            font-size: 14px;
        }

        .form-control, select {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.3s;
            font-family: inherit;
        }

        .form-control:focus, select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-control.is-invalid {
            border-color: #ef4444;
        }

        .invalid-feedback {
            color: #ef4444;
            font-size: 13px;
            margin-top: 5px;
            display: block;
        }

        .form-text {
            font-size: 12px;
            color: #64748b;
            margin-top: 5px;
            display: block;
        }

        .row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
        }

        .btn-outline {
            background: white;
            color: #667eea;
            border: 2px solid #667eea;
        }

        .btn-outline:hover {
            background: #667eea;
            color: white;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .alert-success {
            background: #d1fae5;
            color: #065f46;
            border-left: 4px solid #10b981;
        }

        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }

            .tabs {
                overflow-x: auto;
                flex-wrap: nowrap;
            }

            .row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>
                <i class="fas fa-bell"></i>
                Notification Settings
            </h1>
        </div>

        @if(session('success'))
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            {{ session('success') }}
        </div>
        @endif

        <form action="{{ route('admin.settings.notifications.update') }}" method="POST" id="notificationForm">
            @csrf
            @method('PUT')

            <!-- Channel Toggle Cards -->
            <div class="card">
                <h3>Communication Channels</h3>
                <p>Configure which notification channels are enabled for your system</p>

                <div class="toggle-cards">
                    <!-- Email Card -->
                    <div class="toggle-card email">
                        <i class="fas fa-envelope"></i>
                        <h5>Email Notifications</h5>
                        <small>Primary channel - Always enabled</small>
                        <label class="switch">
                            <input type="hidden" name="email_enabled" value="1">
                            <input type="checkbox" checked disabled>
                            <span class="slider"></span>
                        </label>
                    </div>

                    <!-- Push Card -->
                    <div class="toggle-card push">
                        <i class="fas fa-mobile-alt"></i>
                        <h5>Push Notifications</h5>
                        <small>Mobile & browser notifications</small>
                        <label class="switch">
                            <input type="checkbox" name="push_enabled" value="1" {{ $settings->push_enabled ? 'checked' : '' }} id="pushToggle">
                            <span class="slider"></span>
                        </label>
                    </div>

                    <!-- SMS Card -->
                    <div class="toggle-card sms">
                        <i class="fas fa-sms"></i>
                        <h5>SMS Notifications</h5>
                        <small>Text message notifications</small>
                        <label class="switch">
                            <input type="checkbox" name="sms_enabled" value="1" {{ $settings->sms_enabled ? 'checked' : '' }} id="smsToggle">
                            <span class="slider"></span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Configuration Tabs -->
            <div class="card">
                <div class="tabs">
                    <button type="button" class="tab active" data-tab="email">
                        <i class="fas fa-envelope"></i> Email Setup
                    </button>
                    <button type="button" class="tab" data-tab="push">
                        <i class="fas fa-mobile-alt"></i> Push Setup
                    </button>
                    <button type="button" class="tab" data-tab="sms">
                        <i class="fas fa-sms"></i> SMS Setup
                    </button>
                </div>

                <!-- Email Tab -->
                <div class="tab-content active" id="email-tab">
                    <div class="row">
                        <div class="form-group">
                            <label for="mailMailer">
                                <i class="fas fa-server"></i> Mail Driver
                            </label>
                            <select class="form-control @error('mail_mailer') is-invalid @enderror" id="mailMailer" name="mail_mailer" required>
                                <option value="smtp" {{ $settings->mail_mailer == 'smtp' ? 'selected' : '' }}>SMTP</option>
                                <option value="sendmail" {{ $settings->mail_mailer == 'sendmail' ? 'selected' : '' }}>Sendmail</option>
                                <option value="mailgun" {{ $settings->mail_mailer == 'mailgun' ? 'selected' : '' }}>Mailgun</option>
                            </select>
                            @error('mail_mailer')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="mailHost">
                                <i class="fas fa-globe"></i> Mail Host
                            </label>
                            <input type="text" class="form-control @error('mail_host') is-invalid @enderror" id="mailHost" name="mail_host" value="{{ old('mail_host', $settings->mail_host) }}" placeholder="smtp.gmail.com">
                            @error('mail_host')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group">
                            <label for="mailPort">
                                <i class="fas fa-plug"></i> Mail Port
                            </label>
                            <input type="number" class="form-control @error('mail_port') is-invalid @enderror" id="mailPort" name="mail_port" value="{{ old('mail_port', $settings->mail_port) }}" placeholder="587">
                            @error('mail_port')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="mailEncryption">
                                <i class="fas fa-lock"></i> Encryption
                            </label>
                            <select class="form-control @error('mail_encryption') is-invalid @enderror" id="mailEncryption" name="mail_encryption">
                                <option value="">None</option>
                                <option value="tls" {{ $settings->mail_encryption == 'tls' ? 'selected' : '' }}>TLS (Recommended)</option>
                                <option value="ssl" {{ $settings->mail_encryption == 'ssl' ? 'selected' : '' }}>SSL</option>
                            </select>
                            @error('mail_encryption')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group">
                            <label for="mailUsername">
                                <i class="fas fa-user"></i> Mail Username
                            </label>
                            <input type="text" class="form-control @error('mail_username') is-invalid @enderror" id="mailUsername" name="mail_username" value="{{ old('mail_username', $settings->mail_username) }}" placeholder="your-email@gmail.com">
                            @error('mail_username')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="mailPassword">
                                <i class="fas fa-key"></i> Mail Password
                            </label>
                            <input type="password" class="form-control @error('mail_password') is-invalid @enderror" id="mailPassword" name="mail_password" placeholder="••••••••">
                            <small class="form-text">Leave blank to keep current password</small>
                            @error('mail_password')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group">
                            <label for="mailFromAddress">
                                <i class="fas fa-at"></i> From Email
                            </label>
                            <input type="email" class="form-control @error('mail_from_address') is-invalid @enderror" id="mailFromAddress" name="mail_from_address" value="{{ old('mail_from_address', $settings->mail_from_address) }}" placeholder="noreply@yourdomain.com">
                            @error('mail_from_address')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="mailFromName">
                                <i class="fas fa-signature"></i> From Name
                            </label>
                            <input type="text" class="form-control @error('mail_from_name') is-invalid @enderror" id="mailFromName" name="mail_from_name" value="{{ old('mail_from_name', $settings->mail_from_name) }}" placeholder="EE Micro LMS">
                            @error('mail_from_name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror                    </div>
                </div>

                <!-- Test Email Section -->
                <div style="margin-top: 30px; padding-top: 20px; border-top: 2px solid #e2e8f0;">
                    <h4 style="margin-bottom: 15px; color: #334155; font-size: 16px; font-weight: 600;">
                        <i class="fas fa-envelope-open-text"></i> Test Email Configuration
                    </h4>
                    <div class="form-group">
                        <label for="testEmailAddress" style="display: block; margin-bottom: 8px; color: #475569; font-weight: 500;">
                            <i class="fas fa-at"></i> Send Test Email To
                        </label>
                        <input type="email" class="form-control" id="testEmailAddress" placeholder="your-email@example.com" value="{{ auth()->user()->email }}" style="margin-bottom: 8px; padding: 10px 12px; border: 1px solid #cbd5e1; border-radius: 6px; font-size: 14px;">
                        <small class="form-text" style="color: #64748b; font-size: 13px;"><i class="fas fa-info-circle"></i> Enter an email address to receive the test email</small>
                    </div>
                    <button type="button" class="btn btn-outline" onclick="testEmail()" style="margin-top: 15px;"><i class="fas fa-paper-plane"></i> Send Test Email</button>
                </div>
            </div>

            <!-- Push Tab -->
                <div class="tab-content" id="push-tab">
                    <div class="row">
                        <div class="form-group" style="grid-column: 1 / -1;">
                            <label for="pushProvider">
                                <i class="fas fa-cloud"></i> Push Notification Provider
                            </label>
                            <select class="form-control @error('push_provider') is-invalid @enderror" id="pushProvider" name="push_provider">
                                <option value="">Select Provider</option>
                                <option value="firebase" {{ $settings->push_provider == 'firebase' ? 'selected' : '' }}>🔥 Firebase Cloud Messaging (FCM)</option>
                                <option value="onesignal" {{ $settings->push_provider == 'onesignal' ? 'selected' : '' }}>📱 OneSignal</option>
                            </select>
                            @error('push_provider')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group">
                            <label for="pushApiKey">
                                <i class="fas fa-key"></i> API Key
                            </label>
                            <input type="password" class="form-control @error('push_api_key') is-invalid @enderror" id="pushApiKey" name="push_api_key" placeholder="••••••••">
                            <small class="form-text">For OneSignal: REST API Key{{ $settings->push_api_key ? ' (currently set)' : '' }}</small>
                            @error('push_api_key')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="pushServerKey">
                                <i class="fas fa-server"></i> Server Key
                            </label>
                            <input type="password" class="form-control @error('push_server_key') is-invalid @enderror" id="pushServerKey" name="push_server_key" placeholder="••••••••">
                            <small class="form-text">For Firebase: Server Key from Project Settings{{ $settings->push_server_key ? ' (currently set)' : '' }}</small>
                            @error('push_server_key')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="pushAppId">
                            <i class="fas fa-id-badge"></i> OneSignal App ID
                        </label>
                        <input type="text" class="form-control @error('push_app_id') is-invalid @enderror" id="pushAppId" name="push_app_id" value="{{ old('push_app_id', $settings->push_config['app_id'] ?? '') }}" placeholder="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx">
                        <small class="form-text">Required for OneSignal notifications.</small>
                        @error('push_app_id')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="testPushToken">
                            <i class="fas fa-mobile-alt"></i> Test Device Token
                        </label>
                        <input type="text" class="form-control" id="testPushToken" placeholder="Enter device token for test push" value="{{ old('test_push_token') }}">
                        <small class="form-text"><i class="fas fa-info-circle"></i> Provide a device token (OneSignal player ID or FCM registration token) to send a test push.</small>
                    </div>

                    <div style="margin-top: 20px;">
                        <button type="button" class="btn btn-outline" onclick="testPush()">
                            <i class="fas fa-mobile-alt"></i> Send Test Push
                        </button>
                    </div>
                </div>

                <!-- SMS Tab -->
                <div class="tab-content" id="sms-tab">
                    <div class="row">
                        <div class="form-group" style="grid-column: 1 / -1;">
                            <label for="smsProvider">
                                <i class="fas fa-comment-dots"></i> SMS Provider
                            </label>
                            <select class="form-control @error('sms_provider') is-invalid @enderror" id="smsProvider" name="sms_provider">
                                <option value="">Select Provider</option>
                                <option value="twilio" {{ $settings->sms_provider == 'twilio' ? 'selected' : '' }}>📞 Twilio</option>
                                <option value="nexmo" {{ $settings->sms_provider == 'nexmo' ? 'selected' : '' }}>📱 Nexmo (Vonage)</option>
                                <option value="africas_talking" {{ $settings->sms_provider == 'africas_talking' ? 'selected' : '' }}>🌍 Africa's Talking</option>
                            </select>
                            @error('sms_provider')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group">
                            <label for="smsApiKey">
                                <i class="fas fa-key"></i> API Key / Account SID
                            </label>
                            <input type="password" class="form-control @error('sms_api_key') is-invalid @enderror" id="smsApiKey" name="sms_api_key" placeholder="••••••••">
                            <small class="form-text">{{ $settings->sms_api_key ? 'Credential currently stored. Leave blank to keep existing value.' : 'Enter your provider API key.' }}</small>
                            @error('sms_api_key')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="smsApiSecret">
                                <i class="fas fa-lock"></i> API Secret / Auth Token
                            </label>
                            <input type="password" class="form-control @error('sms_api_secret') is-invalid @enderror" id="smsApiSecret" name="sms_api_secret" placeholder="••••••••">
                            <small class="form-text">{{ $settings->sms_api_secret ? 'Credential currently stored. Leave blank to keep existing value.' : 'Enter your provider secret.' }}</small>
                            @error('sms_api_secret')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="smsFromNumber">
                            <i class="fas fa-phone"></i> From Number
                        </label>
                        <input type="text" class="form-control @error('sms_from_number') is-invalid @enderror" id="smsFromNumber" name="sms_from_number" value="{{ old('sms_from_number', $settings->sms_from_number) }}" placeholder="+1234567890">
                        @error('sms_from_number')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="testSmsNumber">
                            <i class="fas fa-mobile"></i> Test Phone Number
                        </label>
                        <input type="tel" class="form-control" id="testSmsNumber" placeholder="Enter phone number with country code" value="{{ old('test_sms_number', auth()->user()->phone) }}">
                        <small class="form-text"><i class="fas fa-info-circle"></i> Provide the destination number to receive the test SMS.</small>
                    </div>

                    <div style="margin-top: 20px;">
                        <button type="button" class="btn btn-outline" onclick="testSms()">
                            <i class="fas fa-sms"></i> Send Test SMS
                        </button>
                    </div>
                </div>
            </div>

            <!-- Save Button -->
            <div class="card">
                <button type="submit" class="btn btn-primary" style="width: 100%; justify-content: center; padding: 15px;">
                    <i class="fas fa-save"></i> Save All Settings
                </button>
            </div>
        </form>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/toastr.min.js"></script>
    <script>
        // Configure toastr
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "timeOut": "3000"
        };

        // Tab switching
        document.querySelectorAll('.tab').forEach(tab => {
            tab.addEventListener('click', function() {
                // Remove active class from all tabs and contents
                document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
                
                // Add active class to clicked tab
                this.classList.add('active');
                
                // Show corresponding content
                const tabName = this.getAttribute('data-tab');
                document.getElementById(tabName + '-tab').classList.add('active');
            });
        });

        // Test Email
        function testEmail() {
            const btn = event.target.closest('button');
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';

            $.ajax({
                url: '{{ route("admin.settings.notifications.test.email") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    test_email: document.getElementById('testEmailAddress').value
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr) {
                    toastr.error(xhr.responseJSON?.message || 'Failed to send test email');
                },
                complete: function() {
                    btn.disabled = false;
                    btn.innerHTML = '<i class="fas fa-paper-plane"></i> Send Test Email';
                }
            });
        }

        // Test Push
        function testPush() {
            const btn = event.target.closest('button');
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';

            $.ajax({
                url: '{{ route("admin.settings.notifications.test.push") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    test_token: document.getElementById('testPushToken').value
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr) {
                    toastr.error(xhr.responseJSON?.message || 'Failed to send test push notification');
                },
                complete: function() {
                    btn.disabled = false;
                    btn.innerHTML = '<i class="fas fa-mobile-alt"></i> Send Test Push';
                }
            });
        }

        // Test SMS
        function testSms() {
            const btn = event.target.closest('button');
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';

            $.ajax({
                url: '{{ route("admin.settings.notifications.test.sms") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    test_phone: document.getElementById('testSmsNumber').value
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr) {
                    toastr.error(xhr.responseJSON?.message || 'Failed to send test SMS');
                },
                complete: function() {
                    btn.disabled = false;
                    btn.innerHTML = '<i class="fas fa-sms"></i> Send Test SMS';
                }
            });
        }

        // Form submission with loading state
        document.getElementById('notificationForm').addEventListener('submit', function(e) {
            const submitBtn = this.querySelector('button[type="submit"]');
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
        });
    </script>
</body>
</body>
</html>


