<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        @php($brand = \App\Support\BrandSettings::data())
        <meta name="application-name" content="{{ $brand['name'] }}">

        <title inertia>{{ $brand['name'] }}</title>

        @if(!empty($brand['favicon_url']))
            <link rel="icon" type="image/x-icon" href="{{ $brand['favicon_url'] }}">
        @endif

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" referrerpolicy="no-referrer" />

        <style>
            :root {
                --brand-primary: {{ $brand['colors']['primary'] ?? '#667eea' }};
                --brand-secondary: {{ $brand['colors']['secondary'] ?? '#764ba2' }};
                --brand-gradient: {{ $brand['colors']['gradient'] ?? 'linear-gradient(135deg, #667eea, #764ba2)' }};
            }
            body {
                font-family: 'Figtree', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            }
        </style>

        <!-- Scripts -->
        @vite(['resources/js/app.tsx'])
        @inertiaHead
    </head>
    <body class="antialiased">
        @inertia
    </body>
</html>