<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate Verification - EE Micro LMS</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            width: 100%;
        }

        .card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            text-align: center;
        }

        .logo {
            font-size: 64px;
            margin-bottom: 20px;
        }

        .title {
            font-size: 28px;
            color: #2c3e50;
            margin-bottom: 10px;
        }

        .subtitle {
            color: #6c757d;
            margin-bottom: 30px;
        }

        .status-icon {
            font-size: 80px;
            margin-bottom: 20px;
        }

        .status-icon.valid {
            color: #28a745;
        }

        .status-icon.invalid {
            color: #dc3545;
        }

        .message {
            font-size: 18px;
            margin-bottom: 30px;
        }

        .message.valid {
            color: #155724;
        }

        .message.invalid {
            color: #721c24;
        }

        .certificate-info {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            text-align: left;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #dee2e6;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: 600;
            color: #495057;
        }

        .info-value {
            color: #2c3e50;
            text-align: right;
        }

        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 25px;
            font-weight: 600;
            transition: transform 0.3s;
        }

        .btn:hover {
            transform: translateY(-2px);
        }

        .certificate-code {
            font-family: 'Courier New', monospace;
            background: #e9ecef;
            padding: 10px 15px;
            border-radius: 5px;
            display: inline-block;
            margin: 20px 0;
            font-size: 16px;
            font-weight: bold;
        }

        .verified-badge {
            background: #28a745;
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            display: inline-block;
            font-weight: 600;
            margin-top: 10px;
        }

        @media (max-width: 600px) {
            .card {
                padding: 30px 20px;
            }

            .title {
                font-size: 24px;
            }

            .info-row {
                flex-direction: column;
            }

            .info-value {
                text-align: left;
                margin-top: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="logo">🎓</div>
            <h1 class="title">Certificate Verification</h1>
            <p class="subtitle">EE Micro LMS</p>

            @if($found)
                <!-- Valid Certificate -->
                <div class="status-icon valid">✓</div>
                <p class="message valid"><strong>Certificate Verified Successfully!</strong></p>

                <div class="verified-badge">✓ Authentic Certificate</div>

                <div class="certificate-info">
                    <div class="info-row">
                        <span class="info-label">Student Name:</span>
                        <span class="info-value">{{ $studentName }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Course/Lesson:</span>
                        <span class="info-value">{{ $courseName }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Issued Date:</span>
                        <span class="info-value">{{ $issuedDate }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Certificate Code:</span>
                        <span class="info-value">
                            <code class="certificate-code">{{ $certificateCode }}</code>
                        </span>
                    </div>
                </div>

                <p style="color: #6c757d; font-size: 14px; margin-bottom: 20px;">
                    This certificate is valid and has been issued by EE Micro LMS.
                </p>

            @else
                <!-- Invalid Certificate -->
                <div class="status-icon invalid">✗</div>
                <p class="message invalid"><strong>Certificate Not Found</strong></p>

                <div style="background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 10px; margin-bottom: 20px;">
                    {{ $message }}
                </div>

                <p style="color: #6c757d; font-size: 14px; margin-bottom: 20px;">
                    The certificate code you entered could not be verified. Please check the code and try again.
                </p>
            @endif

            <a href="/" class="btn">Return to Home</a>
        </div>
    </div>
</body>
</html>
