<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <title>My Learning Dashboard - {{ config('app.name') }}</title>
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    :root {
      --primary: #667eea;
      --primary-dark: #5568d3;
      --secondary: #764ba2;
      --success: #10b981;
      --warning: #f59e0b;
      --danger: #ef4444;
      --info: #3b82f6;
      --dark: #1f2937;
      --gray: #6b7280;
      --light-gray: #f3f4f6;
      --border: #e5e7eb;
      --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
      --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    }

    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
      color: var(--dark);
      line-height: 1.6;
    }

    /* Mobile-First Layout */
    .container {
      max-width: 1400px;
      margin: 0 auto;
      padding: 15px;
    }

    @media (min-width: 768px) {
      .container {
        padding: 20px;
      }
    }

    @media (min-width: 1024px) {
      .container {
        padding: 30px;
      }
    }

    /* Header */
    .header {
      background: white;
      border-radius: 12px;
      padding: 15px;
      margin-bottom: 20px;
      box-shadow: var(--shadow);
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      gap: 15px;
    }

    @media (min-width: 768px) {
      .header {
        padding: 20px 30px;
        flex-wrap: nowrap;
      }
    }

    .header-left h1 {
      font-size: 1.5rem;
      color: var(--dark);
      margin-bottom: 5px;
    }

    @media (min-width: 768px) {
      .header-left h1 {
        font-size: 2rem;
      }
    }

    .header-left p {
      color: var(--gray);
      font-size: 0.875rem;
    }

    .header-right {
      display: flex;
      gap: 10px;
      align-items: center;
      width: 100%;
      justify-content: space-between;
    }

    @media (min-width: 768px) {
      .header-right {
        width: auto;
        justify-content: flex-end;
      }
    }

    .user-info {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      font-weight: 600;
      font-size: 1.1rem;
    }

    .btn {
      padding: 8px 16px;
      border-radius: 8px;
      border: none;
      font-weight: 500;
      cursor: pointer;
      transition: all 0.3s;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      gap: 8px;
      font-size: 0.875rem;
    }

    .btn-primary {
      background: var(--primary);
      color: white;
    }

    .btn-primary:hover {
      background: var(--primary-dark);
      transform: translateY(-2px);
      box-shadow: var(--shadow-lg);
    }

    .btn-outline {
      background: transparent;
      border: 2px solid var(--primary);
      color: var(--primary);
    }

    .btn-outline:hover {
      background: var(--primary);
      color: white;
    }

    /* Stats Grid */
    .stats-grid {
      display: grid;
      grid-template-columns: 1fr;
      gap: 15px;
      margin-bottom: 20px;
    }

    @media (min-width: 640px) {
      .stats-grid {
        grid-template-columns: repeat(2, 1fr);
      }
    }

    @media (min-width: 1024px) {
      .stats-grid {
        grid-template-columns: repeat(4, 1fr);
      }
    }

    .stat-card {
      background: white;
      border-radius: 12px;
      padding: 20px;
      box-shadow: var(--shadow);
      transition: transform 0.3s;
    }

    .stat-card:hover {
      transform: translateY(-5px);
      box-shadow: var(--shadow-lg);
    }

    .stat-icon {
      width: 50px;
      height: 50px;
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.5rem;
      margin-bottom: 15px;
    }

    .stat-value {
      font-size: 2rem;
      font-weight: 700;
      color: var(--dark);
      margin-bottom: 5px;
    }

    .stat-label {
      color: var(--gray);
      font-size: 0.875rem;
    }

    /* Main Content */
    .main-content {
      display: grid;
      grid-template-columns: 1fr;
      gap: 20px;
    }

    @media (min-width: 1024px) {
      .main-content {
        grid-template-columns: 2fr 1fr;
      }
    }

    /* Course Cards */
    .courses-section {
      background: white;
      border-radius: 12px;
      padding: 20px;
      box-shadow: var(--shadow);
    }

    .section-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
      flex-wrap: wrap;
      gap: 15px;
    }

    .section-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: var(--dark);
    }

    .tabs {
      display: flex;
      gap: 10px;
      background: var(--light-gray);
      padding: 5px;
      border-radius: 8px;
      overflow-x: auto;
    }

    .tab {
      padding: 8px 16px;
      border-radius: 6px;
      border: none;
      background: transparent;
      color: var(--gray);
      font-weight: 500;
      cursor: pointer;
      transition: all 0.3s;
      white-space: nowrap;
      font-size: 0.875rem;
    }

    .tab.active {
      background: white;
      color: var(--primary);
      box-shadow: var(--shadow);
    }

    .course-grid {
      display: grid;
      grid-template-columns: 1fr;
      gap: 15px;
    }

    @media (min-width: 640px) {
      .course-grid {
        grid-template-columns: repeat(2, 1fr);
      }
    }

    @media (min-width: 1024px) {
      .course-grid {
        grid-template-columns: repeat(3, 1fr);
      }
    }

    .course-card {
      border: 1px solid var(--border);
      border-radius: 12px;
      overflow: hidden;
      transition: all 0.3s;
      background: white;
      cursor: pointer;
    }

    .course-card:hover {
      box-shadow: var(--shadow-lg);
      transform: translateY(-5px);
    }

    .course-image {
      width: 100%;
      height: 160px;
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 3rem;
      color: white;
    }

    .course-content {
      padding: 15px;
    }

    .course-title {
      font-size: 1.125rem;
      font-weight: 600;
      color: var(--dark);
      margin-bottom: 8px;
      line-height: 1.4;
    }

    .course-meta {
      display: flex;
      gap: 15px;
      font-size: 0.875rem;
      color: var(--gray);
      margin-bottom: 12px;
      flex-wrap: wrap;
    }

    .progress-bar-container {
      background: var(--light-gray);
      border-radius: 8px;
      height: 8px;
      overflow: hidden;
      margin-bottom: 8px;
    }

    .progress-bar {
      height: 100%;
      background: linear-gradient(90deg, var(--primary), var(--secondary));
      border-radius: 8px;
      transition: width 0.5s;
    }

    .progress-text {
      font-size: 0.75rem;
      color: var(--gray);
      text-align: right;
    }

    /* Sidebar */
    .sidebar {
      display: flex;
      flex-direction: column;
      gap: 20px;
    }

    .widget {
      background: white;
      border-radius: 12px;
      padding: 20px;
      box-shadow: var(--shadow);
    }

    .widget-title {
      font-size: 1.125rem;
      font-weight: 600;
      color: var(--dark);
      margin-bottom: 15px;
    }

    /* Achievements */
    .achievement-grid {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 10px;
    }

    .achievement {
      text-align: center;
      padding: 15px;
      border-radius: 8px;
      background: var(--light-gray);
      transition: all 0.3s;
    }

    .achievement:hover {
      background: var(--primary);
      color: white;
      transform: scale(1.05);
    }

    .achievement-icon {
      font-size: 2rem;
      margin-bottom: 8px;
    }

    .achievement-label {
      font-size: 0.75rem;
      font-weight: 500;
    }

    /* Activity */
    .activity-item {
      display: flex;
      gap: 15px;
      padding: 15px;
      border-radius: 8px;
      margin-bottom: 10px;
      background: var(--light-gray);
      transition: all 0.3s;
    }

    .activity-item:hover {
      background: var(--primary);
      color: white;
      transform: translateX(5px);
    }

    .activity-icon {
      width: 40px;
      height: 40px;
      border-radius: 8px;
      display: flex;
      align-items: center;
      justify-content: center;
      background: white;
      flex-shrink: 0;
    }

    .activity-content {
      flex: 1;
    }

    .activity-title {
      font-weight: 600;
      margin-bottom: 3px;
      font-size: 0.875rem;
    }

    .activity-time {
      font-size: 0.75rem;
      opacity: 0.7;
    }

    /* Empty State */
    .empty-state {
      text-align: center;
      padding: 60px 20px;
      color: var(--gray);
    }

    .empty-state-icon {
      font-size: 4rem;
      margin-bottom: 20px;
      opacity: 0.3;
    }

    .empty-state-title {
      font-size: 1.25rem;
      font-weight: 600;
      margin-bottom: 10px;
    }

    .empty-state-text {
      font-size: 0.875rem;
      margin-bottom: 20px;
    }

    /* Mobile Menu */
    .mobile-menu {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: white;
      box-shadow: 0 -4px 6px -1px rgba(0, 0, 0, 0.1);
      display: flex;
      justify-content: space-around;
      padding: 10px 0;
      z-index: 1000;
    }

    @media (min-width: 768px) {
      .mobile-menu {
        display: none;
      }
    }

    .menu-item {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 5px;
      padding: 5px 15px;
      border-radius: 8px;
      color: var(--gray);
      text-decoration: none;
      transition: all 0.3s;
    }

    .menu-item.active {
      color: var(--primary);
      background: rgba(102, 126, 234, 0.1);
    }

    .menu-item i {
      font-size: 1.25rem;
    }

    .menu-item span {
      font-size: 0.75rem;
      font-weight: 500;
    }

    /* Loading Spinner */
    .spinner {
      border: 3px solid var(--light-gray);
      border-top: 3px solid var(--primary);
      border-radius: 50%;
      width: 40px;
      height: 40px;
      animation: spin 1s linear infinite;
      margin: 0 auto;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    /* Responsive utilities */
    .hidden {
      display: none !important;
    }

    @media (max-width: 767px) {
      .hide-mobile {
        display: none !important;
      }
    }

    @media (min-width: 768px) {
      .hide-desktop {
        display: none !important;
      }
    }

    /* Add padding for mobile menu */
    @media (max-width: 767px) {
      body {
        padding-bottom: 70px;
      }
    }

    /* Badge styling */
    .badge {
      display: inline-block;
      padding: 4px 8px;
      border-radius: 12px;
      font-size: 0.75rem;
      font-weight: 600;
    }

    .badge-success {
      background: #d1fae5;
      color: #065f46;
    }

    .badge-warning {
      background: #fef3c7;
      color: #92400e;
    }

    .badge-info {
      background: #dbeafe;
      color: #1e40af;
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Header -->
    <div class="header">
      <div class="header-left">
        <h1>👋 Welcome back, {{ Auth::user()->name }}!</h1>
        <p>Continue your learning journey</p>
      </div>
      <div class="header-right">
        <div class="user-info hide-mobile">
          <div class="avatar">{{ strtoupper(substr(Auth::user()->name, 0, 1)) }}</div>
          <div>
            <div style="font-weight: 600; font-size: 0.875rem;">{{ Auth::user()->name }}</div>
            <div style="font-size: 0.75rem; color: var(--gray);">{{ Auth::user()->email }}</div>
          </div>
        </div>
        <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="btn btn-outline hide-mobile">
          <i class="fas fa-sign-out-alt"></i> Logout
        </a>
        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
          @csrf
        </form>
      </div>
    </div>

    <!-- Stats Grid -->
    <div class="stats-grid">
      <div class="stat-card">
        <div class="stat-icon" style="background: rgba(102, 126, 234, 0.1); color: var(--primary);">
          <i class="fas fa-book"></i>
        </div>
        <div class="stat-value" id="total-courses">{{ $enrolledCourses->count() }}</div>
        <div class="stat-label">Enrolled Courses</div>
      </div>

      <div class="stat-card">
        <div class="stat-icon" style="background: rgba(16, 185, 129, 0.1); color: var(--success);">
          <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-value" id="completed-courses">{{ $completedCourses }}</div>
        <div class="stat-label">Completed</div>
      </div>

      <div class="stat-card">
        <div class="stat-icon" style="background: rgba(245, 158, 11, 0.1); color: var(--warning);">
          <i class="fas fa-clock"></i>
        </div>
        <div class="stat-value" id="in-progress-courses">{{ $enrolledCourses->count() - $completedCourses }}</div>
        <div class="stat-label">In Progress</div>
      </div>

      <div class="stat-card">
        <div class="stat-icon" style="background: rgba(239, 68, 68, 0.1); color: var(--danger);">
          <i class="fas fa-fire"></i>
        </div>
        <div class="stat-value" id="streak-days">{{ $streakDays ?? 0 }}</div>
        <div class="stat-label">Day Streak</div>
      </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
      <!-- Courses Section -->
      <div class="courses-section">
        <div class="section-header">
          <h2 class="section-title">My Courses</h2>
          <div class="tabs">
            <button class="tab active" data-tab="all">All Courses</button>
            <button class="tab" data-tab="in-progress">In Progress</button>
            <button class="tab" data-tab="completed">Completed</button>
          </div>
        </div>

        <div id="courses-container">
          @if($enrolledCourses->count() > 0)
            <div class="course-grid">
              @foreach($enrolledCourses as $course)
                <div class="course-card" data-status="{{ $progress[$course->id] >= 100 ? 'completed' : 'in-progress' }}" onclick="window.location.href='/courses/{{ $course->id }}/learn'">
                  <div class="course-image">
                    <i class="fas fa-graduation-cap"></i>
                  </div>
                  <div class="course-content">
                    <h3 class="course-title">{{ $course->name }}</h3>
                    <div class="course-meta">
                      <span><i class="fas fa-book"></i> {{ $course->lessons->count() }} Lessons</span>
                      <span><i class="fas fa-file-alt"></i> {{ $course->lessons->sum(function($l) { return $l->topics->count(); }) }} Topics</span>
                    </div>
                    <div class="progress-bar-container">
                      <div class="progress-bar" style="width: {{ $progress[$course->id] }}%"></div>
                    </div>
                    <div class="progress-text">{{ $progress[$course->id] }}% Complete</div>
                    @if($progress[$course->id] >= 100)
                      <span class="badge badge-success" style="margin-top: 10px;">
                        <i class="fas fa-check"></i> Completed
                      </span>
                    @elseif($progress[$course->id] > 0)
                      <span class="badge badge-info" style="margin-top: 10px;">
                        <i class="fas fa-play"></i> Continue Learning
                      </span>
                    @else
                      <span class="badge badge-warning" style="margin-top: 10px;">
                        <i class="fas fa-star"></i> Start Course
                      </span>
                    @endif
                  </div>
                </div>
              @endforeach
            </div>
          @else
            <div class="empty-state">
              <div class="empty-state-icon">
                <i class="fas fa-book-open"></i>
              </div>
              <h3 class="empty-state-title">No courses yet</h3>
              <p class="empty-state-text">Browse available courses and start learning today!</p>
              <a href="/courses" class="btn btn-primary">
                <i class="fas fa-search"></i> Browse Courses
              </a>
            </div>
          @endif
        </div>
      </div>

      <!-- Sidebar -->
      <div class="sidebar">
        <!-- Achievements Widget -->
        <div class="widget">
          <h3 class="widget-title">🏆 Achievements</h3>
          <div class="achievement-grid">
            <div class="achievement">
              <div class="achievement-icon">🎯</div>
              <div class="achievement-label">First Course</div>
            </div>
            <div class="achievement">
              <div class="achievement-icon">⭐</div>
              <div class="achievement-label">5 Completed</div>
            </div>
            <div class="achievement">
              <div class="achievement-icon">🔥</div>
              <div class="achievement-label">7 Day Streak</div>
            </div>
            <div class="achievement">
              <div class="achievement-icon">📚</div>
              <div class="achievement-label">Bookworm</div>
            </div>
            <div class="achievement">
              <div class="achievement-icon">💯</div>
              <div class="achievement-label">Perfect Score</div>
            </div>
            <div class="achievement">
              <div class="achievement-icon">🚀</div>
              <div class="achievement-label">Fast Learner</div>
            </div>
          </div>
        </div>

        <!-- Recent Activity Widget -->
        <div class="widget">
          <h3 class="widget-title">📊 Recent Activity</h3>
          <div id="recent-activity">
            @if(isset($recentActivity) && count($recentActivity) > 0)
              @foreach($recentActivity as $activity)
                <div class="activity-item">
                  <div class="activity-icon" style="color: var(--primary);">
                    <i class="fas fa-{{ $activity['icon'] ?? 'check' }}"></i>
                  </div>
                  <div class="activity-content">
                    <div class="activity-title">{{ $activity['title'] }}</div>
                    <div class="activity-time">{{ $activity['time'] }}</div>
                  </div>
                </div>
              @endforeach
            @else
              <div class="empty-state" style="padding: 30px 10px;">
                <div class="empty-state-icon" style="font-size: 2.5rem;">
                  <i class="fas fa-history"></i>
                </div>
                <p class="empty-state-text" style="margin: 0;">No recent activity</p>
              </div>
            @endif
          </div>
        </div>

        <!-- Quick Actions Widget -->
        <div class="widget hide-mobile">
          <h3 class="widget-title">⚡ Quick Actions</h3>
          <a href="/courses" class="btn btn-primary" style="width: 100%; justify-content: center; margin-bottom: 10px;">
            <i class="fas fa-search"></i> Browse Courses
          </a>
          <a href="/certificates" class="btn btn-outline" style="width: 100%; justify-content: center; margin-bottom: 10px;">
            <i class="fas fa-certificate"></i> My Certificates
          </a>
          <a href="/profile" class="btn btn-outline" style="width: 100%; justify-content: center;">
            <i class="fas fa-user"></i> Edit Profile
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- Mobile Bottom Navigation -->
  <div class="mobile-menu">
    <a href="/dashboard" class="menu-item active">
      <i class="fas fa-home"></i>
      <span>Home</span>
    </a>
    <a href="/courses" class="menu-item">
      <i class="fas fa-book"></i>
      <span>Courses</span>
    </a>
    <a href="/certificates" class="menu-item">
      <i class="fas fa-certificate"></i>
      <span>Certificates</span>
    </a>
    <a href="/profile" class="menu-item">
      <i class="fas fa-user"></i>
      <span>Profile</span>
    </a>
  </div>

  <script>
    // Tab functionality
    document.querySelectorAll('.tab').forEach(tab => {
      tab.addEventListener('click', function() {
        // Update active tab
        document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
        this.classList.add('active');

        const filter = this.dataset.tab;
        const courseCards = document.querySelectorAll('.course-card');

        courseCards.forEach(card => {
          if (filter === 'all') {
            card.style.display = 'block';
          } else if (filter === 'completed' && card.dataset.status === 'completed') {
            card.style.display = 'block';
          } else if (filter === 'in-progress' && card.dataset.status === 'in-progress') {
            card.style.display = 'block';
          } else {
            card.style.display = 'none';
          }
        });
      });
    });

    // Mobile menu active state
    document.querySelectorAll('.menu-item').forEach(item => {
      item.addEventListener('click', function(e) {
        if (!this.href.includes(window.location.pathname)) {
          document.querySelectorAll('.menu-item').forEach(mi => mi.classList.remove('active'));
          this.classList.add('active');
        }
      });
    });

    // Add smooth scroll behavior
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
      anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
          target.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
      });
    });

    // Notification system (placeholder)
    function showNotification(message, type = 'info') {
      const notification = document.createElement('div');
      notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: ${type === 'success' ? '#10b981' : type === 'error' ? '#ef4444' : '#3b82f6'};
        color: white;
        padding: 15px 20px;
        border-radius: 8px;
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        z-index: 9999;
        animation: slideIn 0.3s ease-out;
      `;
      notification.textContent = message;
      document.body.appendChild(notification);

      setTimeout(() => {
        notification.style.animation = 'slideOut 0.3s ease-out';
        setTimeout(() => notification.remove(), 300);
      }, 3000);
    }

    // Add CSS animations
    const style = document.createElement('style');
    style.textContent = `
      @keyframes slideIn {
        from {
          transform: translateX(400px);
          opacity: 0;
        }
        to {
          transform: translateX(0);
          opacity: 1;
        }
      }
      @keyframes slideOut {
        from {
          transform: translateX(0);
          opacity: 1;
        }
        to {
          transform: translateX(400px);
          opacity: 0;
        }
      }
    `;
    document.head.appendChild(style);
  </script>
</body>
</html>
