<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Tutor Dashboard - EE Micro LMS</title>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/tinymce@6/tinymce.min.js" referrerpolicy="origin"></script>
  <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body { 
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
    }

    /* Navbar Styling */
    .navbar {
      background: rgba(255,255,255,0.95);
      padding: 15px 0;
      backdrop-filter: blur(10px);
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 100;
    }
    
    .navbar-content {
      max-width: 1400px;
      margin: 0 auto;
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 0 20px;
    }
    
    .logo {
      font-size: 1.5em;
      font-weight: bold;
      color: #667eea;
    }
    
    .user-info {
      display: flex;
      align-items: center;
      gap: 15px;
    }
    
    .btn {
      padding: 8px 16px;
      border: none;
      border-radius: 6px;
      text-decoration: none;
      font-size: 14px;
      cursor: pointer;
      transition: all 0.3s;
      display: inline-block;
    }
    
    .btn-primary {
      background: #667eea;
      color: white;
    }
    
    .btn-secondary {
      background: #6c757d;
      color: white;
    }
    
    .btn:hover {
      transform: translateY(-1px);
      box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }

    /* Main Layout */
    .admin-container {
      display: flex;
      margin-top: 70px;
      min-height: calc(100vh - 70px);
    }

    /* Sidebar Styling */
    .sidebar {
      width: 260px;
      background: rgba(255,255,255,0.1);
      backdrop-filter: blur(10px);
      padding: 20px;
      position: fixed;
      height: calc(100vh - 70px);
      overflow-y: auto;
      border-right: 1px solid rgba(255,255,255,0.2);
    }

    .sidebar h2 {
      color: white;
      margin-bottom: 20px;
      font-size: 1.2em;
    }

    .nav-item {
      padding: 12px 15px;
      margin-bottom: 8px;
      color: rgba(255,255,255,0.9);
      cursor: pointer;
      border-radius: 8px;
      transition: all 0.3s;
      display: flex;
      align-items: center;
      gap: 12px;
    }

    .nav-item:hover {
      background: rgba(255,255,255,0.2);
      transform: translateX(5px);
    }

    .nav-item.active {
      background: rgba(255,255,255,0.3);
      font-weight: 600;
    }

    .nav-item i {
      width: 20px;
      text-align: center;
    }

    /* Content Area */
    .content {
      flex: 1;
      margin-left: 260px;
      padding: 30px;
    }

    .section {
      display: none;
    }

    .section.active {
      display: block;
    }

    /* Cards */
    .card {
      background: rgba(255,255,255,0.95);
      padding: 25px;
      border-radius: 15px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
      backdrop-filter: blur(10px);
      margin-bottom: 20px;
    }

    .card h3 {
      color: #333;
      margin-bottom: 20px;
      font-size: 1.3em;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    /* Stats Grid */
    .stats-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 20px;
      margin-bottom: 30px;
    }

    .stat-card {
      background: rgba(255,255,255,0.95);
      padding: 25px;
      border-radius: 15px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
      transition: all 0.3s;
    }

    .stat-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 25px rgba(0,0,0,0.15);
    }

    .stat-card .icon {
      font-size: 2.5em;
      margin-bottom: 15px;
      opacity: 0.9;
    }

    .stat-card .value {
      font-size: 2.2em;
      font-weight: bold;
      color: #333;
      margin-bottom: 5px;
    }

    .stat-card .label {
      color: #666;
      font-size: 0.95em;
      font-weight: 500;
    }

    .stat-card .change {
      font-size: 0.85em;
      margin-top: 8px;
      padding: 4px 10px;
      border-radius: 12px;
      display: inline-block;
    }

    .stat-card .change.positive {
      background: #d1f4e0;
      color: #00994d;
    }

    .stat-card .change.neutral {
      background: #e2e8f0;
      color: #64748b;
    }

    /* Course List */
    .course-list {
      max-height: 500px;
      overflow-y: auto;
    }

    .course-item {
      padding: 15px;
      border: 1px solid #e5e7eb;
      border-radius: 10px;
      margin-bottom: 12px;
      transition: all 0.3s;
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
    }

    .course-item:hover {
      background: #f9fafb;
      border-color: #667eea;
      box-shadow: 0 2px 8px rgba(102, 126, 234, 0.1);
    }

    .course-item h4 {
      color: #333;
      margin-bottom: 8px;
      font-size: 1.05em;
    }

    .course-item .course-stats {
      display: flex;
      gap: 15px;
      font-size: 0.85em;
      color: #666;
    }

    .course-item .course-stats span {
      display: flex;
      align-items: center;
      gap: 4px;
    }

    /* Activity Feed */
    .activity-feed {
      max-height: 400px;
      overflow-y: auto;
    }

    .activity-item {
      padding: 12px 0;
      border-bottom: 1px solid #e5e7eb;
    }

    .activity-item:last-child {
      border-bottom: none;
    }

    .activity-item .activity-user {
      font-weight: 600;
      color: #333;
    }

    .activity-item .activity-action {
      color: #666;
      font-size: 0.95em;
    }

    .activity-item .activity-time {
      font-size: 0.8em;
      color: #999;
      margin-top: 4px;
    }

    /* Attention List */
    .attention-item {
      padding: 12px;
      background: #fef3cd;
      border-left: 4px solid #ffc107;
      border-radius: 6px;
      margin-bottom: 10px;
    }

    .attention-item .student-name {
      font-weight: 600;
      color: #333;
      margin-bottom: 4px;
    }

    .attention-item .progress-info {
      font-size: 0.85em;
      color: #666;
    }

    /* Chart Container */
    .chart-container {
      position: relative;
      height: 300px;
      margin-top: 20px;
    }

    /* Empty State */
    .empty-state {
      text-align: center;
      padding: 40px 20px;
      color: #999;
    }

    .empty-state i {
      font-size: 3em;
      margin-bottom: 15px;
      opacity: 0.5;
    }

    /* Quick Actions */
    .quick-actions {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 15px;
    }

    .action-btn {
      background: rgba(255,255,255,0.95);
      padding: 20px;
      border-radius: 12px;
      text-align: center;
      text-decoration: none;
      color: #333;
      transition: all 0.3s;
      box-shadow: 0 2px 8px rgba(0,0,0,0.08);
      cursor: pointer;
    }

    .action-btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.15);
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
    }

    .action-btn i {
      font-size: 2em;
      margin-bottom: 10px;
      display: block;
    }

    .action-btn span {
      font-weight: 600;
      font-size: 0.95em;
    }

    /* Content Grid */
    .content-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
      gap: 20px;
      margin-bottom: 30px;
    }

    /* Scrollbar */
    ::-webkit-scrollbar {
      width: 8px;
      height: 8px;
    }

    ::-webkit-scrollbar-track {
      background: #f1f1f1;
      border-radius: 10px;
    }

    ::-webkit-scrollbar-thumb {
      background: #667eea;
      border-radius: 10px;
    }

    ::-webkit-scrollbar-thumb:hover {
      background: #764ba2;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .sidebar {
        width: 200px;
      }
      
      .content {
        margin-left: 200px;
      }

      .content-grid {
        grid-template-columns: 1fr;
      }

      .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
      }
    }

    @media (max-width: 576px) {
      .sidebar {
        display: none;
      }
      
      .content {
        margin-left: 0;
      }
    }

    .hidden {
      display: none !important;
    }

    /* TinyMCE Light Mode Override */
    .tox .tox-edit-area__iframe {
      background-color: #ffffff !important;
    }
    
    .tox-tinymce {
      border: 1px solid #ccc !important;
    }
    
    .tox .tox-editor-header {
      background-color: #f0f0f0 !important;
      border-bottom: 1px solid #ccc !important;
    }
    
    .tox .tox-toolbar,
    .tox .tox-toolbar__overflow,
    .tox .tox-toolbar__primary {
      background-color: #f0f0f0 !important;
    }
    
    .tox .tox-menubar,
    .tox .tox-statusbar {
      background-color: #f0f0f0 !important;
    }
  </style>
</head>
<body>
  <!-- Navbar -->
  <nav class="navbar">
    <div class="navbar-content">
      <div class="logo">
        <i class="fas fa-graduation-cap"></i> EE Micro LMS - Tutor
      </div>
      <div class="user-info">
        <span>Welcome, <strong>{{ $user->name }}</strong></span>
        @if($user->hasRole('admin'))
          <a href="{{ route('admin.panel') }}" class="btn btn-primary">
            <i class="fas fa-cog"></i> Admin Panel
          </a>
        @endif
        <form method="POST" action="{{ route('logout') }}" style="display: inline;">
          @csrf
          <button type="submit" class="btn btn-secondary">
            <i class="fas fa-sign-out-alt"></i> Logout
          </button>
        </form>
      </div>
    </div>
  </nav>

  <div class="admin-container">
    <!-- Sidebar -->
    <div class="sidebar">
      <h2><i class="fas fa-chalkboard-teacher"></i> Tutor Panel</h2>
      <div class="nav-item active" data-section="dashboard">
        <i class="fas fa-home"></i> Dashboard
      </div>
      <div class="nav-item" data-section="courses">
        <i class="fas fa-book"></i> My Courses
      </div>
      <div class="nav-item" data-section="students">
        <i class="fas fa-users"></i> Students
      </div>
      <div class="nav-item" data-section="certificates">
        <i class="fas fa-certificate"></i> Certificates
      </div>
      <div class="nav-item" data-section="badges">
        <i class="fas fa-trophy"></i> Badges
      </div>
      <div class="nav-item" data-section="activity">
        <i class="fas fa-history"></i> Recent Activity
      </div>
      <div class="nav-item" data-section="analytics">
        <i class="fas fa-chart-line"></i> Analytics
      </div>
      <div class="nav-item" data-section="quick-actions">
        <i class="fas fa-bolt"></i> Quick Actions
      </div>
    </div>

    <!-- Main Content -->
    <div class="content">
      <!-- Dashboard Section -->
      <section id="dashboard" class="section active">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-chalkboard-teacher"></i> Tutor Dashboard
        </h1>

        <!-- Stats Grid -->
        <div class="stats-grid">
          <div class="stat-card">
            <div class="icon" style="color: #667eea;">
              <i class="fas fa-book"></i>
            </div>
            <div class="value">{{ $totalCourses }}</div>
            <div class="label">Total Courses</div>
            <div class="change neutral">
              <i class="fas fa-layer-group"></i> {{ $tutorCourses->sum(fn($c) => $c->lessons->count()) }} Lessons
            </div>
          </div>

          <div class="stat-card" onclick="showStudentDetails('total')" style="cursor: pointer; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
            <div class="icon" style="color: #10b981;">
              <i class="fas fa-users"></i>
            </div>
            <div class="value">{{ $totalStudents }}</div>
            <div class="label">Total Students</div>
            <div class="change positive">
              <i class="fas fa-arrow-up"></i> {{ $recentEnrollments }} new this week
            </div>
            <div style="font-size: 11px; color: #6b7280; margin-top: 8px;">
              <i class="fas fa-mouse-pointer"></i> Click for details
            </div>
          </div>

          <div class="stat-card" onclick="showStudentDetails('active')" style="cursor: pointer; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
            <div class="icon" style="color: #f59e0b;">
              <i class="fas fa-user-check"></i>
            </div>
            <div class="value">{{ $activeStudents }}</div>
            <div class="label">Active Students</div>
            <div class="change neutral">
              <i class="fas fa-clock"></i> Last 7 days
            </div>
            <div style="font-size: 11px; color: #6b7280; margin-top: 8px;">
              <i class="fas fa-mouse-pointer"></i> Click for details
            </div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #3b82f6;">
              <i class="fas fa-chart-line"></i>
            </div>
            <div class="value">{{ $averageProgress }}%</div>
            <div class="label">Avg Progress</div>
            <div class="change neutral">
              <i class="fas fa-tasks"></i> {{ $completedCourses }} completed
            </div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #8b5cf6;">
              <i class="fas fa-clipboard-question"></i>
            </div>
            <div class="value">{{ $totalQuizzes }}</div>
            <div class="label">Total Quizzes</div>
            <div class="change neutral">
              <i class="fas fa-question-circle"></i> Assessment items
            </div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #ec4899;">
              <i class="fas fa-certificate"></i>
            </div>
            <div class="value">{{ $certificatesIssued }}</div>
            <div class="label">Certificates Issued</div>
            <div class="change neutral">
              <i class="fas fa-award"></i> {{ $certificateTemplates }} templates
            </div>
          </div>
        </div>

        <!-- Overview Cards -->
        <div class="content-grid">
          <div class="card">
            <h3><i class="fas fa-chart-area"></i> Quick Overview</h3>
            <p style="color: #666; line-height: 1.8;">
              Welcome to your tutor dashboard! You have <strong>{{ $totalCourses }} courses</strong> with 
              <strong>{{ $tutorCourses->sum(fn($c) => $c->lessons->count()) }} lessons</strong> and 
              <strong>{{ $tutorCourses->sum(fn($c) => $c->lessons->sum(fn($l) => $l->topics->count())) }} topics</strong>. 
              Currently, <strong>{{ $activeStudents }} students</strong> are actively learning.
            </p>
          </div>

          <div class="card">
            <h3><i class="fas fa-bullhorn"></i> Important Notes</h3>
            @if($studentsNeedingAttention->count() > 0)
              <p style="color: #f59e0b; font-weight: 600;">
                <i class="fas fa-exclamation-triangle"></i> {{ $studentsNeedingAttention->count() }} students need your attention!
              </p>
            @else
              <p style="color: #10b981;">
                <i class="fas fa-check-circle"></i> All students are progressing well!
              </p>
            @endif
            <p style="color: #666; margin-top: 10px;">
              {{ $recentEnrollments }} new students joined this week.
            </p>
          </div>
        </div>
      </section>

      <!-- Courses Section -->
      <section id="courses" class="section">
        <div class="section-header">
          <h1>📚 Course Management</h1>
          <p style="color: white; font-weight: bold; font-style: italic;">Create and manage learning courses, lessons, and topics</p>
        </div>

        <!-- Tabs Navigation -->
        <div style="display: flex; gap: 10px; margin-bottom: 20px; border-bottom: 2px solid rgba(255,255,255,0.2); padding-bottom: 10px;">
          <button class="tutor-tab-btn active" data-tab="courses-list" style="background: rgba(255,255,255,0.2); color: white; border: none; padding: 10px 20px; border-radius: 6px 6px 0 0; cursor: pointer; font-weight: 600; transition: all 0.3s;">
            <i class="fas fa-graduation-cap"></i> All Courses
          </button>
          <button class="tutor-tab-btn" data-tab="lessons-topics" style="background: transparent; color: rgba(255,255,255,0.7); border: none; padding: 10px 20px; border-radius: 6px 6px 0 0; cursor: pointer; font-weight: 600; transition: all 0.3s;">
            <i class="fas fa-book-open"></i> Lessons & Topics
          </button>
        </div>

        <!-- Tab Content: All Courses -->
        <div id="tutor-courses-list-tab" class="tutor-tab-content">
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h3 style="color: white; margin: 0;">📚 All Courses</h3>
            <button id="tutor-add-course-btn" class="btn btn-primary">
              <i class="fas fa-plus"></i> Add New Course
            </button>
          </div>

          <!-- Courses Table -->
          <div class="card">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
              <h3>📚 All Courses</h3>
              <input type="text" id="tutor-course-search" class="search-input" placeholder="🔍 Search courses..." style="width: 300px; margin-bottom: 0;">
            </div>
            
            <div class="table-responsive">
              <table class="data-table">
                <thead>
                  <tr>
                    <th style="width: 30%;">Course Name</th>
                    <th style="width: 15%;">Status</th>
                    <th style="width: 15%;">Lessons</th>
                    <th style="width: 15%;">Enrolled</th>
                    <th style="width: 10%;">Completion</th>
                    <th style="width: 15%;">Actions</th>
                  </tr>
                </thead>
                <tbody id="tutor-courses-table-body">
                  <tr>
                    <td colspan="6" style="text-align: center; padding: 40px;">
                      <i class="fas fa-spinner fa-spin" style="font-size: 24px; color: #667eea;"></i>
                      <p style="margin-top: 10px; color: #999;">Loading courses...</p>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <!-- Tab Content: Lessons & Topics -->
        <div id="tutor-lessons-topics-tab" class="tutor-tab-content hidden">
          <!-- Header Section -->
          <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 25px; border-radius: 15px; margin-bottom: 25px; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
              <div>
                <h2 style="color: white; margin: 0 0 8px 0; font-size: 28px; display: flex; align-items: center; gap: 10px;">
                  <i class="fas fa-graduation-cap"></i> Course Management
                </h2>
                <p style="color: rgba(255,255,255,0.9); margin: 0; font-size: 15px;">
                  Create and organize your courses, lessons, topics, and quiz questions
                </p>
              </div>
              <div style="display: flex; gap: 10px; align-items: center;">
                <select id="tutor-content-course-filter" style="padding: 10px 15px; border: 2px solid rgba(255,255,255,0.3); background: rgba(255,255,255,0.95); border-radius: 8px; font-size: 14px; min-width: 280px; cursor: pointer;">
                  <option value="">📚 Select Course to Manage</option>
                </select>
                <button id="tutor-add-lesson-btn" class="btn" disabled style="background: rgba(255,255,255,0.2); color: white; border: 2px solid rgba(255,255,255,0.3); padding: 10px 20px; border-radius: 8px; font-weight: 600; cursor: not-allowed; transition: all 0.3s;">
                  <i class="fas fa-plus-circle"></i> Add Lesson
                </button>
              </div>
            </div>
          </div>

          <!-- Main Content Area -->
          <div style="display: grid; grid-template-columns: 1fr; gap: 20px;">
            <!-- Course Tree View - Full Width -->
            <div class="card" style="background: white; border-radius: 15px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.08);">
              <div style="display: flex; justify-content: between; align-items: center; margin-bottom: 20px; border-bottom: 2px solid #f3f4f6; padding-bottom: 15px;">
                <h3 style="margin: 0; color: #1f2937; font-size: 20px; display: flex; align-items: center; gap: 10px;">
                  <i class="fas fa-sitemap" style="color: #667eea;"></i> 
                  Course Structure
                </h3>
                <div style="color: #6b7280; font-size: 14px;">
                  <i class="fas fa-info-circle"></i> Drag to reorder lessons and topics
                </div>
              </div>
              <div id="tutor-content-tree" class="content-tree" style="min-height: 400px;">
                <div style="text-align: center; padding: 60px 20px; color: #9ca3af;">
                  <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); width: 100px; height: 100px; border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);">
                    <i class="fas fa-book-open" style="font-size: 42px; color: white;"></i>
                  </div>
                  <h4 style="color: #4b5563; margin: 0 0 10px 0; font-size: 18px;">No Course Selected</h4>
                  <p style="margin: 0; font-size: 14px; color: #9ca3af;">Select a course from the dropdown above to view and manage its lessons and topics</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- TUTOR COURSE MANAGEMENT MODALS -->

      <!-- Course Modal -->
      <div id="tutor-course-modal" class="modal hidden">
        <div class="modal-content" style="max-width: 700px;">
          <div class="modal-header">
            <h2 id="tutor-course-modal-title">✨ Add New Course</h2>
            <button class="close-modal" onclick="closeTutorCourseModal()">&times;</button>
          </div>
          <div class="modal-body">
            <form id="tutor-course-form">
              <input type="hidden" id="tutor-course-id">
              
              <div class="form-group">
                <label>Course Name <span style="color: #ef4444;">*</span></label>
                <input type="text" id="tutor-course-name" class="form-control" required placeholder="Enter course name">
              </div>

              <div class="grid grid-cols-2 gap-4">
                <div class="form-group">
                  <label>Slug</label>
                  <input type="text" id="tutor-course-slug" class="form-control" placeholder="auto-generated">
                  <small style="color: #6b7280;">URL-friendly identifier (leave empty for auto-generation)</small>
                </div>

                <div class="form-group">
                  <label>Chunk Words</label>
                  <input type="number" id="tutor-course-chunk-words" class="form-control" value="800" min="50" max="2000">
                  <small style="color: #6b7280;">Words per content chunk (default: 800)</small>
                </div>

                <!-- Study Time Limits -->
                <div class="form-group">
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" id="tutor-course-enable-study-time" style="margin-right: 10px;">
                    <span>⏱️ Enable Daily Study Time Limits</span>
                  </label>
                  <small style="color: #6b7280;">Set minimum and maximum study time per day</small>
                </div>

                <div id="tutor-study-time-fields" class="hidden" style="padding-left: 20px; margin-top: 10px;">
                  <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                      <label>Min. Minutes Per Day</label>
                      <input type="number" id="tutor-course-min-study-minutes" class="form-control" value="15" min="0" max="1440">
                      <small style="color: #6b7280;">Minimum daily goal</small>
                    </div>
                    <div class="form-group">
                      <label>Max. Minutes Per Day</label>
                      <input type="number" id="tutor-course-max-study-minutes" class="form-control" value="60" min="0" max="1440">
                      <small style="color: #6b7280;">Maximum allowed per day</small>
                    </div>
                  </div>
                </div>

                <!-- Course Survey -->
                <div class="form-group">
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" id="tutor-course-enable-survey" style="margin-right: 10px;">
                    <span>📋 Enable Course Survey/Feedback</span>
                  </label>
                  <small style="color: #6b7280;">Collect feedback from students upon completion</small>
                </div>

                <div id="tutor-survey-fields" class="hidden" style="padding-left: 20px; margin-top: 10px;">
                  <div class="form-group">
                    <label>Survey Title</label>
                    <input type="text" id="tutor-course-survey-title" class="form-control" placeholder="e.g., Course Feedback">
                  </div>
                  <div class="form-group">
                    <label>Survey Description</label>
                    <textarea id="tutor-course-survey-description" class="form-control" rows="2" placeholder="Brief description shown to students"></textarea>
                  </div>
                  <small style="color: #6b7280;">You can add survey questions after creating the course</small>
                </div>
              </div>

              <div class="form-group">
                <label>Short Description</label>
                <textarea id="tutor-course-description" class="form-control" rows="3" placeholder="Brief description of the course"></textarea>
              </div>

              <div class="form-group">
                <label style="display: flex; align-items: center; cursor: pointer;">
                  <input type="checkbox" id="tutor-course-has-prerequisite" style="margin-right: 10px;">
                  <span>This course requires a prerequisite</span>
                </label>
              </div>

              <div id="tutor-prerequisite-select-container" class="form-group hidden">
                <label>Select Prerequisite Course <span style="color: #ef4444;">*</span></label>
                <select id="tutor-course-prerequisite" class="form-control">
                  <option value="">-- Select a prerequisite course --</option>
                </select>
                <small style="color: #6b7280;">Users must complete this course before accessing the current one</small>
              </div>

              <div class="form-group">
                <label style="font-weight: 600; margin-bottom: 10px;">Completion Behavior</label>
                <div style="display: flex; gap: 20px; margin-bottom: 15px;">
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="radio" name="tutor-completion-type" value="certificate" id="tutor-completion-certificate" style="margin-right: 8px;">
                    <span>📜 Issue Certificate</span>
                  </label>
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="radio" name="tutor-completion-type" value="instructions" id="tutor-completion-instructions-radio" style="margin-right: 8px;">
                    <span>📋 Show Instructions</span>
                  </label>
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="radio" name="tutor-completion-type" value="none" id="tutor-completion-none" checked style="margin-right: 8px;">
                    <span>❌ None</span>
                  </label>
                </div>
              </div>

              <div id="tutor-certificate-template-group" class="form-group hidden">
                <label>Certificate Template (HTML)</label>
                <textarea id="tutor-course-certificate" class="form-control" rows="4" placeholder="HTML template for completion certificate. Use @{{user_name}}, @{{completion_date}}, @{{score}} as placeholders."></textarea>
                <small style="color: #6b7280;">Design a certificate that will be generated when users complete the course</small>
              </div>

              <div id="tutor-completion-instructions-group" class="form-group hidden">
                <label>Completion Instructions</label>
                <textarea id="tutor-course-instructions" class="form-control" rows="4" placeholder="Instructions or next steps shown to users upon course completion"></textarea>
                <small style="color: #6b7280;">Provide guidance on what students should do after completing this course</small>
              </div>

              <div class="form-group">
                <label style="display: flex; align-items: center; cursor: pointer;">
                  <input type="checkbox" id="tutor-course-active" style="margin-right: 10px;" checked>
                  <span>Active Course</span>
                </label>
                <small style="color: #6b7280;">Only active courses are visible to users</small>
              </div>

              <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                <button type="button" class="btn btn-secondary" onclick="closeTutorCourseModal()">Cancel</button>
                <button type="submit" class="btn btn-primary" id="tutor-save-course-btn">
                  <i class="fas fa-save"></i> <span id="tutor-save-course-text">Create Course</span>
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Survey Management Modal -->
      <div id="tutor-survey-modal" class="modal hidden">
        <div class="modal-content" style="max-width: 800px; max-height: 90vh; overflow-y: auto;">
          <div class="modal-header">
            <h2 id="tutor-survey-modal-title">📋 Manage Course Survey</h2>
            <button class="close-modal" onclick="closeTutorSurveyModal()">&times;</button>
          </div>
          <div class="modal-body">
            <div style="background: #f0f9ff; border-left: 4px solid #3b82f6; padding: 15px; margin-bottom: 20px; border-radius: 4px;">
              <p style="color: #1e40af; font-size: 14px; margin: 0;">
                <i class="fas fa-info-circle"></i> Create survey questions to collect feedback from students when they complete this course.
              </p>
            </div>

            <div id="tutor-survey-questions-list" style="margin-bottom: 20px;">
              <!-- Questions will be dynamically added here -->
            </div>

            <button type="button" class="btn btn-secondary" onclick="addTutorSurveyQuestion()" style="width: 100%; margin-bottom: 20px;">
              <i class="fas fa-plus"></i> Add Question
            </button>

            <div style="display: flex; gap: 10px; justify-content: flex-end;">
              <button type="button" class="btn btn-secondary" onclick="closeTutorSurveyModal()">
                Cancel
              </button>
              <button type="button" class="btn btn-primary" onclick="saveTutorSurveyQuestions()">
                <i class="fas fa-save"></i> Save Survey
              </button>
            </div>
          </div>
        </div>
      </div>

      <!-- Delete Confirmation Modal -->
      <div id="tutor-delete-course-modal" class="modal hidden">
        <div class="modal-content" style="max-width: 500px;">
          <div class="modal-header" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">
            <h2>🗑️ Delete Course</h2>
            <button class="close-modal" onclick="closeTutorDeleteCourseModal()">&times;</button>
          </div>
          <div class="modal-body">
            <p style="font-size: 16px; color: #374151; margin-bottom: 15px;">
              Are you sure you want to delete this course?
            </p>
            <div style="background: #fee2e2; border-left: 4px solid #ef4444; padding: 15px; margin-bottom: 20px; border-radius: 4px;">
              <p style="font-weight: 600; color: #991b1b; margin-bottom: 5px;">⚠️ This action cannot be undone!</p>
              <p style="color: #7f1d1d; font-size: 14px;">This will permanently delete:</p>
              <ul style="color: #7f1d1d; font-size: 14px; margin-left: 20px; margin-top: 5px;">
                <li>Course details and settings</li>
                <li>All lessons and topics</li>
                <li>All user progress data</li>
                <li>Quiz questions and results</li>
              </ul>
            </div>
            <div style="background: #f9fafb; padding: 15px; border-radius: 4px; margin-bottom: 20px;">
              <p style="font-weight: 600; color: #374151; margin-bottom: 5px;">Course: <span id="tutor-delete-course-name" style="color: #667eea;"></span></p>
              <p style="font-size: 14px; color: #6b7280;">ID: <span id="tutor-delete-course-id"></span></p>
            </div>
            <div style="display: flex; justify-content: flex-end; gap: 10px;">
              <button type="button" class="btn btn-secondary" onclick="closeTutorDeleteCourseModal()">Cancel</button>
              <button type="button" class="btn btn-danger" onclick="confirmTutorDeleteCourse()">
                <i class="fas fa-trash"></i> Delete Permanently
              </button>
            </div>
          </div>
        </div>
      </div>

      <!-- Lesson Modal -->
      <div id="tutor-lessonModal" class="modal hidden">
        <div class="modal-content" style="max-width: 800px; max-height: 90vh; overflow-y: auto;">
          <div class="modal-header">
            <h2 id="tutor-lesson-modal-title">Add New Lesson</h2>
            <button class="close-modal" onclick="closeTutorModal('tutor-lessonModal')">&times;</button>
          </div>
          <div class="modal-body">
            <form id="tutor-lesson-form">
              <input type="hidden" id="tutor-lesson-id" name="id">
              <input type="hidden" id="tutor-lesson-course-id" name="course_id">
              
              <div class="form-group">
                <label>Lesson Name <span style="color: #ef4444;">*</span></label>
                <input type="text" id="tutor-lesson-name" name="name" class="form-control" required placeholder="Enter lesson name">
              </div>

              <div class="form-group">
                <label>Description</label>
                <textarea id="tutor-lesson-description" name="intro" class="form-control" rows="4" placeholder="Brief description of the lesson"></textarea>
              </div>

              <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                <button type="button" class="btn btn-secondary" onclick="closeTutorModal('tutor-lessonModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">
                  <i class="fas fa-save"></i> Save Lesson
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Topic Modal -->
      <div id="tutor-topicModal" class="modal hidden">
        <div class="modal-content" style="max-width: 900px; max-height: 90vh; overflow-y: auto;">
          <div class="modal-header">
            <h2 id="tutor-topic-modal-title">Add New Topic</h2>
            <button class="close-modal" onclick="closeTutorModal('tutor-topicModal')">&times;</button>
          </div>
          <div class="modal-body">
            <form id="tutor-topic-form">
              <input type="hidden" id="tutor-topic-id" name="topic_id">
              <input type="hidden" id="tutor-topic-lesson-id" name="lesson_id">
              
              <div class="form-group">
                <label>Topic Title <span style="color: #ef4444;">*</span></label>
                <input type="text" id="tutor-topic-title" name="title" class="form-control" required placeholder="Enter topic title">
              </div>

              <div class="form-group">
                <label>Content</label>
                <textarea id="tutor-topic-body" name="body" class="form-control" rows="8" placeholder="Enter topic content..."></textarea>
              </div>

              <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                <div class="form-group">
                  <label>📹 Video URL (optional)</label>
                  <input type="url" id="tutor-topic-video-url" name="video_url" class="form-control" placeholder="https://youtube.com/watch?v=...">
                  <p class="text-sm" style="margin-top: 5px; color: #6b7280;">YouTube, Vimeo, or direct video URL</p>
                </div>

                <div class="form-group">
                  <label>🖼️ Image URL (optional)</label>
                  <input type="url" id="tutor-topic-image-url" name="image_url" class="form-control" placeholder="https://...">
                </div>
              </div>

              <div class="form-group" style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 15px; background: #f9fafb;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                  <div>
                    <label style="margin: 0; font-weight: 600;">👁️ Publish Topic</label>
                    <p class="text-sm" style="margin-top: 5px; color: #6b7280;">Make this topic visible to students</p>
                  </div>
                  <label class="switch">
                    <input type="checkbox" id="tutor-topic-is-published" name="is_published" checked>
                    <span class="slider round"></span>
                  </label>
                </div>
              </div>

              <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                <button type="button" class="btn btn-secondary" onclick="closeTutorModal('tutor-topicModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">
                  <i class="fas fa-save"></i> Save Topic
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Students Section -->
      <section id="students" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-users"></i> Students Overview
        </h1>

        <div class="stats-grid" style="margin-bottom: 30px;">
          <div class="stat-card" onclick="showStudentDetails('total')" style="cursor: pointer; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
            <div class="icon" style="color: #667eea;">
              <i class="fas fa-users"></i>
            </div>
            <div class="value">{{ $totalStudents }}</div>
            <div class="label">Total Students</div>
            <div style="font-size: 11px; color: #6b7280; margin-top: 8px;">
              <i class="fas fa-mouse-pointer"></i> Click for details
            </div>
          </div>

          <div class="stat-card" onclick="showStudentDetails('active')" style="cursor: pointer; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
            <div class="icon" style="color: #10b981;">
              <i class="fas fa-user-check"></i>
            </div>
            <div class="value">{{ $activeStudents }}</div>
            <div class="label">Active Students</div>
            <div style="font-size: 11px; color: #6b7280; margin-top: 8px;">
              <i class="fas fa-mouse-pointer"></i> Click for details
            </div>
          </div>

          <div class="stat-card" onclick="showStudentDetails('recent')" style="cursor: pointer; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
            <div class="icon" style="color: #f59e0b;">
              <i class="fas fa-user-plus"></i>
            </div>
            <div class="value">{{ $recentEnrollments }}</div>
            <div class="label">New This Week</div>
            <div style="font-size: 11px; color: #6b7280; margin-top: 8px;">
              <i class="fas fa-mouse-pointer"></i> Click for details
            </div>
          </div>
        </div>

        @if($studentsNeedingAttention->count() > 0)
          <div class="card">
            <h3><i class="fas fa-exclamation-triangle"></i> Students Needing Attention</h3>
            <div>
              @foreach($studentsNeedingAttention as $progress)
                <div class="attention-item">
                  <div class="student-name">
                    <i class="fas fa-user"></i> {{ $progress->user->name }}
                  </div>
                  <div class="progress-info">
                    Lesson: {{ $progress->lesson->title }} 
                    @if($progress->lesson->course)
                      (Course: {{ $progress->lesson->course->name }})
                    @endif
                    • Status: Not completed
                    • Last active: {{ $progress->updated_at->diffForHumans() }}
                  </div>
                </div>
              @endforeach
            </div>
          </div>
        @endif
      </section>

      <!-- Activity Section -->
      <section id="activity" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-history"></i> Recent Activity
        </h1>

        <div class="card">
          <h3><i class="fas fa-clock"></i> Latest Student Actions</h3>
          @if($recentActivities->count() > 0)
            <div class="activity-feed">
              @foreach($recentActivities as $activity)
                <div class="activity-item">
                  <div class="activity-user">
                    <i class="fas fa-user-circle"></i> {{ $activity->user->name }}
                  </div>
                  <div class="activity-action">
                    @if($activity->completed)
                      <i class="fas fa-check-circle" style="color: #10b981;"></i> Completed
                    @else
                      <i class="fas fa-play-circle" style="color: #3b82f6;"></i> Started
                    @endif
                    "{{ $activity->lesson->title }}"
                    @if($activity->lesson->course)
                      in <strong>{{ $activity->lesson->course->name }}</strong>
                    @endif
                  </div>
                  <div class="activity-time">
                    <i class="fas fa-clock"></i> {{ $activity->updated_at->diffForHumans() }}
                  </div>
                </div>
              @endforeach
            </div>
          @else
            <div class="empty-state">
              <i class="fas fa-history"></i>
              <p>No recent activity</p>
            </div>
          @endif
        </div>
      </section>

      <!-- Analytics Section -->
      <section id="analytics" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-chart-line"></i> Analytics
        </h1>

        @if($monthlyEnrollments->count() > 0)
          <div class="card">
            <h3><i class="fas fa-chart-area"></i> Enrollment Trend (Last 6 Months)</h3>
            <div class="chart-container">
              <canvas id="enrollmentChart"></canvas>
            </div>
          </div>
        @endif

        <div class="stats-grid" style="margin-top: 20px;">
          <div class="stat-card">
            <div class="icon" style="color: #667eea;">
              <i class="fas fa-percentage"></i>
            </div>
            <div class="value">{{ $averageProgress }}%</div>
            <div class="label">Average Progress</div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #10b981;">
              <i class="fas fa-check-double"></i>
            </div>
            <div class="value">{{ $completedCourses }}</div>
            <div class="label">Completed Lessons</div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #ec4899;">
              <i class="fas fa-certificate"></i>
            </div>
            <div class="value">{{ $certificatesIssued }}</div>
            <div class="label">Certificates Issued</div>
          </div>
        </div>
      </section>

      <!-- Certificates Section -->
      <section id="certificates" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-certificate"></i> Certificate Template Builder
        </h1>

        <div class="card" style="padding: 0; overflow: hidden;">
          <iframe 
            src="/tutor/certificates-builder" 
            style="width: 100%; height: 80vh; border: none; display: block;"
            title="Certificate Template Builder">
          </iframe>
        </div>
      </section>

      <!-- Badges Section -->
      <section id="badges" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-trophy"></i> Badge Management
        </h1>

        <div class="card" style="padding: 20px;">
          <p style="color: #374151; font-size: 16px; line-height: 1.6;">
            <strong>Badge Management System</strong><br>
            Badges are managed at the system level. As a tutor, you can view which badges your students have earned for completing your courses.
          </p>
          <br>
          <p style="color: #6b7280; font-size: 14px;">
            <i class="fas fa-info-circle"></i> Contact your administrator to create or modify badge templates.
          </p>
          <br>
          <div style="background: #f3f4f6; padding: 20px; border-radius: 8px; margin-top: 20px;">
            <h3 style="color: #374151; margin-bottom: 15px;">📊 Badge Statistics</h3>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
              <div style="background: white; padding: 15px; border-radius: 8px; text-align: center;">
                <i class="fas fa-award" style="font-size: 32px; color: #667eea; margin-bottom: 10px;"></i>
                <h4 style="color: #374151; font-size: 24px; margin: 5px 0;">{{ $totalBadges ?? 0 }}</h4>
                <p style="color: #6b7280; font-size: 14px;">Total Badges</p>
              </div>
              <div style="background: white; padding: 15px; border-radius: 8px; text-align: center;">
                <i class="fas fa-users" style="font-size: 32px; color: #10b981; margin-bottom: 10px;"></i>
                <h4 style="color: #374151; font-size: 24px; margin: 5px 0;">{{ $studentsWithBadges ?? 0 }}</h4>
                <p style="color: #6b7280; font-size: 14px;">Students Awarded</p>
              </div>
              <div style="background: white; padding: 15px; border-radius: 8px; text-align: center;">
                <i class="fas fa-star" style="font-size: 32px; color: #f59e0b; margin-bottom: 10px;"></i>
                <h4 style="color: #374151; font-size: 24px; margin: 5px 0;">{{ $badgesEarned ?? 0 }}</h4>
                <p style="color: #6b7280; font-size: 14px;">Badges Earned</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- Quick Actions Section -->
      <section id="quick-actions" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-bolt"></i> Quick Actions
        </h1>

        <div class="card">
          <div class="quick-actions">
            <a href="javascript:void(0)" onclick="showCreateCourseModal()" class="action-btn">
              <i class="fas fa-plus-circle"></i>
              <span>Create Course</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=courses]').click()" class="action-btn">
              <i class="fas fa-edit"></i>
              <span>Manage Courses</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=students]').click()" class="action-btn">
              <i class="fas fa-users"></i>
              <span>View Students</span>
            </a>
            <a href="javascript:void(0)" onclick="loadCourses()" class="action-btn">
              <i class="fas fa-sync"></i>
              <span>Refresh Data</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=certificates]').click()" class="action-btn">
              <i class="fas fa-certificate"></i>
              <span>Certificates</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=badges]').click()" class="action-btn">
              <i class="fas fa-trophy"></i>
              <span>Badges</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=analytics]').click()" class="action-btn">
              <i class="fas fa-chart-line"></i>
              <span>Analytics</span>
            </a>
          </div>
        </div>
      </section>
    </div>
  </div>

  <!-- Course Modal -->
  <div id="course-modal" class="modal hidden" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; padding: 20px; overflow-y: auto;">
    <div class="modal-content" style="max-width: 700px; margin: 50px auto; background: white; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
      <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px 30px; border-radius: 12px 12px 0 0; display: flex; justify-content: space-between; align-items: center;">
        <h2 id="course-modal-title" style="margin: 0; font-size: 24px;">✨ Add New Course</h2>
        <button class="close-modal" onclick="closeCourseModal()" style="background: none; border: none; color: white; font-size: 32px; cursor: pointer; line-height: 1; padding: 0; width: 32px; height: 32px;">&times;</button>
      </div>
      <div class="modal-body" style="padding: 30px;">
        <form id="course-form">
          <input type="hidden" id="course-id">
          
          <div class="form-group" style="margin-bottom: 20px;">
            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Course Name <span style="color: #ef4444;">*</span></label>
            <input type="text" id="course-name" class="form-control" required placeholder="Enter course name" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px;">
          </div>

          <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px; margin-bottom: 20px;">
            <div class="form-group">
              <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Slug</label>
              <input type="text" id="course-slug" class="form-control" placeholder="auto-generated" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px;">
              <small style="color: #6b7280; font-size: 12px;">URL-friendly identifier</small>
            </div>

            <div class="form-group">
              <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Chunk Words</label>
              <input type="number" id="course-chunk-words" class="form-control" value="800" min="50" max="2000" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px;">
              <small style="color: #6b7280; font-size: 12px;">Words per content chunk</small>
            </div>
          </div>

          <!-- Study Time Limits -->
          <div class="form-group" style="margin-bottom: 15px;">
            <label style="display: flex; align-items: center; cursor: pointer;">
              <input type="checkbox" id="enable-study-time" style="margin-right: 10px;">
              <span style="font-weight: 600;">⏱️ Enable Daily Study Time Limits</span>
            </label>
            <small style="color: #6b7280; font-size: 12px;">Set minimum and maximum study time per day</small>
          </div>

          <div id="study-time-fields" class="hidden" style="padding-left: 20px; margin-bottom: 20px;">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
              <div class="form-group">
                <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Min. Minutes/Day</label>
                <input type="number" id="min-study-minutes" class="form-control" value="15" min="0" max="1440" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px;">
              </div>
              <div class="form-group">
                <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Max. Minutes/Day</label>
                <input type="number" id="max-study-minutes" class="form-control" value="60" min="0" max="1440" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px;">
              </div>
            </div>
          </div>

          <!-- Course Survey -->
          <div class="form-group" style="margin-bottom: 15px;">
            <label style="display: flex; align-items: center; cursor: pointer;">
              <input type="checkbox" id="enable-survey" style="margin-right: 10px;">
              <span style="font-weight: 600;">📋 Enable Course Survey/Feedback</span>
            </label>
            <small style="color: #6b7280; font-size: 12px;">Collect feedback from students upon completion</small>
          </div>

          <div id="survey-fields" class="hidden" style="padding-left: 20px; margin-bottom: 20px;">
            <div class="form-group" style="margin-bottom: 15px;">
              <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Survey Title</label>
              <input type="text" id="survey-title" class="form-control" placeholder="e.g., Course Feedback" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px;">
            </div>
            <div class="form-group">
              <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Survey Description</label>
              <textarea id="survey-description" class="form-control" rows="2" placeholder="Brief description shown to students" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px;"></textarea>
            </div>
            <small style="color: #6b7280; font-size: 12px;">You can add survey questions after creating the course</small>
          </div>

          <div class="form-group" style="margin-bottom: 20px;">
            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Short Description</label>
            <textarea id="course-description" class="form-control" rows="3" placeholder="Brief description of the course" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px; resize: vertical;"></textarea>
          </div>

          <div class="form-group" style="margin-bottom: 20px;">
            <label style="display: flex; align-items: center; cursor: pointer;">
              <input type="checkbox" id="course-has-prerequisite" style="margin-right: 10px; width: 18px; height: 18px; cursor: pointer;">
              <span style="font-weight: 600; color: #374151;">This course requires a prerequisite</span>
            </label>
          </div>

          <div id="prerequisite-select-container" class="form-group hidden" style="margin-bottom: 20px; display: none;">
            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Select Prerequisite Course <span style="color: #ef4444;">*</span></label>
            <select id="course-prerequisite" class="form-control" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px;">
              <option value="">-- Select a prerequisite course --</option>
            </select>
            <small style="color: #6b7280; font-size: 12px;">Users must complete this course before accessing the current one</small>
          </div>

          <div class="form-group" style="margin-bottom: 20px;">
            <label style="font-weight: 600; margin-bottom: 10px; display: block; color: #374151;">Completion Behavior</label>
            <div style="display: flex; gap: 20px; margin-bottom: 15px; flex-wrap: wrap;">
              <label style="display: flex; align-items: center; cursor: pointer;">
                <input type="radio" name="completion-type" value="certificate" id="completion-certificate" style="margin-right: 8px; cursor: pointer;">
                <span style="color: #374151;">📜 Issue Certificate</span>
              </label>
              <label style="display: flex; align-items: center; cursor: pointer;">
                <input type="radio" name="completion-type" value="instructions" id="completion-instructions-radio" style="margin-right: 8px; cursor: pointer;">
                <span style="color: #374151;">📋 Show Instructions</span>
              </label>
              <label style="display: flex; align-items: center; cursor: pointer;">
                <input type="radio" name="completion-type" value="none" id="completion-none" checked style="margin-right: 8px; cursor: pointer;">
                <span style="color: #374151;">❌ None</span>
              </label>
            </div>
          </div>

          <div id="certificate-template-group" class="form-group hidden" style="margin-bottom: 20px; display: none;">
            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Certificate Template (HTML)</label>
            <textarea id="course-certificate" class="form-control" rows="4" placeholder="HTML template for completion certificate. Use @{{user_name}}, @{{completion_date}}, @{{score}} as placeholders." style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px; font-family: monospace; resize: vertical;"></textarea>
            <small style="color: #6b7280; font-size: 12px;">Design a certificate that will be generated when users complete the course</small>
          </div>

          <div id="completion-instructions-group" class="form-group hidden" style="margin-bottom: 20px; display: none;">
            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #374151;">Completion Instructions</label>
            <textarea id="course-instructions" class="form-control" rows="4" placeholder="Instructions or next steps shown to users upon course completion" style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; font-size: 14px; resize: vertical;"></textarea>
            <small style="color: #6b7280; font-size: 12px;">Provide guidance on what students should do after completing this course</small>
          </div>

          <div class="form-group" style="margin-bottom: 20px;">
            <label style="display: flex; align-items: center; cursor: pointer;">
              <input type="checkbox" id="course-active" style="margin-right: 10px; width: 18px; height: 18px; cursor: pointer;" checked>
              <span style="font-weight: 600; color: #374151;">Active Course</span>
            </label>
            <small style="color: #6b7280; font-size: 12px; display: block; margin-top: 4px; margin-left: 28px;">Only active courses are visible to users</small>
          </div>

          <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px; padding-top: 20px; border-top: 1px solid #e5e7eb;">
            <button type="button" class="btn btn-secondary" onclick="closeCourseModal()" style="padding: 12px 24px; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; background: #e5e7eb; color: #374151;">Cancel</button>
            <button type="submit" class="btn btn-primary" id="save-course-btn" style="padding: 12px 24px; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
              <i class="fas fa-save"></i> <span id="save-course-text">Create Course</span>
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Delete Confirmation Modal -->
  <div id="delete-course-modal" class="modal hidden" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; padding: 20px; overflow-y: auto;">
    <div class="modal-content" style="max-width: 500px; margin: 100px auto; background: white; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
      <div class="modal-header" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); color: white; padding: 20px 30px; border-radius: 12px 12px 0 0; display: flex; justify-content: space-between; align-items: center;">
        <h2 style="margin: 0; font-size: 24px;">🗑️ Delete Course</h2>
        <button class="close-modal" onclick="closeDeleteCourseModal()" style="background: none; border: none; color: white; font-size: 32px; cursor: pointer; line-height: 1; padding: 0; width: 32px; height: 32px;">&times;</button>
      </div>
      <div class="modal-body" style="padding: 30px;">
        <p style="font-size: 16px; color: #374151; margin-bottom: 15px;">
          Are you sure you want to delete this course?
        </p>
        <div style="background: #fee2e2; border-left: 4px solid #ef4444; padding: 15px; margin-bottom: 20px; border-radius: 4px;">
          <p style="font-weight: 600; color: #991b1b; margin-bottom: 5px;">⚠️ This action cannot be undone!</p>
          <p style="color: #7f1d1d; font-size: 14px;">This will permanently delete:</p>
          <ul style="color: #7f1d1d; font-size: 14px; margin-left: 20px; margin-top: 5px;">
            <li>Course details and settings</li>
            <li>All lessons and topics</li>
            <li>All user progress data</li>
            <li>Quiz questions and results</li>
          </ul>
        </div>
        <div style="background: #f9fafb; padding: 15px; border-radius: 4px; margin-bottom: 20px;">
          <p style="font-weight: 600; color: #374151; margin-bottom: 5px;">Course: <span id="delete-course-name" style="color: #667eea;"></span></p>
          <p style="font-size: 14px; color: #6b7280;">ID: <span id="delete-course-id"></span></p>
        </div>
        <div style="display: flex; justify-content: flex-end; gap: 10px;">
          <button type="button" class="btn btn-secondary" onclick="closeDeleteCourseModal()" style="padding: 12px 24px; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; background: #e5e7eb; color: #374151;">Cancel</button>
          <button type="button" class="btn-danger" onclick="confirmDeleteCourse()" style="padding: 12px 24px; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; background: #ef4444; color: white;">
            <i class="fas fa-trash"></i> Delete Permanently
          </button>
        </div>
      </div>
    </div>
  </div>

  <!-- Student Details Modal -->
  <div id="student-details-modal" class="modal hidden" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; padding: 20px; overflow-y: auto;">
    <div class="modal-content" style="max-width: 1000px; margin: 50px auto; background: white; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
      <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px 30px; border-radius: 12px 12px 0 0; display: flex; justify-content: space-between; align-items: center;">
        <h2 id="student-modal-title" style="margin: 0; font-size: 24px;">👥 Student Details</h2>
        <button class="close-modal" onclick="closeStudentModal()" style="background: none; border: none; color: white; font-size: 32px; cursor: pointer; line-height: 1; padding: 0; width: 32px; height: 32px;">&times;</button>
      </div>
      <div class="modal-body" style="padding: 30px;">
        <div id="student-list-content" style="min-height: 300px;">
          <div style="text-align: center; padding: 40px;">
            <i class="fas fa-spinner fa-spin" style="font-size: 32px; color: #667eea;"></i>
            <p style="margin-top: 15px; color: #6b7280;">Loading student data...</p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script>
    // Navigation
    document.querySelectorAll('.nav-item').forEach(item => {
      item.addEventListener('click', function() {
        const section = this.getAttribute('data-section');
        
        // Remove active class from all nav items and sections
        document.querySelectorAll('.nav-item').forEach(nav => nav.classList.remove('active'));
        document.querySelectorAll('.section').forEach(sec => sec.classList.remove('active'));
        
        // Add active class to clicked nav item and corresponding section
        this.classList.add('active');
        document.getElementById(section).classList.add('active');
      });
    });

    // Enrollment Chart
    @if($monthlyEnrollments->count() > 0)
    const ctx = document.getElementById('enrollmentChart');
    if (ctx) {
      new Chart(ctx, {
        type: 'line',
        data: {
          labels: {!! json_encode($monthlyEnrollments->pluck('month')->map(function($m) {
            return date('M Y', strtotime($m . '-01'));
          })) !!},
          datasets: [{
            label: 'New Students',
            data: {!! json_encode($monthlyEnrollments->pluck('count')) !!},
            borderColor: '#667eea',
            backgroundColor: 'rgba(102, 126, 234, 0.1)',
            borderWidth: 3,
            fill: true,
            tension: 0.4,
            pointRadius: 5,
            pointBackgroundColor: '#667eea',
            pointBorderColor: '#fff',
            pointBorderWidth: 2,
            pointHoverRadius: 7
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: {
              display: false
            },
            tooltip: {
              backgroundColor: 'rgba(0,0,0,0.8)',
              padding: 12,
              borderRadius: 8,
              titleFont: {
                size: 14,
                weight: 'bold'
              },
              bodyFont: {
                size: 13
              }
            }
          },
          scales: {
            y: {
              beginAtZero: true,
              ticks: {
                stepSize: 1,
                font: {
                  size: 12
                }
              },
              grid: {
                color: 'rgba(0,0,0,0.05)'
              }
            },
            x: {
              ticks: {
                font: {
                  size: 12
                }
              },
              grid: {
                display: false
              }
            }
          }
        }
      });
    }
    @endif

    // API Helper Function
    async function apiCall(url, method = 'GET', data = null) {
      // Add cache-busting timestamp to GET requests
      if (method === 'GET') {
        const separator = url.includes('?') ? '&' : '?';
        url = `${url}${separator}_t=${Date.now()}`;
      }
      
      const options = {
        method: method,
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
          'Accept': 'application/json',
          'Cache-Control': 'no-cache, no-store, must-revalidate',
          'Pragma': 'no-cache',
          'Expires': '0'
        }
      };

      if (data && (method === 'POST' || method === 'PUT')) {
        options.body = JSON.stringify(data);
      }

      try {
        const response = await fetch(url, options);
        const result = await response.json();
        
        if (!response.ok) {
          throw new Error(result.message || 'Request failed');
        }
        
        return result;
      } catch (error) {
        console.error('API Error:', error);
        alert('Error: ' + error.message);
        throw error;
      }
    }

    // Show notification
    function showNotification(message, type = 'success') {
      const notification = document.createElement('div');
      notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        padding: 15px 25px;
        background: ${type === 'success' ? '#10b981' : '#ef4444'};
        color: white;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        z-index: 10000;
        animation: slideIn 0.3s ease-out;
      `;
      notification.textContent = message;
      document.body.appendChild(notification);
      
      setTimeout(() => {
        notification.style.animation = 'slideOut 0.3s ease-out';
        setTimeout(() => notification.remove(), 300);
      }, 3000);
    }

    // Load Courses
    async function loadCourses() {
      try {
        const courses = await apiCall('/tutor/courses');
        console.log('Courses loaded:', courses);
        showNotification('Courses refreshed successfully!');
      } catch (error) {
        console.error('Failed to load courses:', error);
      }
    }

    // Course Modal Variables
    let currentCourseId = null;
    let deleteCourseId = null;

    // Show Create Course Modal
    function showCreateCourseModal() {
      openCourseModal();
    }

    // Open Course Modal (for create or edit)
    async function openCourseModal(courseId = null) {
      currentCourseId = courseId;
      const modal = document.getElementById('course-modal');
      const title = document.getElementById('course-modal-title');
      const saveText = document.getElementById('save-course-text');
      
      // Reset form
      document.getElementById('course-form').reset();
      document.getElementById('course-id').value = '';
      document.getElementById('course-chunk-words').value = '800';
      document.getElementById('course-active').checked = true;
      document.getElementById('prerequisite-select-container').style.display = 'none';
      document.getElementById('course-has-prerequisite').checked = false;
      document.getElementById('certificate-template-group').style.display = 'none';
      document.getElementById('completion-instructions-group').style.display = 'none';
      document.getElementById('completion-none').checked = true;
      
      // Reset study time and survey fields
      document.getElementById('enable-study-time').checked = false;
      document.getElementById('study-time-fields').classList.add('hidden');
      document.getElementById('min-study-minutes').value = '15';
      document.getElementById('max-study-minutes').value = '60';
      document.getElementById('enable-survey').checked = false;
      document.getElementById('survey-fields').classList.add('hidden');
      document.getElementById('survey-title').value = '';
      document.getElementById('survey-description').value = '';

      // Load available prerequisites
      await loadAvailablePrerequisites(courseId);

      if (courseId) {
        // Edit mode
        title.textContent = '✏️ Edit Course';
        saveText.textContent = 'Update Course';
        
        try {
          const data = await apiCall(`/tutor/courses/${courseId}`);
          const course = data.course || data;
          
          document.getElementById('course-id').value = course.id;
          document.getElementById('course-name').value = course.name;
          document.getElementById('course-slug').value = course.slug || '';
          document.getElementById('course-description').value = course.short_description || '';
          document.getElementById('course-chunk-words').value = course.chunk_words || 800;
          
          // Study time limits
          document.getElementById('enable-study-time').checked = course.enable_study_time_limit || false;
          document.getElementById('min-study-minutes').value = course.min_study_minutes_per_day || 15;
          document.getElementById('max-study-minutes').value = course.max_study_minutes_per_day || 60;
          if (course.enable_study_time_limit) {
            document.getElementById('study-time-fields').classList.remove('hidden');
          }
          
          // Survey settings
          document.getElementById('enable-survey').checked = course.enable_survey || false;
          document.getElementById('survey-title').value = course.survey_title || '';
          document.getElementById('survey-description').value = course.survey_description || '';
          if (course.enable_survey) {
            document.getElementById('survey-fields').classList.remove('hidden');
          }
          
          document.getElementById('course-certificate').value = course.certificate_template || '';
          document.getElementById('course-instructions').value = course.completion_instructions || '';
          document.getElementById('course-active').checked = course.is_active;
          
          // Set completion type radio buttons
          if (course.certificate_template) {
            document.getElementById('completion-certificate').checked = true;
            document.getElementById('certificate-template-group').style.display = 'block';
          } else if (course.completion_instructions) {
            document.getElementById('completion-instructions-radio').checked = true;
            document.getElementById('completion-instructions-group').style.display = 'block';
          } else {
            document.getElementById('completion-none').checked = true;
          }
          
          if (course.has_prerequisite && course.prerequisite_course_id) {
            document.getElementById('course-has-prerequisite').checked = true;
            document.getElementById('prerequisite-select-container').style.display = 'block';
            document.getElementById('course-prerequisite').value = course.prerequisite_course_id;
          }
        } catch (error) {
          showNotification('Error loading course details', 'error');
          return;
        }
      } else {
        // Create mode
        title.textContent = '✨ Add New Course';
        saveText.textContent = 'Create Course';
      }

      modal.style.display = 'flex';
      modal.classList.remove('hidden');
    }

    async function loadAvailablePrerequisites(excludeCourseId = null) {
      try {
        const data = await apiCall('/tutor/courses');
        const courses = data.courses || data;
        
        const select = document.getElementById('course-prerequisite');
        select.innerHTML = '<option value="">-- Select a prerequisite course --</option>';
        
        if (courses && courses.length > 0) {
          courses.forEach(course => {
            if (!excludeCourseId || course.id != excludeCourseId) {
              select.innerHTML += `<option value="${course.id}">${course.name}</option>`;
            }
          });
        }
      } catch (error) {
        console.error('Error loading prerequisites:', error);
      }
    }

    function closeCourseModal() {
      document.getElementById('course-modal').style.display = 'none';
      document.getElementById('course-modal').classList.add('hidden');
      currentCourseId = null;
    }

    function showDeleteCourseModal(courseId, courseName) {
      deleteCourseId = courseId;
      document.getElementById('delete-course-name').textContent = courseName;
      document.getElementById('delete-course-id').textContent = courseId;
      const modal = document.getElementById('delete-course-modal');
      modal.style.display = 'flex';
      modal.classList.remove('hidden');
    }

    function closeDeleteCourseModal() {
      document.getElementById('delete-course-modal').style.display = 'none';
      document.getElementById('delete-course-modal').classList.add('hidden');
      deleteCourseId = null;
    }

    async function confirmDeleteCourse() {
      if (!deleteCourseId) return;

      try {
        await apiCall(`/tutor/courses/${deleteCourseId}`, 'DELETE');
        showNotification('Course deleted successfully!');
        closeDeleteCourseModal();
        setTimeout(() => location.reload(), 1000);
      } catch (error) {
        showNotification('Error deleting course', 'error');
      }
    }

    // Prerequisite checkbox toggle
    document.addEventListener('DOMContentLoaded', function() {
      // Initialize TinyMCE for topic body editor
      tinymce.init({
        selector: '#topic-body',
        height: 400,
        menubar: true,
        plugins: [
          'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
          'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
          'insertdatetime', 'media', 'table', 'help', 'wordcount'
        ],
        toolbar: 'undo redo | blocks | bold italic forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help',
        content_style: `
          body { 
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; 
            font-size: 14px; 
            background-color: #ffffff !important; 
            color: #000000 !important;
            padding: 10px;
          }
          body.mce-content-body { 
            background-color: #ffffff !important; 
            color: #000000 !important;
          }
          * {
            background-color: transparent;
          }
          p, h1, h2, h3, h4, h5, h6, li, td, th, div, span {
            color: #000000 !important;
          }
        `,
        branding: false,
        promotion: false,
        readonly: false,
        setup: function(editor) {
          editor.on('init', function() {
            editor.mode.set('design');
            const body = editor.getBody();
            if (body) {
              body.style.backgroundColor = '#ffffff';
              body.style.color = '#000000';
            }
          });
        }
      });

      document.getElementById('course-has-prerequisite')?.addEventListener('change', (e) => {
        const container = document.getElementById('prerequisite-select-container');
        if (e.target.checked) {
          container.style.display = 'block';
        } else {
          container.style.display = 'none';
          document.getElementById('course-prerequisite').value = '';
        }
      });

      // Completion type radio buttons toggle
      document.querySelectorAll('input[name="completion-type"]').forEach(radio => {
        radio.addEventListener('change', (e) => {
          const certGroup = document.getElementById('certificate-template-group');
          const instrGroup = document.getElementById('completion-instructions-group');
          
          certGroup.style.display = 'none';
          instrGroup.style.display = 'none';
          
          if (e.target.value === 'certificate') {
            certGroup.style.display = 'block';
          } else if (e.target.value === 'instructions') {
            instrGroup.style.display = 'block';
          }
        });
      });

      // Course form submission
      document.getElementById('course-form')?.addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const courseId = document.getElementById('course-id').value;
        const saveBtn = document.getElementById('save-course-btn');
        const originalHtml = saveBtn.innerHTML;
        
        saveBtn.disabled = true;
        saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
        
        try {
          const completionType = document.querySelector('input[name="completion-type"]:checked').value;
          
          const formData = {
            name: document.getElementById('course-name').value,
            slug: document.getElementById('course-slug').value || null,
            short_description: document.getElementById('course-description').value,
            chunk_words: parseInt(document.getElementById('course-chunk-words').value) || 800,
            enable_study_time_limit: document.getElementById('enable-study-time').checked,
            min_study_minutes_per_day: document.getElementById('enable-study-time').checked 
              ? parseInt(document.getElementById('min-study-minutes').value) || null 
              : null,
            max_study_minutes_per_day: document.getElementById('enable-study-time').checked 
              ? parseInt(document.getElementById('max-study-minutes').value) || null 
              : null,
            enable_survey: document.getElementById('enable-survey').checked,
            survey_title: document.getElementById('enable-survey').checked 
              ? document.getElementById('survey-title').value || null 
              : null,
            survey_description: document.getElementById('enable-survey').checked 
              ? document.getElementById('survey-description').value || null 
              : null,
            is_active: document.getElementById('course-active').checked,
            has_prerequisite: document.getElementById('course-has-prerequisite').checked,
            prerequisite_course_id: document.getElementById('course-has-prerequisite').checked 
              ? document.getElementById('course-prerequisite').value || null 
              : null
          };
          
          // Add completion behavior fields based on selection
          if (completionType === 'certificate') {
            formData.certificate_template = document.getElementById('course-certificate').value;
            formData.completion_instructions = null;
          } else if (completionType === 'instructions') {
            formData.certificate_template = null;
            formData.completion_instructions = document.getElementById('course-instructions').value;
          } else {
            formData.certificate_template = null;
            formData.completion_instructions = null;
          }
          
          const method = courseId ? 'PUT' : 'POST';
          const url = courseId ? `/tutor/courses/${courseId}` : '/tutor/courses';
          
          const result = await apiCall(url, method, formData);
          
          showNotification(courseId ? 'Course updated successfully!' : 'Course created successfully!');
          closeCourseModal();
          setTimeout(() => location.reload(), 1000);
        } catch (error) {
          showNotification(error.message || 'Error saving course', 'error');
        } finally {
          saveBtn.disabled = false;
          saveBtn.innerHTML = originalHtml;
        }
      });
    });

    // Create Course (for backwards compatibility)
    async function createCourse(name, description = '', isActive = true) {
      try {
        const result = await apiCall('/tutor/courses', 'POST', {
          name: name,
          short_description: description,
          is_active: isActive
        });
        
        showNotification('Course created successfully!');
        console.log('Created course:', result);
        
        // Reload page to show new course
        setTimeout(() => location.reload(), 1000);
      } catch (error) {
        console.error('Failed to create course:', error);
        showNotification('Failed to create course', 'error');
      }
    }

    // Edit Course - now opens modal
    async function editCourse(courseId, currentName, currentDescription, currentActive) {
      openCourseModal(courseId);
    }

    // Delete Course - now uses modal
    async function deleteCourse(courseId, courseName) {
      showDeleteCourseModal(courseId, courseName);
    }

    // Load Students
    async function loadStudents() {
      try {
        const students = await apiCall('/tutor/students');
        console.log('Students loaded:', students);
        showNotification('Students data refreshed!');
      } catch (error) {
        console.error('Failed to load students:', error);
      }
    }

    // Show Student Details Modal
    async function showStudentDetails(type) {
      const modal = document.getElementById('student-details-modal');
      const title = document.getElementById('student-modal-title');
      const content = document.getElementById('student-list-content');
      
      // Set title based on type
      const titles = {
        'total': '👥 All Students',
        'active': '✅ Active Students (Last 7 Days)',
        'recent': '🆕 New Students This Week'
      };
      title.textContent = titles[type] || '👥 Student Details';
      
      // Show modal
      modal.style.display = 'flex';
      modal.classList.remove('hidden');
      
      // Show loading
      content.innerHTML = `
        <div style="text-align: center; padding: 40px;">
          <i class="fas fa-spinner fa-spin" style="font-size: 32px; color: #667eea;"></i>
          <p style="margin-top: 15px; color: #6b7280;">Loading student data...</p>
        </div>
      `;
      
      try {
        // Fetch student data
        const data = await apiCall('/tutor/students');
        const students = data.students || data;
        
        if (!students || students.length === 0) {
          content.innerHTML = `
            <div style="text-align: center; padding: 40px; color: #6b7280;">
              <i class="fas fa-users" style="font-size: 48px; opacity: 0.3;"></i>
              <p style="margin-top: 15px; font-size: 16px;">No students found</p>
            </div>
          `;
          return;
        }
        
        // Build student list table
        let html = `
          <table style="width: 100%; border-collapse: collapse;">
            <thead>
              <tr style="background: #f9fafb; border-bottom: 2px solid #e5e7eb;">
                <th style="padding: 12px; text-align: left; font-weight: 600; color: #374151;">Student</th>
                <th style="padding: 12px; text-align: center; font-weight: 600; color: #374151;">Enrolled Courses</th>
                <th style="padding: 12px; text-align: center; font-weight: 600; color: #374151;">Progress</th>
                <th style="padding: 12px; text-align: center; font-weight: 600; color: #374151;">Quiz Avg</th>
                <th style="padding: 12px; text-align: center; font-weight: 600; color: #374151;">Level</th>
                <th style="padding: 12px; text-align: left; font-weight: 600; color: #374151;">Last Activity</th>
              </tr>
            </thead>
            <tbody>
        `;
        
        students.forEach(student => {
          const progress = student.total_progress || 0;
          const progressColor = progress >= 75 ? '#10b981' : progress >= 50 ? '#f59e0b' : progress >= 25 ? '#3b82f6' : '#ef4444';
          const quizAvg = student.average_quiz_score || 0;
          const level = student.level || 1;
          const lastActivity = student.last_activity || 'Never';
          const enrolledCourses = student.enrolled_courses || student.courses_count || 0;
          
          html += `
            <tr style="border-bottom: 1px solid #e5e7eb; transition: background 0.2s;" onmouseover="this.style.background='#f9fafb'" onmouseout="this.style.background='white'">
              <td style="padding: 12px;">
                <div style="display: flex; align-items: center; gap: 10px;">
                  <div style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: 600; font-size: 16px;">
                    ${(student.name || 'U').charAt(0).toUpperCase()}
                  </div>
                  <div>
                    <div style="font-weight: 600; color: #374151;">${student.name || 'Unknown'}</div>
                    <div style="font-size: 12px; color: #6b7280;">${student.email || ''}</div>
                  </div>
                </div>
              </td>
              <td style="padding: 12px; text-align: center;">
                <span style="display: inline-block; padding: 4px 12px; background: #e0e7ff; color: #667eea; border-radius: 12px; font-weight: 600; font-size: 14px;">
                  ${enrolledCourses}
                </span>
              </td>
              <td style="padding: 12px; text-align: center;">
                <div style="display: flex; align-items: center; justify-content: center; gap: 8px;">
                  <div style="flex: 0 0 80px; height: 8px; background: #e5e7eb; border-radius: 4px; overflow: hidden;">
                    <div style="height: 100%; background: ${progressColor}; width: ${progress}%; transition: width 0.3s;"></div>
                  </div>
                  <span style="font-weight: 600; color: ${progressColor}; font-size: 14px;">${Math.round(progress)}%</span>
                </div>
              </td>
              <td style="padding: 12px; text-align: center;">
                <span style="font-weight: 600; color: ${quizAvg >= 80 ? '#10b981' : quizAvg >= 60 ? '#f59e0b' : '#ef4444'}; font-size: 14px;">
                  ${Math.round(quizAvg)}%
                </span>
              </td>
              <td style="padding: 12px; text-align: center;">
                <div style="display: inline-flex; align-items: center; gap: 5px; padding: 4px 10px; background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%); color: white; border-radius: 12px; font-weight: 600; font-size: 13px;">
                  <i class="fas fa-star"></i> ${level}
                </div>
              </td>
              <td style="padding: 12px; color: #6b7280; font-size: 13px;">
                <i class="fas fa-clock" style="margin-right: 5px;"></i>
                ${lastActivity}
              </td>
            </tr>
          `;
        });
        
        html += `
            </tbody>
          </table>
        `;
        
        content.innerHTML = html;
      } catch (error) {
        console.error('Failed to load student details:', error);
        content.innerHTML = `
          <div style="text-align: center; padding: 40px; color: #ef4444;">
            <i class="fas fa-exclamation-triangle" style="font-size: 48px; opacity: 0.5;"></i>
            <p style="margin-top: 15px; font-size: 16px;">Failed to load student data</p>
            <p style="margin-top: 8px; font-size: 14px; color: #6b7280;">${error.message || 'Unknown error'}</p>
            <button onclick="showStudentDetails('${type}')" style="margin-top: 15px; padding: 10px 20px; background: #667eea; color: white; border: none; border-radius: 8px; cursor: pointer;">
              <i class="fas fa-sync"></i> Retry
            </button>
          </div>
        `;
      }
    }

    function closeStudentModal() {
      const modal = document.getElementById('student-details-modal');
      modal.style.display = 'none';
      modal.classList.add('hidden');
    }

    // Add CSS animations
    const style = document.createElement('style');
    style.textContent = `
      @keyframes slideIn {
        from {
          transform: translateX(400px);
          opacity: 0;
        }
        to {
          transform: translateX(0);
          opacity: 1;
        }
      }
      @keyframes slideOut {
        from {
          transform: translateX(0);
          opacity: 1;
        }
        to {
          transform: translateX(400px);
          opacity: 0;
        }
      }
      .btn-danger {
        background: #ef4444;
      }
      .btn-danger:hover {
        background: #dc2626;
      }
    `;
    document.head.appendChild(style);

    // ============================================
    // TUTOR COURSE MANAGEMENT FUNCTIONS
    // ============================================

    let tutorCourses = [];
    let currentTutorCourseId = null;
    let deleteTutorCourseId = null;

    // Tab switching for course management
    document.querySelectorAll('.tutor-tab-btn').forEach(btn => {
      btn.addEventListener('click', function() {
        const tab = this.getAttribute('data-tab');
        
        // Update button states
        document.querySelectorAll('.tutor-tab-btn').forEach(b => {
          b.style.background = 'transparent';
          b.style.color = 'rgba(255,255,255,0.7)';
        });
        this.style.background = 'rgba(255,255,255,0.2)';
        this.style.color = 'white';
        
        // Update tab content
        document.querySelectorAll('.tutor-tab-content').forEach(content => {
          content.classList.add('hidden');
        });
        
        if (tab === 'courses-list') {
          document.getElementById('tutor-courses-list-tab').classList.remove('hidden');
        } else if (tab === 'lessons-topics') {
          document.getElementById('tutor-lessons-topics-tab').classList.remove('hidden');
        }
      });
    });

    // Load courses on page load
    async function loadTutorCourses() {
      try {
        const response = await fetch('/tutor/courses');
        const courses = await response.json();
        tutorCourses = courses;
        renderTutorCoursesTable(courses);
        populateTutorCourseFilter(courses);
      } catch (error) {
        console.error('Error loading courses:', error);
        document.getElementById('tutor-courses-table-body').innerHTML = `
          <tr>
            <td colspan="6" style="text-align: center; padding: 40px; color: #ef4444;">
              <i class="fas fa-exclamation-triangle" style="font-size: 24px;"></i>
              <p style="margin-top: 10px;">Error loading courses. Please refresh the page.</p>
            </td>
          </tr>
        `;
      }
    }

    function renderTutorCoursesTable(courses) {
      const tbody = document.getElementById('tutor-courses-table-body');
      
      if (!courses || courses.length === 0) {
        tbody.innerHTML = `
          <tr>
            <td colspan="6" style="text-align: center; padding: 40px; color: #999;">
              <i class="fas fa-book-open" style="font-size: 48px; margin-bottom: 15px; display: block; opacity: 0.5;"></i>
              <p>No courses yet. Click "Add New Course" to get started!</p>
            </td>
          </tr>
        `;
        return;
      }

      tbody.innerHTML = courses.map(course => `
        <tr style="border-bottom: 1px solid #e5e7eb;">
          <td style="padding: 15px;">
            <strong style="color: #374151; font-size: 14px;">${course.name || 'Untitled Course'}</strong>
            ${course.short_description ? `<br><small style="color: #6b7280;">${course.short_description}</small>` : ''}
          </td>
          <td style="padding: 15px;">
            <span style="padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600; ${course.is_active ? 'background: #d1fae5; color: #065f46;' : 'background: #e5e7eb; color: #6b7280;'}">
              ${course.is_active ? '✓ Active' : '○ Inactive'}
            </span>
          </td>
          <td style="padding: 15px; color: #6b7280;">${course.lessons ? course.lessons.length : 0}</td>
          <td style="padding: 15px; color: #6b7280;">-</td>
          <td style="padding: 15px; color: #6b7280;">-</td>
          <td style="padding: 15px;">
            ${course.enable_survey ? `
              <button onclick="manageTutorSurvey(${course.id}, '${(course.name || '').replace(/'/g, "\\'")}' )" class="icon-btn" title="Manage Survey" style="background: #10b981; color: white; padding: 6px 12px; font-size: 13px; margin-right: 5px;">
                <i class="fas fa-poll"></i>
              </button>
            ` : ''}
            <button onclick="editTutorCourse(${course.id})" class="btn btn-primary" style="padding: 6px 12px; font-size: 13px; margin-right: 5px;">
              <i class="fas fa-edit"></i> Edit
            </button>
            <button onclick="showTutorDeleteCourseModal(${course.id}, '${(course.name || '').replace(/'/g, "\\'")}' )" class="btn btn-danger" style="padding: 6px 12px; font-size: 13px;">
              <i class="fas fa-trash"></i>
            </button>
          </td>
        </tr>
      `).join('');
    }

    function populateTutorCourseFilter(courses) {
      const select = document.getElementById('tutor-content-course-filter');
      if (select) {
        select.innerHTML = '<option value="">Select Course to Manage</option>' +
          courses.map(c => `<option value="${c.id}">${c.name}</option>`).join('');
      }
    }

    // Add course button
    document.getElementById('tutor-add-course-btn')?.addEventListener('click', () => {
      openTutorCourseModal();
    });

    async function openTutorCourseModal(courseId = null) {
      currentTutorCourseId = courseId;
      const modal = document.getElementById('tutor-course-modal');
      const title = document.getElementById('tutor-course-modal-title');
      const saveText = document.getElementById('tutor-save-course-text');
      
      // Reset form
      document.getElementById('tutor-course-form').reset();
      document.getElementById('tutor-course-id').value = '';
      document.getElementById('tutor-course-chunk-words').value = '800';
      document.getElementById('tutor-course-active').checked = true;
      document.getElementById('tutor-prerequisite-select-container').classList.add('hidden');
      document.getElementById('tutor-course-has-prerequisite').checked = false;
      document.getElementById('tutor-certificate-template-group').classList.add('hidden');
      document.getElementById('tutor-completion-instructions-group').classList.add('hidden');
      document.getElementById('tutor-completion-none').checked = true;
      
      // Reset study time and survey fields
      document.getElementById('tutor-course-enable-study-time').checked = false;
      document.getElementById('tutor-study-time-fields').classList.add('hidden');
      document.getElementById('tutor-course-min-study-minutes').value = '15';
      document.getElementById('tutor-course-max-study-minutes').value = '60';
      document.getElementById('tutor-course-enable-survey').checked = false;
      document.getElementById('tutor-survey-fields').classList.add('hidden');
      document.getElementById('tutor-course-survey-title').value = '';
      document.getElementById('tutor-course-survey-description').value = '';

      // Load available prerequisites
      await loadTutorAvailablePrerequisites(courseId);

      if (courseId) {
        // Edit mode
        title.textContent = '✏️ Edit Course';
        saveText.textContent = 'Update Course';
        
        try {
          const response = await fetch(`/tutor/courses/${courseId}`);
          const data = await response.json();
          const course = data.course;
          
          document.getElementById('tutor-course-id').value = course.id;
          document.getElementById('tutor-course-name').value = course.name;
          document.getElementById('tutor-course-slug').value = course.slug || '';
          document.getElementById('tutor-course-description').value = course.short_description || '';
          document.getElementById('tutor-course-chunk-words').value = course.chunk_words || 800;
          
          // Study time limits
          document.getElementById('tutor-course-enable-study-time').checked = course.enable_study_time_limit || false;
          document.getElementById('tutor-course-min-study-minutes').value = course.min_study_minutes_per_day || 15;
          document.getElementById('tutor-course-max-study-minutes').value = course.max_study_minutes_per_day || 60;
          if (course.enable_study_time_limit) {
            document.getElementById('tutor-study-time-fields').classList.remove('hidden');
          }
          
          // Survey settings
          document.getElementById('tutor-course-enable-survey').checked = course.enable_survey || false;
          document.getElementById('tutor-course-survey-title').value = course.survey_title || '';
          document.getElementById('tutor-course-survey-description').value = course.survey_description || '';
          if (course.enable_survey) {
            document.getElementById('tutor-survey-fields').classList.remove('hidden');
          }
          
          document.getElementById('tutor-course-certificate').value = course.certificate_template || '';
          document.getElementById('tutor-course-instructions').value = course.completion_instructions || '';
          document.getElementById('tutor-course-active').checked = course.is_active;
          
          // Set completion type radio buttons
          if (course.certificate_template) {
            document.getElementById('tutor-completion-certificate').checked = true;
            document.getElementById('tutor-certificate-template-group').classList.remove('hidden');
          } else if (course.completion_instructions) {
            document.getElementById('tutor-completion-instructions-radio').checked = true;
            document.getElementById('tutor-completion-instructions-group').classList.remove('hidden');
          } else {
            document.getElementById('tutor-completion-none').checked = true;
          }
          
          if (course.has_prerequisite && course.prerequisite_course_id) {
            document.getElementById('tutor-course-has-prerequisite').checked = true;
            document.getElementById('tutor-prerequisite-select-container').classList.remove('hidden');
            document.getElementById('tutor-course-prerequisite').value = course.prerequisite_course_id;
          }
        } catch (error) {
          showNotification('Error loading course details', 'error');
          return;
        }
      } else {
        // Create mode
        title.textContent = '✨ Add New Course';
        saveText.textContent = 'Create Course';
      }

      modal.classList.remove('hidden');
    }

    async function loadTutorAvailablePrerequisites(excludeCourseId = null) {
      try {
        const url = excludeCourseId 
          ? `/tutor/available-prerequisites/${excludeCourseId}`
          : '/tutor/available-prerequisites';
        const response = await fetch(url);
        const data = await response.json();
        
        const select = document.getElementById('tutor-course-prerequisite');
        select.innerHTML = '<option value="">-- Select a prerequisite course --</option>';
        
        if (data.courses && data.courses.length > 0) {
          data.courses.forEach(course => {
            select.innerHTML += `<option value="${course.id}">${course.name}</option>`;
          });
        }
      } catch (error) {
        console.error('Error loading prerequisites:', error);
      }
    }

    function closeTutorCourseModal() {
      document.getElementById('tutor-course-modal').classList.add('hidden');
      currentTutorCourseId = null;
    }

    // Prerequisite checkbox toggle
    document.getElementById('tutor-course-has-prerequisite')?.addEventListener('change', (e) => {
      const container = document.getElementById('tutor-prerequisite-select-container');
      if (e.target.checked) {
        container.classList.remove('hidden');
      } else {
        container.classList.add('hidden');
        document.getElementById('tutor-course-prerequisite').value = '';
      }
    });

    // Study time limits toggle (first form)
    document.getElementById('tutor-course-enable-study-time')?.addEventListener('change', (e) => {
      const container = document.getElementById('tutor-study-time-fields');
      if (e.target.checked) {
        container.classList.remove('hidden');
      } else {
        container.classList.add('hidden');
      }
    });

    // Survey toggle (first form)
    document.getElementById('tutor-course-enable-survey')?.addEventListener('change', (e) => {
      const container = document.getElementById('tutor-survey-fields');
      if (e.target.checked) {
        container.classList.remove('hidden');
      } else {
        container.classList.add('hidden');
      }
    });

    // Study time limits toggle (second form)
    document.getElementById('enable-study-time')?.addEventListener('change', (e) => {
      const container = document.getElementById('study-time-fields');
      if (e.target.checked) {
        container.classList.remove('hidden');
      } else {
        container.classList.add('hidden');
      }
    });

    // Survey toggle (second form)
    document.getElementById('enable-survey')?.addEventListener('change', (e) => {
      const container = document.getElementById('survey-fields');
      if (e.target.checked) {
        container.classList.remove('hidden');
      } else {
        container.classList.add('hidden');
      }
    });

    // Completion type radio buttons toggle
    document.querySelectorAll('input[name="tutor-completion-type"]').forEach(radio => {
      radio.addEventListener('change', (e) => {
        const certificateGroup = document.getElementById('tutor-certificate-template-group');
        const instructionsGroup = document.getElementById('tutor-completion-instructions-group');
        
        // Hide both
        certificateGroup.classList.add('hidden');
        instructionsGroup.classList.add('hidden');
        
        // Show selected
        if (e.target.value === 'certificate') {
          certificateGroup.classList.remove('hidden');
        } else if (e.target.value === 'instructions') {
          instructionsGroup.classList.remove('hidden');
        }
      });
    });

    // Course form submission
    document.getElementById('tutor-course-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      
      const courseId = document.getElementById('tutor-course-id').value;
      const hasPrerequisite = document.getElementById('tutor-course-has-prerequisite').checked;
      const prerequisiteId = document.getElementById('tutor-course-prerequisite').value;

      // Validation
      if (hasPrerequisite && !prerequisiteId) {
        showNotification('Please select a prerequisite course', 'error');
        return;
      }

      // Get completion type
      const completionType = document.querySelector('input[name="tutor-completion-type"]:checked').value;
      
      const courseData = {
        name: document.getElementById('tutor-course-name').value,
        slug: document.getElementById('tutor-course-slug').value || null,
        short_description: document.getElementById('tutor-course-description').value,
        chunk_words: parseInt(document.getElementById('tutor-course-chunk-words').value) || 800,
        enable_study_time_limit: document.getElementById('tutor-course-enable-study-time').checked,
        min_study_minutes_per_day: document.getElementById('tutor-course-enable-study-time').checked 
          ? parseInt(document.getElementById('tutor-course-min-study-minutes').value) || null 
          : null,
        max_study_minutes_per_day: document.getElementById('tutor-course-enable-study-time').checked 
          ? parseInt(document.getElementById('tutor-course-max-study-minutes').value) || null 
          : null,
        enable_survey: document.getElementById('tutor-course-enable-survey').checked,
        survey_title: document.getElementById('tutor-course-enable-survey').checked 
          ? document.getElementById('tutor-course-survey-title').value || null 
          : null,
        survey_description: document.getElementById('tutor-course-enable-survey').checked 
          ? document.getElementById('tutor-course-survey-description').value || null 
          : null,
        certificate_template: completionType === 'certificate' ? document.getElementById('tutor-course-certificate').value : null,
        completion_instructions: completionType === 'instructions' ? document.getElementById('tutor-course-instructions').value : null,
        has_prerequisite: hasPrerequisite,
        prerequisite_course_id: hasPrerequisite ? prerequisiteId : null,
        is_active: document.getElementById('tutor-course-active').checked
      };

      const saveBtn = document.getElementById('tutor-save-course-btn');
      saveBtn.disabled = true;
      saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';

      try {
        const url = courseId ? `/tutor/courses/${courseId}` : '/tutor/courses';
        const method = courseId ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
          method: method,
          headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          },
          body: JSON.stringify(courseData)
        });

        const result = await response.json();
        
        if (result.success) {
          showNotification(courseId ? 'Course updated successfully!' : 'Course created successfully!', 'success');
          closeTutorCourseModal();
          loadTutorCourses();
        } else {
          showNotification(result.message || 'Error saving course', 'error');
        }
      } catch (error) {
        showNotification(error.message || 'Error saving course', 'error');
      } finally {
        saveBtn.disabled = false;
        saveBtn.innerHTML = `<i class="fas fa-save"></i> <span id="tutor-save-course-text">${courseId ? 'Update' : 'Create'} Course</span>`;
      }
    });

    function editTutorCourse(courseId) {
      openTutorCourseModal(courseId);
    }

    function showTutorDeleteCourseModal(courseId, courseName) {
      deleteTutorCourseId = courseId;
      document.getElementById('tutor-delete-course-name').textContent = courseName;
      document.getElementById('tutor-delete-course-id').textContent = courseId;
      document.getElementById('tutor-delete-course-modal').classList.remove('hidden');
    }

    function closeTutorDeleteCourseModal() {
      document.getElementById('tutor-delete-course-modal').classList.add('hidden');
      deleteTutorCourseId = null;
    }

    async function confirmTutorDeleteCourse() {
      if (!deleteTutorCourseId) return;

      try {
        const response = await fetch(`/tutor/courses/${deleteTutorCourseId}`, {
          method: 'DELETE',
          headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });
        
        const result = await response.json();
        
        if (result.success) {
          showNotification('Course deleted successfully!', 'success');
          closeTutorDeleteCourseModal();
          loadTutorCourses();
        } else {
          showNotification('Error deleting course', 'error');
        }
      } catch (error) {
        showNotification('Error deleting course', 'error');
      }
    }

    // Survey Management for Tutor
    let currentTutorSurveyCourseId = null;
    let tutorSurveyQuestions = [];
    let tutorQuestionIdCounter = 0;

    async function manageTutorSurvey(courseId, courseName) {
      currentTutorSurveyCourseId = courseId;
      document.getElementById('tutor-survey-modal-title').textContent = `📋 Manage Survey: ${courseName}`;
      document.getElementById('tutor-survey-modal').classList.remove('hidden');
      
      // Load existing questions
      try {
        const response = await fetch(`/api/courses/${courseId}/survey`, {
          headers: {
            'Authorization': `Bearer ${localStorage.getItem('token')}`,
            'Accept': 'application/json'
          }
        });
        const data = await response.json();
        tutorSurveyQuestions = data.questions || [];
        renderTutorSurveyQuestions();
      } catch (error) {
        tutorSurveyQuestions = [];
        renderTutorSurveyQuestions();
      }
    }

    function closeTutorSurveyModal() {
      document.getElementById('tutor-survey-modal').classList.add('hidden');
      currentTutorSurveyCourseId = null;
      tutorSurveyQuestions = [];
    }

    function addTutorSurveyQuestion() {
      const newQuestion = {
        id: `new_${tutorQuestionIdCounter++}`,
        question: '',
        question_type: 'rating',
        is_required: false,
        options: [],
        order_index: tutorSurveyQuestions.length
      };
      tutorSurveyQuestions.push(newQuestion);
      renderTutorSurveyQuestions();
    }

    function removeTutorSurveyQuestion(index) {
      if (confirm('Remove this question?')) {
        tutorSurveyQuestions.splice(index, 1);
        renderTutorSurveyQuestions();
      }
    }

    function moveTutorQuestion(index, direction) {
      const newIndex = index + direction;
      if (newIndex < 0 || newIndex >= tutorSurveyQuestions.length) return;
      
      [tutorSurveyQuestions[index], tutorSurveyQuestions[newIndex]] = [tutorSurveyQuestions[newIndex], tutorSurveyQuestions[index]];
      renderTutorSurveyQuestions();
    }

    function renderTutorSurveyQuestions() {
      const container = document.getElementById('tutor-survey-questions-list');
      
      if (tutorSurveyQuestions.length === 0) {
        container.innerHTML = `
          <div style="text-align: center; padding: 40px; color: #9ca3af;">
            <i class="fas fa-clipboard-question" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i>
            <p>No questions yet. Click "Add Question" to get started.</p>
          </div>
        `;
        return;
      }

      container.innerHTML = tutorSurveyQuestions.map((q, index) => `
        <div class="survey-question-item" style="background: #f9fafb; border: 1px solid #e5e7eb; border-radius: 8px; padding: 20px; margin-bottom: 15px;">
          <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 15px;">
            <div style="flex: 1;">
              <label style="display: block; font-weight: 600; margin-bottom: 8px; color: #374151;">
                Question ${index + 1}
              </label>
              <input type="text" 
                     value="${q.question}" 
                     onchange="tutorSurveyQuestions[${index}].question = this.value"
                     placeholder="Enter your question"
                     class="form-control" 
                     style="margin-bottom: 10px;">
            </div>
            <div style="display: flex; gap: 5px; margin-left: 10px;">
              <button type="button" onclick="moveTutorQuestion(${index}, -1)" ${index === 0 ? 'disabled' : ''} class="icon-btn" title="Move Up">
                <i class="fas fa-arrow-up"></i>
              </button>
              <button type="button" onclick="moveTutorQuestion(${index}, 1)" ${index === tutorSurveyQuestions.length - 1 ? 'disabled' : ''} class="icon-btn" title="Move Down">
                <i class="fas fa-arrow-down"></i>
              </button>
              <button type="button" onclick="removeTutorSurveyQuestion(${index})" class="icon-btn icon-btn-danger" title="Remove">
                <i class="fas fa-trash"></i>
              </button>
            </div>
          </div>

          <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
            <div class="form-group">
              <label style="display: block; font-weight: 600; margin-bottom: 8px; color: #374151;">Question Type</label>
              <select onchange="tutorSurveyQuestions[${index}].question_type = this.value; renderTutorSurveyQuestions();" 
                      class="form-control">
                <option value="rating" ${q.question_type === 'rating' ? 'selected' : ''}>⭐ Rating (1-5)</option>
                <option value="text" ${q.question_type === 'text' ? 'selected' : ''}>📝 Text Response</option>
                <option value="multiple_choice" ${q.question_type === 'multiple_choice' ? 'selected' : ''}>☑️ Multiple Choice</option>
              </select>
            </div>

            <div class="form-group">
              <label style="display: flex; align-items: center; cursor: pointer; padding-top: 28px;">
                <input type="checkbox" 
                       ${q.is_required ? 'checked' : ''} 
                       onchange="tutorSurveyQuestions[${index}].is_required = this.checked"
                       style="margin-right: 8px;">
                <span style="font-weight: 600; color: #374151;">Required Question</span>
              </label>
            </div>
          </div>

          ${q.question_type === 'multiple_choice' ? `
            <div class="form-group" style="margin-top: 15px;">
              <label style="display: block; font-weight: 600; margin-bottom: 8px; color: #374151;">Options (one per line)</label>
              <textarea 
                onchange="tutorSurveyQuestions[${index}].options = this.value.split('\\n').filter(o => o.trim())"
                rows="3" 
                class="form-control" 
                placeholder="Option 1&#10;Option 2&#10;Option 3">${Array.isArray(q.options) ? q.options.join('\\n') : ''}</textarea>
            </div>
          ` : ''}

          <div style="margin-top: 10px; padding: 10px; background: white; border-radius: 4px; border: 1px dashed #d1d5db;">
            <small style="color: #6b7280; font-weight: 600;">Preview:</small>
            <div style="margin-top: 8px; color: #374151;">
              ${q.question || '<em style="color: #9ca3af;">Question preview will appear here...</em>'}
              ${q.is_required ? '<span style="color: #ef4444;">*</span>' : ''}
            </div>
          </div>
        </div>
      `).join('');
    }

    async function saveTutorSurveyQuestions() {
      if (!currentTutorSurveyCourseId) return;

      // Validate
      const invalidQuestions = tutorSurveyQuestions.filter(q => !q.question.trim());
      if (invalidQuestions.length > 0) {
        showNotification('Please fill in all questions', 'error');
        return;
      }

      const multipleChoiceWithoutOptions = tutorSurveyQuestions.filter(q => 
        q.question_type === 'multiple_choice' && (!q.options || q.options.length === 0)
      );
      if (multipleChoiceWithoutOptions.length > 0) {
        showNotification('Multiple choice questions must have at least one option', 'error');
        return;
      }

      try {
        const response = await fetch(`/api/courses/${currentTutorSurveyCourseId}/survey/questions`, {
          method: 'POST',
          headers: {
            'Authorization': `Bearer ${localStorage.getItem('token')}`,
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          },
          body: JSON.stringify({
            questions: tutorSurveyQuestions.map((q, index) => ({
              question: q.question,
              question_type: q.question_type,
              is_required: q.is_required,
              options: q.question_type === 'multiple_choice' ? q.options : null,
              order_index: index
            }))
          })
        });

        const result = await response.json();

        if (response.ok) {
          showNotification('Survey questions saved successfully!', 'success');
          closeTutorSurveyModal();
        } else {
          showNotification(result.message || 'Error saving survey questions', 'error');
        }
      } catch (error) {
        showNotification('Error saving survey questions', 'error');
      }
    }

    // Course filter change
    document.getElementById('tutor-content-course-filter')?.addEventListener('change', async function() {
      const courseId = this.value;
      const addLessonBtn = document.getElementById('tutor-add-lesson-btn');
      
      if (!courseId) {
        addLessonBtn.disabled = true;
        addLessonBtn.style.background = 'rgba(255,255,255,0.2)';
        addLessonBtn.style.cursor = 'not-allowed';
        addLessonBtn.style.border = '2px solid rgba(255,255,255,0.3)';
        document.getElementById('tutor-content-tree').innerHTML = `
          <div style="text-align: center; padding: 60px 20px; color: #9ca3af;">
            <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); width: 100px; height: 100px; border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);">
              <i class="fas fa-book-open" style="font-size: 42px; color: white;"></i>
            </div>
            <h4 style="color: #4b5563; margin: 0 0 10px 0; font-size: 18px;">No Course Selected</h4>
            <p style="margin: 0; font-size: 14px; color: #9ca3af;">Select a course from the dropdown above to view and manage its lessons and topics</p>
          </div>
        `;
        return;
      }

      addLessonBtn.disabled = false;
      addLessonBtn.style.background = 'white';
      addLessonBtn.style.color = '#667eea';
      addLessonBtn.style.cursor = 'pointer';
      addLessonBtn.style.border = '2px solid white';

      try {
        const response = await fetch(`/tutor/courses/${courseId}/lessons`);
        const lessons = await response.json();
        renderTutorContentTree(courseId, lessons);
      } catch (error) {
        console.error('Error loading lessons:', error);
        document.getElementById('tutor-content-tree').innerHTML = `
          <div style="text-align: center; padding: 40px 20px;">
            <i class="fas fa-exclamation-triangle" style="font-size: 36px; color: #ef4444;"></i>
            <p style="margin-top: 15px; color: #ef4444; font-size: 14px; font-weight: 600;">Error loading content</p>
            <p style="margin-top: 5px; color: #6b7280; font-size: 13px;">Please try refreshing the page</p>
          </div>
        `;
      }
    });

    function renderTutorContentTree(courseId, lessons) {
      const tree = document.getElementById('tutor-content-tree');
      
      if (!lessons || lessons.length === 0) {
        tree.innerHTML = `
          <div style="text-align: center; padding: 60px 20px;">
            <div style="background: #f3f4f6; width: 80px; height: 80px; border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center;">
              <i class="fas fa-folder-plus" style="font-size: 32px; color: #9ca3af;"></i>
            </div>
            <h4 style="color: #4b5563; margin: 0 0 8px 0; font-size: 16px;">No Lessons Yet</h4>
            <p style="margin: 0 0 20px 0; font-size: 14px; color: #9ca3af;">Click "Add Lesson" to create your first lesson</p>
          </div>
        `;
        return;
      }

      tree.innerHTML = `<div id="tutor-lessons-sortable" style="display: flex; flex-direction: column; gap: 15px;">${lessons.map((lesson, index) => `
        <div class="course-node" data-lesson-id="${lesson.id}" style="background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%); border: 2px solid #e5e7eb; border-radius: 12px; padding: 20px; transition: all 0.3s; box-shadow: 0 1px 3px rgba(0,0,0,0.05);">
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
            <div style="display: flex; align-items: center; flex: 1; gap: 12px;">
              <i class="fas fa-grip-vertical" style="color: #d1d5db; cursor: move; font-size: 18px;"></i>
              <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); width: 40px; height: 40px; border-radius: 10px; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 16px; box-shadow: 0 2px 8px rgba(102, 126, 234, 0.3);">
                ${index + 1}
              </div>
              <div>
                <h4 style="margin: 0; color: #1f2937; font-size: 16px; font-weight: 600;">${lesson.name}</h4>
                <p style="margin: 5px 0 0 0; color: #6b7280; font-size: 13px;">
                  ${lesson.topics ? lesson.topics.length : 0} topic${lesson.topics && lesson.topics.length !== 1 ? 's' : ''}
                  ${lesson.has_quiz ? ' • <i class="fas fa-question-circle" style="color: #8b5cf6;"></i> Has Quiz' : ''}
                </p>
              </div>
            </div>
            <div style="display: flex; gap: 6px;">
              <button style="background: #10b981; color: white; border: none; padding: 8px 14px; border-radius: 6px; cursor: pointer; font-size: 12px; font-weight: 600; transition: all 0.2s;" onclick="openTutorTopicModal(${lesson.id})" title="Add topic">
                <i class="fas fa-plus"></i> Topic
              </button>
              ${lesson.has_quiz ? `<button style="background: #8b5cf6; color: white; border: none; padding: 8px 14px; border-radius: 6px; cursor: pointer; font-size: 12px; font-weight: 600; transition: all 0.2s;" onclick="manageTutorQuiz(${lesson.id})" title="Manage quiz">
                <i class="fas fa-question-circle"></i> Quiz
              </button>` : ''}
              <button style="background: #3b82f6; color: white; border: none; padding: 8px 12px; border-radius: 6px; cursor: pointer; font-size: 12px; transition: all 0.2s;" onclick="editTutorLesson(${lesson.id})" title="Edit lesson">
                <i class="fas fa-edit"></i>
              </button>
              <button style="background: #ef4444; color: white; border: none; padding: 8px 12px; border-radius: 6px; cursor: pointer; font-size: 12px; transition: all 0.2s;" onclick="deleteTutorLesson(${lesson.id})" title="Delete lesson">
                <i class="fas fa-trash"></i>
              </button>
            </div>
          </div>
          <div class="topics-sortable topics-container" data-lesson-id="${lesson.id}" style="margin-left: 52px; display: flex; flex-direction: column; gap: 8px;">
            ${(lesson.topics && lesson.topics.length > 0) ? lesson.topics.map((topic, topicIndex) => `
              <div class="topic-node" data-topic-id="${topic.id}" style="background: white; border: 1px solid #e5e7eb; border-radius: 8px; padding: 12px 15px; transition: all 0.2s;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                  <div style="display: flex; align-items: center; flex: 1; gap: 10px;">
                    <i class="fas fa-grip-vertical" style="color: #d1d5db; cursor: move; font-size: 14px;"></i>
                    <div style="background: #dbeafe; width: 28px; height: 28px; border-radius: 6px; display: flex; align-items: center; justify-content: center; color: #1e40af; font-weight: 600; font-size: 12px;">
                      ${topicIndex + 1}
                    </div>
                    <i class="fas fa-book-open" style="color: #3b82f6; font-size: 14px;"></i>
                    <span style="color: #374151; font-size: 14px; font-weight: 500;">${topic.title}</span>
                    ${topic.is_published === false ? '<span style="background: #fef3c7; color: #92400e; padding: 2px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; margin-left: 8px;">DRAFT</span>' : ''}
                  </div>
                  <div style="display: flex; gap: 4px;">
                    <button style="background: #3b82f6; color: white; border: none; padding: 6px 10px; border-radius: 5px; cursor: pointer; font-size: 11px; transition: all 0.2s;" onclick="editTutorTopic(${topic.id})" title="Edit">
                      <i class="fas fa-edit"></i>
                    </button>
                    <button style="background: #ef4444; color: white; border: none; padding: 6px 10px; border-radius: 5px; cursor: pointer; font-size: 11px; transition: all 0.2s;" onclick="deleteTutorTopic(${topic.id})" title="Delete">
                      <i class="fas fa-trash"></i>
                    </button>
                  </div>
                </div>
              </div>
            `).join('') : ''}
            ${(!lesson.topics || lesson.topics.length === 0) ? '<p style="color: #9ca3af; font-size: 13px; font-style: italic; margin: 10px 0;">No topics yet - click "Add Topic" to get started</p>' : ''}
          </div>
        </div>
      `).join('')}</div>`;

      // Initialize drag-and-drop for lessons
      initializeTutorLessonsDragDrop(courseId);
      
      // Initialize drag-and-drop for topics
      document.querySelectorAll('.topics-sortable').forEach(container => {
        const lessonId = container.getAttribute('data-lesson-id');
        initializeTutorTopicsDragDrop(container, lessonId);
      });
    }

    // Initialize drag-and-drop for tutor lessons
    function initializeTutorLessonsDragDrop(courseId) {
      const container = document.getElementById('tutor-lessons-sortable');
      if (!container) return;

      new Sortable(container, {
        animation: 150,
        handle: '.fa-grip-vertical',
        ghostClass: 'sortable-ghost',
        dragClass: 'sortable-drag',
        onEnd: async function(evt) {
          const lessonIds = Array.from(container.children).map(el => el.getAttribute('data-lesson-id'));
          
          try {
            await fetch('/tutor/lessons/reorder', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
              },
              body: JSON.stringify({ lesson_ids: lessonIds })
            });
            showNotification('Lessons reordered successfully!', 'success');
          } catch (error) {
            showNotification('Failed to reorder lessons', 'error');
            // Reload to restore order
            document.getElementById('tutor-content-course-filter').dispatchEvent(new Event('change'));
          }
        }
      });
    }

    // Initialize drag-and-drop for tutor topics
    function initializeTutorTopicsDragDrop(container, lessonId) {
      if (!container || container.children.length === 0) return;
      
      const hasTopics = Array.from(container.children).some(el => el.classList.contains('topic-node'));
      if (!hasTopics) return;

      new Sortable(container, {
        animation: 150,
        handle: '.fa-grip-vertical',
        ghostClass: 'sortable-ghost',
        dragClass: 'sortable-drag',
        onEnd: async function(evt) {
          const topicIds = Array.from(container.children)
            .filter(el => el.classList.contains('topic-node'))
            .map(el => el.getAttribute('data-topic-id'));
          
          try {
            await fetch('/tutor/topics/reorder', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
              },
              body: JSON.stringify({ topic_ids: topicIds })
            });
            showNotification('Topics reordered successfully!', 'success');
          } catch (error) {
            showNotification('Failed to reorder topics', 'error');
            // Reload to restore order
            document.getElementById('tutor-content-course-filter').dispatchEvent(new Event('change'));
          }
        }
      });
    }

    // Lesson functions
    function editTutorLesson(id) {
      openTutorLessonModal(id);
    }

    async function openTutorLessonModal(lessonId = null) {
      const modal = document.getElementById('tutor-lessonModal');
      const title = document.getElementById('tutor-lesson-modal-title');
      const courseId = document.getElementById('tutor-content-course-filter').value;
      
      // Reset form
      document.getElementById('tutor-lesson-form').reset();
      document.getElementById('tutor-lesson-id').value = '';
      document.getElementById('tutor-lesson-course-id').value = courseId;
      
      if (lessonId) {
        title.textContent = '✏️ Edit Lesson';
        try {
          const response = await fetch(`/tutor/lessons/${lessonId}`);
          const data = await response.json();
          const lesson = data.lesson;
          
          document.getElementById('tutor-lesson-id').value = lesson.id;
          document.getElementById('tutor-lesson-course-id').value = lesson.course_id;
          document.getElementById('tutor-lesson-name').value = lesson.name;
          document.getElementById('tutor-lesson-description').value = lesson.intro || '';
        } catch (error) {
          showNotification('Error loading lesson', 'error');
          return;
        }
      } else {
        title.textContent = 'Add New Lesson';
      }
      
      modal.classList.remove('hidden');
    }

    document.getElementById('tutor-lesson-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      
      const lessonId = document.getElementById('tutor-lesson-id').value;
      const lessonData = {
        course_id: document.getElementById('tutor-lesson-course-id').value,
        name: document.getElementById('tutor-lesson-name').value,
        intro: document.getElementById('tutor-lesson-description').value
      };

      try {
        const url = lessonId ? `/tutor/lessons/${lessonId}` : '/tutor/lessons';
        const method = lessonId ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
          method: method,
          headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          },
          body: JSON.stringify(lessonData)
        });

        const result = await response.json();
        
        if (result.success) {
          showNotification(lessonId ? 'Lesson updated!' : 'Lesson created!', 'success');
          closeTutorModal('tutor-lessonModal');
          // Refresh content tree
          const courseId = document.getElementById('tutor-content-course-filter').value;
          if (courseId) {
            const resp = await fetch(`/tutor/courses/${courseId}/lessons`);
            const lessons = await resp.json();
            renderTutorContentTree(courseId, lessons);
          }
        } else {
          showNotification('Error saving lesson', 'error');
        }
      } catch (error) {
        showNotification('Error saving lesson', 'error');
      }
    });

    async function deleteTutorLesson(id) {
      if (!confirm('Delete this lesson and all its topics?')) return;
      
      try {
        const response = await fetch(`/tutor/lessons/${id}`, {
          method: 'DELETE',
          headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });
        
        const result = await response.json();
        
        if (result.success) {
          showNotification('Lesson deleted!', 'success');
          // Refresh content tree
          const courseId = document.getElementById('tutor-content-course-filter').value;
          if (courseId) {
            const resp = await fetch(`/tutor/courses/${courseId}/lessons`);
            const lessons = await resp.json();
            renderTutorContentTree(courseId, lessons);
          }
        }
      } catch (error) {
        showNotification('Error deleting lesson', 'error');
      }
    }

    // Topic functions
    function editTutorTopic(id) {
      openTutorTopicModal(null, id);
    }

    async function openTutorTopicModal(lessonId = null, topicId = null) {
      const modal = document.getElementById('tutor-topicModal');
      const title = document.getElementById('tutor-topic-modal-title');
      
      // Reset form
      document.getElementById('tutor-topic-form').reset();
      document.getElementById('tutor-topic-id').value = '';
      document.getElementById('tutor-topic-lesson-id').value = lessonId || '';
      document.getElementById('tutor-topic-is-published').checked = true;
      
      if (topicId) {
        title.textContent = '✏️ Edit Topic';
        try {
          const response = await fetch(`/tutor/topics/${topicId}`);
          const data = await response.json();
          const topic = data.topic;
          
          document.getElementById('tutor-topic-id').value = topic.id;
          document.getElementById('tutor-topic-lesson-id').value = topic.lesson_id;
          document.getElementById('tutor-topic-title').value = topic.title;
          
          // Set content in TinyMCE if available
          const editor = tinymce.get('topic-body');
          if (editor) {
            editor.setContent(topic.body || '');
            editor.mode.set('design');
            setTimeout(() => {
              editor.selection.collapse(false);
              editor.focus();
            }, 100);
          } else {
            document.getElementById('tutor-topic-body').value = topic.body || '';
          }
          
          document.getElementById('tutor-topic-video-url').value = topic.video_url || '';
          document.getElementById('tutor-topic-image-url').value = topic.image_url || '';
          document.getElementById('tutor-topic-is-published').checked = topic.is_published;
        } catch (error) {
          showNotification('Error loading topic', 'error');
          return;
        }
      } else {
        title.textContent = 'Add New Topic';
        // Clear TinyMCE content for new topic
        const editor = tinymce.get('topic-body');
        if (editor) {
          editor.setContent('');
        }
      }
      
      modal.classList.remove('hidden');
    }

    document.getElementById('tutor-topic-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      
      const topicId = document.getElementById('tutor-topic-id').value;
      
      // Get body content from TinyMCE if available
      let bodyContent = document.getElementById('tutor-topic-body').value;
      const editor = tinymce.get('topic-body');
      if (editor) {
        bodyContent = editor.getContent();
      }
      
      const topicData = {
        lesson_id: document.getElementById('tutor-topic-lesson-id').value,
        title: document.getElementById('tutor-topic-title').value,
        body: bodyContent,
        video_url: document.getElementById('tutor-topic-video-url').value,
        image_url: document.getElementById('tutor-topic-image-url').value,
        is_published: document.getElementById('tutor-topic-is-published').checked
      };

      try {
        const url = topicId ? `/tutor/topics/${topicId}` : '/tutor/topics';
        const method = topicId ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
          method: method,
          headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          },
          body: JSON.stringify(topicData)
        });

        const result = await response.json();
        
        if (result.success) {
          showNotification(topicId ? 'Topic updated!' : 'Topic created!', 'success');
          closeTutorModal('tutor-topicModal');
          // Refresh content tree
          const courseId = document.getElementById('tutor-content-course-filter').value;
          if (courseId) {
            const resp = await fetch(`/tutor/courses/${courseId}/lessons`);
            const lessons = await resp.json();
            renderTutorContentTree(courseId, lessons);
          }
        } else {
          showNotification('Error saving topic', 'error');
        }
      } catch (error) {
        showNotification('Error saving topic', 'error');
      }
    });

    async function deleteTutorTopic(id) {
      if (!confirm('Delete this topic?')) return;
      
      try {
        const response = await fetch(`/tutor/topics/${id}`, {
          method: 'DELETE',
          headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });
        
        const result = await response.json();
        
        if (result.success) {
          showNotification('Topic deleted!', 'success');
          // Refresh content tree
          const courseId = document.getElementById('tutor-content-course-filter').value;
          if (courseId) {
            const resp = await fetch(`/tutor/courses/${courseId}/lessons`);
            const lessons = await resp.json();
            renderTutorContentTree(courseId, lessons);
          }
        }
      } catch (error) {
        showNotification('Error deleting topic', 'error');
      }
    }

    // Add lesson button
    document.getElementById('tutor-add-lesson-btn')?.addEventListener('click', function() {
      const courseId = document.getElementById('tutor-content-course-filter').value;
      if (courseId) {
        openTutorLessonModal();
      }
    });

    // Modal close function
    function closeTutorModal(modalId) {
      document.getElementById(modalId).classList.add('hidden');
    }

    // Search courses
    document.getElementById('tutor-course-search')?.addEventListener('input', function(e) {
      const query = e.target.value.toLowerCase();
      const filtered = tutorCourses.filter(c => 
        (c.name || '').toLowerCase().includes(query) || 
        (c.short_description || '').toLowerCase().includes(query)
      );
      renderTutorCoursesTable(filtered);
    });

    // Load courses when courses section becomes active
    const coursesSection = document.getElementById('courses');
    if (coursesSection) {
      const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
          if (mutation.target.classList.contains('active') && tutorCourses.length === 0) {
            loadTutorCourses();
          }
        });
      });
      observer.observe(coursesSection, { attributes: true, attributeFilter: ['class'] });
    }

    // Load courses immediately if courses section is already active
    if (coursesSection?.classList.contains('active')) {
      loadTutorCourses();
    }

  </script>
</body>
</html>
