@extends('layouts.public')

@section('title', 'About EntrepreneurEducation')
@section('meta_description', 'Discover our mission to make entrepreneur education Simple, Easy, Enjoyable & Accessible (S.E.A). Learn about our vision, culture and innovative approach.')

@push('styles')
<style>
    :root {
        --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        --accent-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        --dark-bg: #0f172a;
        --light-bg: #f8fafc;
        --card-bg: #ecf3fe;
        --text-dark: #1e293b;
        --text-light: #64748b;
    }
    
    .page-hero {
        background: var(--dark-bg);
        color: white;
        padding: 100px 0 80px;
        text-align: center;
        position: relative;
        overflow: hidden;
    }
    
    .page-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 20% 80%, rgba(103, 58, 183, 0.1) 0%, transparent 50%),
            radial-gradient(circle at 80% 20%, rgba(33, 150, 243, 0.1) 0%, transparent 50%);
    }
    
    .page-hero h1 {
        font-size: 3.5rem;
        font-weight: 900;
        margin-bottom: 1.5rem;
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        position: relative;
    }
    
    .page-hero .tagline {
        font-size: 1.25rem;
        opacity: 0.9;
        max-width: 600px;
        margin: 0 auto 2rem;
        color: #cbd5e1;
    }
    
    .mission-badge {
        display: inline-block;
        background: var(--secondary-gradient);
        padding: 0.75rem 1.5rem;
        border-radius: 50px;
        font-weight: 700;
        font-size: 1.125rem;
        margin-top: 1rem;
        animation: float 3s ease-in-out infinite;
    }
    
    @keyframes float {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-10px); }
    }
    
    .about-section {
        padding: 80px 0;
        background: var(--light-bg);
    }
    
    .about-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 4rem;
        align-items: start;
        margin-bottom: 5rem;
    }
    
    .about-card {
        background: var(--card-bg);
        backdrop-filter: blur(10px);
        border-radius: 24px;
        padding: 2.5rem;
        border: 1px solid rgba(255, 255, 255, 0.2);
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .about-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 48px rgba(0, 0, 0, 0.15);
    }
    
    .card-icon {
        width: 60px;
        height: 60px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 28px;
        margin-bottom: 1.5rem;
        background: var(--accent-gradient);
        color: white;
    }
    
    .card-title {
        font-size: 1.75rem;
        font-weight: 800;
        margin-bottom: 1rem;
        color: var(--text-dark);
    }
    
    .card-text {
        color: var(--text-light);
        line-height: 1.7;
        margin-bottom: 1.5rem;
    }
    
    .accent-line {
        height: 4px;
        width: 60px;
        background: var(--primary-gradient);
        border-radius: 2px;
        margin-bottom: 1.5rem;
    }
    
    .values-section {
        padding: 80px 0;
        background: var(--dark-bg);
        color: white;
        text-align: center;
    }
    
    .section-title {
        font-size: 2.5rem;
        font-weight: 900;
        margin-bottom: 1rem;
        color: white;
    }
    
    .section-subtitle {
        color: #94a3b8;
        font-size: 1.125rem;
        max-width: 600px;
        margin: 0 auto 4rem;
    }
    
    .values-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 2rem;
        margin-top: 3rem;
    }
    
    .value-item {
        background: rgba(255, 255, 255, 0.05);
        border-radius: 20px;
        padding: 2rem;
        border: 1px solid rgba(255, 255, 255, 0.1);
        transition: all 0.3s ease;
    }
    
    .value-item:hover {
        background: rgba(255, 255, 255, 0.1);
        transform: translateY(-5px);
    }
    
    .value-letter {
        font-size: 2.5rem;
        font-weight: 900;
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 1rem;
        display: block;
    }
    
    .value-name {
        font-size: 1.25rem;
        font-weight: 700;
        margin-bottom: 0.75rem;
        color: white;
    }
    
    .value-desc {
        color: #cbd5e1;
        font-size: 0.9375rem;
        line-height: 1.6;
    }
    
    .stats-section {
        padding: 60px 0;
        background: white;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 2rem;
        text-align: center;
    }
    
    .stat-number {
        font-size: 3rem;
        font-weight: 900;
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 0.5rem;
    }
    
    .stat-label {
        color: var(--text-light);
        font-weight: 600;
        font-size: 1rem;
    }
    
    /* Culture Items Styling */
    .culture-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 1.5rem;
        margin-top: 2rem;
    }
    
    .culture-item {
        background: rgba(255, 255, 255, 0.9);
        padding: 1.5rem;
        border-radius: 12px;
        border-left: 4px solid #667eea;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        transition: transform 0.3s ease;
    }
    
    .culture-item:hover {
        transform: translateY(-5px);
    }
    
    .culture-letter {
        font-size: 1.5rem;
        font-weight: 900;
        color: #667eea;
        margin-bottom: 0.5rem;
    }
    
    .culture-name {
        font-weight: 700;
        margin-bottom: 0.5rem;
        color: var(--text-dark);
    }
    
    .culture-desc {
        color: var(--text-light);
        font-size: 0.9375rem;
        line-height: 1.6;
    }
    
    @media (max-width: 1024px) {
        .about-grid {
            grid-template-columns: 1fr;
            gap: 2rem;
        }
        
        .page-hero h1 {
            font-size: 2.75rem;
        }
        
        .culture-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }
    
    @media (max-width: 768px) {
        .page-hero {
            padding: 80px 0 60px;
        }
        
        .page-hero h1 {
            font-size: 2.25rem;
        }
        
        .values-grid {
            grid-template-columns: 1fr;
        }
        
        .about-card {
            padding: 2rem;
        }
        
        .culture-grid {
            grid-template-columns: 1fr;
        }
    }
</style>
@endpush

@section('content')
<!-- Page Hero -->
<section class="page-hero">
    <div class="container">
        <h1>About EntrepreneurEducation</h1>
        <p class="tagline">Where innovation meets excellence in entrepreneur training</p>
        <div class="mission-badge">
            S.E.A Philosophy: Simple • Easy • Enjoyable • Accessible
        </div>
    </div>
</section>

<!-- Mission & Vision -->
<section class="about-section">
    <div class="container">
        <div class="about-grid">
            <div class="about-card">
                <div class="card-icon">
                    <i class="fas fa-eye"></i>
                </div>
                <div class="accent-line"></div>
                <h2 class="card-title">Our Vision</h2>
                <p class="card-text">We teach and train the entrepreneurs of the future. Our goal is to create a world where anyone with entrepreneurial spirit has access to the knowledge, tools, and community they need to succeed.</p>
            </div>
            
            <div class="about-card">
                <div class="card-icon">
                    <i class="fas fa-bullseye"></i>
                </div>
                <div class="accent-line"></div>
                <h2 class="card-title">Our Mission</h2>
                <p class="card-text">To make entrepreneur education <strong>Simple, Easy & Enjoyable, and Accessible (S.E.A)</strong> for everyone. We break down complex business concepts into digestible content available anytime, anywhere.</p>
            </div>
        </div>
        
        <!-- Culture Section -->
        <div class="about-card" style="margin-bottom: 0;">
            <div class="card-icon">
                <i class="fas fa-seedling"></i>
            </div>
            <div class="accent-line"></div>
            <h2 class="card-title">Our Culture: E.A.R.T.H</h2>
            <p class="card-text">We cultivate an environment where entrepreneurs can grow roots and flourish:</p>
            
            <div class="culture-grid">
                <div class="culture-item">
                    <div class="culture-letter">E</div>
                    <h3 class="culture-name">Entrepreneurial</h3>
                    <p class="culture-desc">Creative, persistent, and disciplined in everything we do.</p>
                </div>
                <div class="culture-item">
                    <div class="culture-letter">A</div>
                    <h3 class="culture-name">Awareness</h3>
                    <p class="culture-desc">Staying updated on new tech and understanding customer needs.</p>
                </div>
                <div class="culture-item">
                    <div class="culture-letter">R</div>
                    <h3 class="culture-name">Responsive</h3>
                    <p class="culture-desc">Quick to communicate and adapt to team and customer feedback.</p>
                </div>
                <div class="culture-item">
                    <div class="culture-letter">T</div>
                    <h3 class="culture-name">Transparent</h3>
                    <p class="culture-desc">Open and respectful in all work relationships and communications.</p>
                </div>
                <div class="culture-item">
                    <div class="culture-letter">H</div>
                    <h3 class="culture-name">Honest</h3>
                    <p class="culture-desc">No hidden agendas - we operate with complete integrity.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Values Section -->
<section class="values-section">
    <div class="container">
        <h2 class="section-title">What We Believe In</h2>
        <p class="section-subtitle">Our core principles guide everything we create and every entrepreneur we support</p>
        
        <div class="values-grid">
            <div class="value-item">
                <span class="value-letter">01</span>
                <h3 class="value-name">Digital First</h3>
                <p class="value-desc">We specialize in digital products that make learning simple, easy, enjoyable and accessible.</p>
            </div>
            
            <div class="value-item">
                <span class="value-letter">02</span>
                <h3 class="value-name">Innovation Driven</h3>
                <p class="value-desc">Combining education training with cutting-edge business AI tools for maximum impact.</p>
            </div>
            
            <div class="value-item">
                <span class="value-letter">03</span>
                <h3 class="value-name">Community Powered</h3>
                <p class="value-desc">Building networks where entrepreneurs connect, collaborate, and grow together.</p>
            </div>
            
            <div class="value-item">
                <span class="value-letter">04</span>
                <h3 class="value-name">Results Focused</h3>
                <p class="value-desc">Every product and service is designed to deliver tangible business outcomes.</p>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="stats-section">
    <div class="container">
        <div class="stats-grid">
            <div>
                <div class="stat-number">2</div>
                <div class="stat-label">Core Services</div>
                <p style="color: var(--text-light); font-size: 0.875rem; margin-top: 0.5rem;">Education Training & Business AI Tools</p>
            </div>
            
            <div>
                <div class="stat-number">4</div>
                <div class="stat-label">Training Tracks</div>
                <p style="color: var(--text-light); font-size: 0.875rem; margin-top: 0.5rem;">SET • PDT • BET • RBET</p>
            </div>
            
            <div>
                <div class="stat-number">100%</div>
                <div class="stat-label">Digital Delivery</div>
                <p style="color: var(--text-light); font-size: 0.875rem; margin-top: 0.5rem;">Webinars, Videos, Audio & E-books</p>
            </div>
            
            <div>
                <div class="stat-number">∞</div>
                <div class="stat-label">Accessibility</div>
                <p style="color: var(--text-light); font-size: 0.875rem; margin-top: 0.5rem;">Available anytime, anywhere</p>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
    // Add subtle animations on scroll
    document.addEventListener('DOMContentLoaded', function() {
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };
        
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);
        
        // Observe cards for animation
        document.querySelectorAll('.about-card, .value-item, .culture-item').forEach(card => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            observer.observe(card);
        });
    });
</script>
@endpush