@extends('layouts.public')

@section('title', 'Terms and Conditions - EE Micro LMS')
@section('meta_description', 'Read our terms and conditions for using the EE Micro LMS platform.')

@push('styles')
<style>
    .page-hero {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 80px 0;
        text-align: center;
    }
    
    .page-hero h1 {
        font-size: 48px;
        font-weight: 900;
        margin-bottom: 20px;
    }
    
    .page-hero p {
        font-size: 18px;
        opacity: 0.9;
    }
    
    .legal-content {
        padding: 80px 0;
        max-width: 900px;
        margin: 0 auto;
    }
    
    .legal-content h2 {
        font-size: 28px;
        font-weight: 800;
        margin-top: 40px;
        margin-bottom: 20px;
        color: var(--text-dark);
    }
    
    .legal-content h3 {
        font-size: 20px;
        font-weight: 700;
        margin-top: 30px;
        margin-bottom: 15px;
        color: var(--text-dark);
    }
    
    .legal-content p {
        font-size: 16px;
        line-height: 1.8;
        color: var(--text-gray);
        margin-bottom: 20px;
    }
    
    .legal-content ul, 
    .legal-content ol {
        margin-bottom: 20px;
        padding-left: 30px;
    }
    
    .legal-content li {
        font-size: 16px;
        line-height: 1.8;
        color: var(--text-gray);
        margin-bottom: 10px;
    }
    
    .legal-content strong {
        color: var(--text-dark);
        font-weight: 700;
    }
    
    .last-updated {
        background: var(--bg-light);
        padding: 20px;
        border-radius: 12px;
        margin-bottom: 40px;
        border-left: 4px solid var(--primary-color);
    }
    
    .last-updated p {
        margin: 0;
        font-weight: 600;
    }
    
    @media (max-width: 768px) {
        .page-hero h1 {
            font-size: 32px;
        }
        
        .legal-content {
            padding: 40px 20px;
        }
    }
</style>
@endpush

@section('content')
<!-- Page Hero -->
<section class="page-hero">
    <div class="container">
        <h1>Terms and Conditions</h1>
        <p>Please read these terms carefully before using our platform</p>
    </div>
</section>

<!-- Legal Content -->
<section class="legal-content">
    <div class="container">
        <div class="last-updated">
            <p><strong>Last Updated:</strong> January 1, 2025</p>
        </div>
        
        <h2>1. Acceptance of Terms</h2>
        <p>By accessing and using EE Micro LMS ("the Platform"), you accept and agree to be bound by the terms and provisions of this agreement. If you do not agree to abide by these Terms and Conditions, please do not use this Platform.</p>
        
        <h2>2. Use License</h2>
        <p>Permission is granted to temporarily access the materials (information or software) on EE Micro LMS for personal, non-commercial learning purposes only. This is the grant of a license, not a transfer of title, and under this license you may not:</p>
        <ul>
            <li>Modify or copy the materials</li>
            <li>Use the materials for any commercial purpose or for any public display</li>
            <li>Attempt to reverse engineer any software contained on the Platform</li>
            <li>Remove any copyright or other proprietary notations from the materials</li>
            <li>Transfer the materials to another person or "mirror" the materials on any other server</li>
        </ul>
        
        <h2>3. User Accounts</h2>
        <h3>3.1 Registration</h3>
        <p>To access certain features of the Platform, you must register for an account. When you register, you agree to provide accurate, current, and complete information about yourself.</p>
        
        <h3>3.2 Account Security</h3>
        <p>You are responsible for maintaining the confidentiality of your account credentials and for all activities that occur under your account. You agree to:</p>
        <ul>
            <li>Immediately notify us of any unauthorized use of your account</li>
            <li>Ensure that you log out from your account at the end of each session</li>
            <li>Use a strong, unique password for your account</li>
        </ul>
        
        <h2>4. Course Enrollment and Access</h2>
        <h3>4.1 Enrollment</h3>
        <p>When you enroll in a course, you are granted a limited, non-exclusive, non-transferable license to access and view the course content for personal, non-commercial, educational purposes only.</p>
        
        <h3>4.2 Lifetime Access</h3>
        <p>Unless otherwise specified, enrolled courses provide lifetime access, meaning you can access the course materials as long as the Platform exists and the course is maintained.</p>
        
        <h3>4.3 Course Changes</h3>
        <p>We reserve the right to modify, update, or discontinue courses at any time. In the event a course is discontinued, we will make reasonable efforts to provide alternative learning materials.</p>
        
        <h2>5. Payment and Refunds</h2>
        <h3>5.1 Pricing</h3>
        <p>Course prices are displayed in US dollars and are subject to change without notice. All payments are processed securely through our payment partners.</p>
        
        <h3>5.2 Refund Policy</h3>
        <p>We offer a 30-day money-back guarantee on most courses. To request a refund, contact our support team within 30 days of purchase. Refunds are not available for:</p>
        <ul>
            <li>Courses that have been substantially consumed (more than 50% of content viewed)</li>
            <li>Certificates that have been issued</li>
            <li>Special promotional offers or bundled packages</li>
        </ul>
        
        <h2>6. Intellectual Property Rights</h2>
        <p>All content on the Platform, including but not limited to text, graphics, logos, videos, audio files, and software, is the property of EE Micro LMS or its content suppliers and is protected by international copyright laws.</p>
        
        <h3>6.1 Copyright</h3>
        <p>The compilation of all content on this Platform is the exclusive property of EE Micro LMS and is protected by copyright laws. All software used on this Platform is the property of EE Micro LMS or its software suppliers.</p>
        
        <h3>6.2 Trademarks</h3>
        <p>All trademarks, service marks, and trade names used on the Platform are proprietary to EE Micro LMS or their respective owners.</p>
        
        <h2>7. User Conduct</h2>
        <p>You agree not to use the Platform to:</p>
        <ul>
            <li>Violate any applicable laws or regulations</li>
            <li>Infringe upon the rights of others</li>
            <li>Transmit any harmful or malicious code</li>
            <li>Attempt to gain unauthorized access to any part of the Platform</li>
            <li>Interfere with or disrupt the Platform or servers</li>
            <li>Impersonate any person or entity</li>
            <li>Harass, abuse, or harm other users</li>
            <li>Distribute spam or unsolicited communications</li>
        </ul>
        
        <h2>8. Content Submission</h2>
        <p>If you submit content to the Platform (such as forum posts, reviews, or assignments), you grant EE Micro LMS a worldwide, non-exclusive, royalty-free license to use, reproduce, modify, and display such content in connection with operating the Platform.</p>
        
        <h2>9. Third-Party Links</h2>
        <p>The Platform may contain links to third-party websites or services that are not owned or controlled by EE Micro LMS. We have no control over, and assume no responsibility for, the content, privacy policies, or practices of any third-party websites or services.</p>
        
        <h2>10. Disclaimer of Warranties</h2>
        <p>The Platform and all content are provided "as is" without any warranties, express or implied. EE Micro LMS does not warrant that:</p>
        <ul>
            <li>The Platform will be available at all times or error-free</li>
            <li>Defects will be corrected</li>
            <li>The Platform or servers are free of viruses or harmful components</li>
            <li>The use of the Platform will meet your requirements</li>
        </ul>
        
        <h2>11. Limitation of Liability</h2>
        <p>In no event shall EE Micro LMS, its directors, employees, partners, or suppliers be liable for any indirect, incidental, special, consequential, or punitive damages, including without limitation, loss of profits, data, use, goodwill, or other intangible losses, resulting from:</p>
        <ul>
            <li>Your access to or use of or inability to access or use the Platform</li>
            <li>Any conduct or content of any third party on the Platform</li>
            <li>Any content obtained from the Platform</li>
            <li>Unauthorized access, use, or alteration of your transmissions or content</li>
        </ul>
        
        <h2>12. Indemnification</h2>
        <p>You agree to indemnify, defend, and hold harmless EE Micro LMS and its officers, directors, employees, and agents from and against any claims, liabilities, damages, losses, and expenses arising out of or in any way connected with your access to or use of the Platform.</p>
        
        <h2>13. Termination</h2>
        <p>We may terminate or suspend your account and access to the Platform immediately, without prior notice or liability, for any reason whatsoever, including without limitation if you breach these Terms and Conditions.</p>
        
        <h2>14. Governing Law</h2>
        <p>These Terms and Conditions shall be governed by and construed in accordance with the laws of the State of California, United States, without regard to its conflict of law provisions.</p>
        
        <h2>15. Changes to Terms</h2>
        <p>We reserve the right to modify or replace these Terms and Conditions at any time. If a revision is material, we will provide at least 30 days' notice prior to any new terms taking effect. What constitutes a material change will be determined at our sole discretion.</p>
        
        <h2>16. Contact Information</h2>
        <p>If you have any questions about these Terms and Conditions, please contact us:</p>
        <ul>
            <li>Email: legal@eemicrolms.com</li>
            <li>Phone: +1 (555) 123-4567</li>
            <li>Address: 123 Learning Street, San Francisco, CA 94102, United States</li>
        </ul>
        
        <h2>17. Severability</h2>
        <p>If any provision of these Terms and Conditions is held to be invalid or unenforceable by a court, the remaining provisions will continue in full force and effect.</p>
        
        <h2>18. Entire Agreement</h2>
        <p>These Terms and Conditions constitute the entire agreement between you and EE Micro LMS regarding your use of the Platform and supersede all prior and contemporaneous agreements, proposals, or representations.</p>
    </div>
</section>
@endsection
