@extends('layouts.student')

@section('title', 'Browse Courses')

@section('content')
<style>
    .browse-header {
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(20px);
        padding: 40px;
        border-radius: 25px;
        margin-bottom: 30px;
        border: 1px solid rgba(255,255,255,0.3);
    }

    .browse-header h1 {
        color: white;
        font-size: 2.5em;
        margin-bottom: 15px;
        font-weight: 800;
    }

    .browse-header p {
        color: rgba(255,255,255,0.95);
        font-size: 1.1em;
    }

    .search-bar {
        background: white;
        padding: 30px;
        border-radius: 20px;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }

    .search-input-group {
        display: flex;
        gap: 15px;
    }

    .search-input {
        flex: 1;
        padding: 15px 20px;
        border: 2px solid #e5e7eb;
        border-radius: 15px;
        font-size: 1em;
        transition: all 0.3s ease;
    }

    .search-input:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .btn-search {
        padding: 15px 40px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border: none;
        border-radius: 15px;
        font-weight: 700;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .btn-search:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }

    .courses-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
        gap: 30px;
    }

    .browse-course-card {
        background: white;
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        transition: all 0.4s ease;
        cursor: pointer;
    }

    .browse-course-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 50px rgba(102, 126, 234, 0.3);
    }

    .course-thumbnail {
        height: 200px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        overflow: hidden;
    }

    .course-thumbnail i {
        font-size: 5em;
        color: rgba(255,255,255,0.3);
    }

    .enrolled-badge {
        position: absolute;
        top: 15px;
        right: 15px;
        background: linear-gradient(135deg, #10b981, #059669);
        color: white;
        padding: 8px 20px;
        border-radius: 20px;
        font-size: 0.85em;
        font-weight: 700;
    }

    .course-body {
        padding: 30px;
    }

    .course-title {
        font-size: 1.4em;
        font-weight: 700;
        color: #333;
        margin-bottom: 15px;
        line-height: 1.3;
    }

    .course-description {
        color: #6b7280;
        line-height: 1.6;
        margin-bottom: 20px;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .course-stats {
        display: flex;
        gap: 20px;
        margin-bottom: 20px;
        padding-bottom: 20px;
        border-bottom: 2px solid #f3f4f6;
    }

    .stat-item {
        display: flex;
        align-items: center;
        gap: 8px;
        color: #6b7280;
        font-size: 0.9em;
    }

    .stat-item i {
        color: #667eea;
    }

    .course-actions {
        display: flex;
        gap: 10px;
    }

    .btn-enroll {
        flex: 1;
        padding: 12px;
        border: none;
        border-radius: 12px;
        font-weight: 700;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .btn-primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
    }

    .btn-secondary {
        background: rgba(102, 126, 234, 0.1);
        color: #667eea;
    }

    .btn-secondary:hover {
        background: rgba(102, 126, 234, 0.2);
    }

    .progress-indicator {
        margin-top: 15px;
    }

    .progress-bar-small {
        background: #f3f4f6;
        height: 8px;
        border-radius: 10px;
        overflow: hidden;
        margin-bottom: 8px;
    }

    .progress-fill-small {
        height: 100%;
        background: linear-gradient(90deg, #10b981, #34d399);
        border-radius: 10px;
        transition: width 0.6s ease;
    }

    .progress-text-small {
        font-size: 0.85em;
        color: #6b7280;
        font-weight: 600;
    }

    .empty-state {
        text-align: center;
        padding: 80px 20px;
        background: white;
        border-radius: 25px;
    }

    .empty-state i {
        font-size: 5em;
        color: #d1d5db;
        margin-bottom: 20px;
    }

    .empty-state h3 {
        color: #6b7280;
        font-size: 1.5em;
        margin-bottom: 10px;
    }

    .empty-state p {
        color: #9ca3af;
    }
</style>

<div class="browse-header">
    <h1>🔍 Browse Courses</h1>
    <p>Discover amazing courses and start your learning journey today!</p>
</div>

<div class="search-bar">
    <form action="{{ route('student.browse') }}" method="GET">
        <div class="search-input-group">
            <input 
                type="text" 
                name="search" 
                class="search-input" 
                placeholder="Search courses by name or description..."
                value="{{ $search }}"
            >
            <button type="submit" class="btn-search">
                <i class="fas fa-search"></i>
                Search
            </button>
        </div>
    </form>
</div>

@if($courses->count() > 0)
    <div class="courses-grid">
        @foreach($courses as $course)
            <div class="browse-course-card">
                <div class="course-thumbnail">
                    <i class="fas fa-graduation-cap"></i>
                    @if($course->is_enrolled)
                        <div class="enrolled-badge">
                            <i class="fas fa-check"></i> Enrolled
                        </div>
                    @endif
                </div>
                <div class="course-body">
                    <h3 class="course-title">{{ $course->name }}</h3>
                    @if($course->description)
                        <p class="course-description">{{ $course->description }}</p>
                    @endif
                    
                    <div class="course-stats">
                        <div class="stat-item">
                            <i class="fas fa-book"></i>
                            <span>{{ $course->lessons->count() }} Lessons</span>
                        </div>
                        <div class="stat-item">
                            <i class="fas fa-tasks"></i>
                            <span>{{ $course->total_topics }} Topics</span>
                        </div>
                        @if(!$course->is_free)
                        <div class="stat-item">
                            <i class="fas fa-tag"></i>
                            <span class="text-green-600 font-bold">{{ $course->currency }} {{ number_format($course->price, 2) }}</span>
                        </div>
                        @else
                        <div class="stat-item">
                            <i class="fas fa-gift"></i>
                            <span class="text-blue-600 font-bold">Free</span>
                        </div>
                        @endif
                    </div>

                    @if($course->is_enrolled)
                        <div class="progress-indicator">
                            <div class="progress-bar-small">
                                <div class="progress-fill-small" style="width: {{ $course->progress_percentage }}%"></div>
                            </div>
                            <div class="progress-text-small">{{ $course->progress_percentage }}% Complete</div>
                        </div>
                    @endif

                    <div class="course-actions">
                        @if($course->is_enrolled)
                            <a href="{{ route('learn.course', $course->id) }}" class="btn-enroll btn-primary">
                                <i class="fas fa-play"></i>
                                Continue Learning
                            </a>
                        @else
                            @if($course->is_free)
                                <a href="{{ route('learn.course', $course->id) }}" class="btn-enroll btn-primary">
                                    <i class="fas fa-rocket"></i>
                                    Start Course
                                </a>
                            @else
                                <a href="{{ route('payment.checkout', $course->id) }}" class="btn-enroll btn-primary">
                                    <i class="fas fa-shopping-cart"></i>
                                    Purchase Course
                                </a>
                            @endif
                        @endif
                        <a href="{{ route('learn.course', $course->id) }}" class="btn-enroll btn-secondary">
                            <i class="fas fa-info-circle"></i>
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@else
    <div class="empty-state">
        <i class="fas fa-search"></i>
        <h3>No courses found</h3>
        <p>Try adjusting your search terms</p>
    </div>
@endif
@endsection
