@extends('layouts.student')

@section('title', 'View Certificate')

@section('styles')
<style>
    .certificate-container {
        max-width: 1000px;
        margin: 0 auto;
        padding: 20px;
    }

    .certificate-header {
        background: white;
        border-radius: 16px;
        padding: 30px;
        margin-bottom: 30px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 20px;
    }

    .certificate-info h1 {
        font-size: 2rem;
        font-weight: 800;
        background: linear-gradient(135deg, #667eea, #764ba2);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 10px;
    }

    .certificate-meta {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .certificate-actions {
        display: flex;
        gap: 12px;
    }

    .btn {
        padding: 12px 24px;
        border-radius: 8px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        font-weight: 600;
        transition: all 0.3s;
        border: none;
        cursor: pointer;
    }

    .btn-primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(102, 126, 234, 0.4);
    }

    .btn-success {
        background: linear-gradient(135deg, #10b981, #059669);
        color: white;
    }

    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(16, 185, 129, 0.4);
    }

    .btn-secondary {
        background: #e5e7eb;
        color: #374151;
    }

    .btn-secondary:hover {
        background: #d1d5db;
    }

    .certificate-preview {
        background: white;
        border-radius: 16px;
        padding: 40px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        text-align: center;
    }

    .certificate-content {
        border: 4px solid #667eea;
        border-radius: 12px;
        padding: 60px 40px;
        background: linear-gradient(135deg, #f9fafb 0%, #ffffff 100%);
        position: relative;
        overflow: hidden;
    }

    .certificate-content::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(102, 126, 234, 0.05) 0%, transparent 70%);
        animation: rotate 30s linear infinite;
    }

    @keyframes rotate {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    .certificate-title {
        font-size: 3rem;
        font-weight: 900;
        background: linear-gradient(135deg, #667eea, #764ba2);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 20px;
        position: relative;
        z-index: 1;
    }

    .certificate-subtitle {
        font-size: 1.2rem;
        color: #6b7280;
        margin-bottom: 30px;
        position: relative;
        z-index: 1;
    }

    .certificate-recipient {
        font-size: 2.5rem;
        font-weight: 800;
        color: #1f2937;
        margin: 30px 0;
        position: relative;
        z-index: 1;
    }

    .certificate-description {
        font-size: 1.1rem;
        color: #374151;
        margin-bottom: 30px;
        line-height: 1.6;
        position: relative;
        z-index: 1;
    }

    .certificate-details {
        display: flex;
        justify-content: space-around;
        margin-top: 40px;
        padding-top: 30px;
        border-top: 2px solid #e5e7eb;
        position: relative;
        z-index: 1;
    }

    .certificate-detail {
        text-align: center;
    }

    .certificate-detail-label {
        font-size: 0.85rem;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 5px;
    }

    .certificate-detail-value {
        font-size: 1.1rem;
        font-weight: 700;
        color: #1f2937;
    }

    .qr-code-section {
        margin-top: 30px;
        padding-top: 30px;
        border-top: 2px solid #e5e7eb;
        position: relative;
        z-index: 1;
    }

    .qr-code-section img {
        max-width: 150px;
        height: auto;
        border: 2px solid #667eea;
        border-radius: 8px;
        padding: 10px;
        background: white;
    }

    @media print {
        .certificate-header,
        .certificate-actions,
        .btn {
            display: none !important;
        }

        .certificate-container {
            max-width: 100%;
        }

        .certificate-preview {
            box-shadow: none;
            padding: 0;
        }
    }

    @media (max-width: 768px) {
        .certificate-title {
            font-size: 2rem;
        }

        .certificate-recipient {
            font-size: 1.8rem;
        }

        .certificate-details {
            flex-direction: column;
            gap: 20px;
        }

        .certificate-actions {
            flex-direction: column;
            width: 100%;
        }

        .btn {
            width: 100%;
            justify-content: center;
        }
    }
</style>
@endsection

@section('content')
<div class="certificate-container">
    <div class="certificate-header">
        <div class="certificate-info">
            <h1>🏆 Certificate of Completion</h1>
            <div class="certificate-meta">
                <strong>Code:</strong> {{ $certificate->certificate_code }}<br>
                <strong>Issued:</strong> {{ $certificate->issued_at->format('F j, Y') }}
            </div>
        </div>
        <div class="certificate-actions">
            <a href="{{ route('student.certificates') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Certificates
            </a>
            @if($certificate->pdf_path)
            <a href="{{ route('student.certificate.download', $certificate->id) }}" class="btn btn-success">
                <i class="fas fa-download"></i> Download PDF
            </a>
            @endif
            <button onclick="window.print()" class="btn btn-primary">
                <i class="fas fa-print"></i> Print
            </button>
        </div>
    </div>

    <div class="certificate-preview">
        <div class="certificate-content">
            <div class="certificate-title">🎓 CERTIFICATE OF ACHIEVEMENT</div>
            <div class="certificate-subtitle">This certifies that</div>
            
            <div class="certificate-recipient">{{ $certificate->user->name }}</div>
            
            <div class="certificate-description">
                has successfully completed
                <strong>{{ $certificate->assignable->name ?? $certificate->assignable->title ?? 'Course' }}</strong>
                @if($certificate->assignable_type === 'App\Models\Lesson')
                    (Lesson)
                @else
                    (Course)
                @endif
            </div>

            <div class="certificate-details">
                <div class="certificate-detail">
                    <div class="certificate-detail-label">Student Name</div>
                    <div class="certificate-detail-value">{{ $certificate->user->name }}</div>
                </div>
                <div class="certificate-detail">
                    <div class="certificate-detail-label">Date Issued</div>
                    <div class="certificate-detail-value">{{ $certificate->issued_at->format('M j, Y') }}</div>
                </div>
                <div class="certificate-detail">
                    <div class="certificate-detail-label">Certificate ID</div>
                    <div class="certificate-detail-value">{{ $certificate->certificate_code }}</div>
                </div>
            </div>

            @if($certificate->qr_code_path)
            <div class="qr-code-section">
                <p style="margin-bottom: 10px; font-size: 0.9rem; color: #6b7280;">Scan to verify authenticity</p>
                <img src="{{ Storage::url($certificate->qr_code_path) }}" alt="QR Code">
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
