﻿@extends('layouts.student')

@section('title', 'My Certificates')

@section('styles')
<style>
    .certificates-header {
        background: white;
        border-radius: 16px;
        padding: 30px;
        margin-bottom: 30px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }

    .certificates-header h1 {
        font-size: 2.5rem;
        font-weight: 800;
        background: linear-gradient(135deg, #667eea, #764ba2);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 10px;
    }

    .empty-state {
        background: white;
        border-radius: 16px;
        padding: 60px 30px;
        text-align: center;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }

    .empty-state i {
        font-size: 5rem;
        color: #e5e7eb;
        margin-bottom: 20px;
    }

    .empty-state h2 {
        font-size: 1.8rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 10px;
    }

    .btn-primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        font-weight: 600;
        transition: all 0.3s;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(102, 126, 234, 0.4);
    }
</style>
@endsection

@section('content')
<div class="certificates-header">
        <h1> My Certificates</h1>
        <p>Your achievements and earned certificates</p>
        @if(session('success'))
            <div class="alert alert-success" style="margin-top:10px;">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-error" style="margin-top:10px;">{{ session('error') }}</div>
        @endif
        @if ($errors->any())
            <div class="alert alert-error" style="margin-top:10px;">
                {{ $errors->first() }}
            </div>
        @endif
    </div>

@if(($certificates ?? collect())->isEmpty())
    <div class="empty-state">
            <i class="fas fa-certificate"></i>
            <h2>No Certificates Yet</h2>
            <p>Complete lessons or courses to earn certificates and showcase your achievements!</p>
            <a href="{{ route('student.browse') }}" class="btn-primary">
                    <i class="fas fa-search"></i>
                    Browse Courses
            </a>
    </div>
@else
    <div class="grid" style="display:grid; gap:20px; grid-template-columns: repeat(auto-fill, minmax(320px,1fr));">
        @foreach($certificates as $cert)
            <div class="card" style="background:white; border-radius:12px; padding:20px; box-shadow:0 4px 6px -1px rgba(0,0,0,.1);">
                <div style="display:flex; align-items:center; gap:12px; margin-bottom:10px;">
                    <div style="font-size:28px;">📜</div>
                    <div>
                        <div style="font-weight:700;">{{ optional($cert->assignable)->title ?? optional($cert->assignable)->name ?? 'Certificate' }}</div>
                        <div style="color:#6b7280; font-size:12px;">Code: {{ $cert->certificate_code }}</div>
                        <div style="color:#6b7280; font-size:12px;">Issued: {{ optional($cert->issued_at)->format('M j, Y') }}</div>
                    </div>
                </div>
                <div style="display:flex; gap:10px;">
                    <a class="btn-primary" style="padding:10px 14px; border-radius:8px;" href="{{ route('student.certificate.view', $cert->id) }}" target="_blank">View</a>
                    <a class="btn-primary" style="padding:10px 14px; border-radius:8px; background:linear-gradient(135deg,#10b981,#059669)" href="{{ route('student.certificate.download', $cert->id) }}">Download</a>
                </div>
            </div>
        @endforeach
    </div>
@endif
@endsection
