<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $course->name }} - EE Micro LMS</title>
    
    @php
        $brand = \App\Support\BrandSettings::data();
        $faviconUrl = $brand['favicon_url'] ?? null;
    @endphp
    
    @if($faviconUrl)
        <link rel="icon" type="image/png" href="{{ $faviconUrl }}">
        <link rel="shortcut icon" type="image/png" href="{{ $faviconUrl }}">
    @endif
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }

        /* Navbar */
        .navbar {
            background: rgba(255,255,255,0.98);
            padding: 15px 0;
            backdrop-filter: blur(20px);
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .navbar-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .nav-back {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .btn-back {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
            text-decoration: none;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-back:hover {
            background: #667eea;
            color: white;
            transform: translateX(-5px);
        }

        .course-title-nav {
            font-size: 1.2em;
            font-weight: 700;
            color: #333;
        }

        .progress-badge {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
            padding: 8px 20px;
            border-radius: 25px;
            font-weight: 700;
            font-size: 0.95em;
        }

        /* Container */
        .container {
            max-width: 1400px;
            margin: 30px auto;
            padding: 0 30px;
        }

        /* Course Header */
        .course-header {
            background: rgba(255,255,255,0.98);
            padding: 40px;
            border-radius: 25px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }

        .course-header h1 {
            font-size: 2.5em;
            color: #333;
            margin-bottom: 15px;
            font-weight: 800;
        }

        .course-meta {
            display: flex;
            gap: 30px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 10px;
            color: #6b7280;
            font-weight: 500;
        }

        .meta-item i {
            color: #667eea;
            font-size: 1.2em;
        }

        .course-description {
            color: #4b5563;
            line-height: 1.8;
            font-size: 1.05em;
        }

        /* Overall Progress */
        .overall-progress {
            background: rgba(255,255,255,0.15);
            backdrop-filter: blur(20px);
            padding: 30px;
            border-radius: 20px;
            margin-bottom: 30px;
            border: 1px solid rgba(255,255,255,0.3);
        }

        .overall-progress h2 {
            color: white;
            font-size: 1.5em;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .progress-bar-large {
            background: rgba(255,255,255,0.3);
            height: 20px;
            border-radius: 25px;
            overflow: hidden;
            margin-bottom: 15px;
            position: relative;
        }

        .progress-fill-large {
            height: 100%;
            background: linear-gradient(90deg, #10b981, #34d399);
            border-radius: 25px;
            transition: width 0.6s ease;
            position: relative;
            overflow: hidden;
        }

        .progress-fill-large::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            animation: shimmer 2s infinite;
        }

        @keyframes shimmer {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }

        .progress-stats {
            display: flex;
            justify-content: space-between;
            color: white;
            font-size: 1.1em;
            font-weight: 600;
        }

        /* Lessons Section */
        .lessons-section {
            background: rgba(255,255,255,0.98);
            padding: 40px;
            border-radius: 25px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }

        .lessons-section h2 {
            font-size: 2em;
            color: #333;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .lesson-card {
            background: #f9fafb;
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 25px;
            transition: all 0.3s ease;
            border: 2px solid transparent;
            position: relative;
        }

        .lesson-card:hover {
            border-color: #667eea;
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.2);
        }

        .lesson-card.locked {
            background: #f3f4f6;
            opacity: 0.7;
            cursor: not-allowed;
        }

        .lesson-card.locked:hover {
            border-color: transparent;
            box-shadow: none;
        }

        .lesson-card.locked::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: repeating-linear-gradient(
                45deg,
                transparent,
                transparent 10px,
                rgba(156, 163, 175, 0.05) 10px,
                rgba(156, 163, 175, 0.05) 20px
            );
            border-radius: 20px;
            pointer-events: none;
        }

        .lesson-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            cursor: pointer;
        }

        .lesson-card.locked .lesson-header {
            cursor: not-allowed;
        }

        .lesson-title-area {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .lesson-number {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 800;
            font-size: 1.2em;
            position: relative;
        }

        .lesson-card.locked .lesson-number {
            background: linear-gradient(135deg, #9ca3af, #6b7280);
        }

        .lock-badge {
            background: #ef4444;
            color: white;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 0.8em;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            margin-left: 10px;
        }

        .lesson-title {
            font-size: 1.4em;
            font-weight: 700;
            color: #333;
            margin-bottom: 8px;
        }

        .lesson-description {
            font-size: 0.9em;
            color: #6b7280;
            line-height: 1.5;
            margin-top: 8px;
        }

        .lesson-status {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-top: 10px;
        }

        .completion-badge {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 0.8em;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .lesson-progress-text {
            font-size: 0.85em;
            color: #6b7280;
            font-weight: 500;
        }

        .lesson-toggle {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
            border: none;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .lesson-toggle:hover {
            background: #667eea;
            color: white;
        }

        .lesson-toggle i {
            transition: transform 0.3s ease;
        }

        .lesson-card.expanded .lesson-toggle i {
            transform: rotate(180deg);
        }

        .topics-list {
            display: none;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
        }

        .lesson-card.expanded .topics-list {
            display: block;
            animation: slideDown 0.3s ease;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .topic-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 18px 20px;
            background: white;
            border-radius: 15px;
            margin-bottom: 12px;
            transition: all 0.3s ease;
            cursor: pointer;
            border: 2px solid transparent;
            position: relative;
        }

        .topic-item:hover {
            border-color: #667eea;
            transform: translateX(10px);
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.15);
        }

        .topic-item.completed {
            background: linear-gradient(135deg, #ecfdf5, #d1fae5);
            border-color: #10b981;
        }

        .topic-item.locked {
            background: #f9fafb;
            opacity: 0.6;
            cursor: not-allowed;
            pointer-events: none;
        }

        .topic-item.locked:hover {
            border-color: transparent;
            transform: none;
            box-shadow: none;
        }

        .topic-item.locked::before {
            content: '\f023';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 1.5em;
            color: #ef4444;
            opacity: 0.5;
        }

        .topic-left {
            display: flex;
            align-items: center;
            gap: 15px;
            flex: 1;
        }

        .topic-icon {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2em;
        }

        .topic-item:not(.completed) .topic-icon {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .topic-item.completed .topic-icon {
            background: #10b981;
            color: white;
        }

        .topic-details {
            flex: 1;
        }

        .topic-title {
            font-weight: 600;
            color: #333;
            margin-bottom: 5px;
        }

        .topic-meta {
            font-size: 0.85em;
            color: #6b7280;
            display: flex;
            gap: 15px;
        }

        .btn-start {
            padding: 10px 25px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border: none;
            border-radius: 25px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-start:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .topic-item.completed .btn-start {
            background: linear-gradient(135deg, #10b981, #059669);
        }

        .empty-topics {
            text-align: center;
            padding: 40px;
            color: #9ca3af;
        }

        .empty-topics i {
            font-size: 3em;
            margin-bottom: 15px;
            opacity: 0.5;
        }

        /* Survey Modal */
        .survey-modal-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.7);
            z-index: 2000;
            animation: fadeIn 0.3s ease;
        }

        .survey-modal-overlay.active {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .survey-modal {
            background: white;
            border-radius: 20px;
            max-width: 600px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            animation: slideUp 0.3s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideUp {
            from { transform: translateY(50px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }

        .survey-header {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 30px;
            border-radius: 20px 20px 0 0;
            text-align: center;
        }

        .survey-header h2 {
            font-size: 1.8em;
            margin-bottom: 10px;
        }

        .survey-body {
            padding: 30px;
        }

        .survey-question {
            margin-bottom: 25px;
        }

        .survey-question label {
            display: block;
            font-weight: 600;
            color: #333;
            margin-bottom: 10px;
            font-size: 1.05em;
        }

        .survey-question .required {
            color: #ef4444;
        }

        .survey-question input[type="text"],
        .survey-question textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 1em;
            font-family: inherit;
            transition: border-color 0.2s;
        }

        .survey-question input:focus,
        .survey-question textarea:focus {
            outline: none;
            border-color: #667eea;
        }

        .rating-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        .rating-btn {
            flex: 1;
            min-width: 50px;
            padding: 12px;
            border: 2px solid #e5e7eb;
            background: white;
            border-radius: 10px;
            font-size: 1.1em;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }

        .rating-btn:hover {
            border-color: #667eea;
            transform: translateY(-2px);
        }

        .rating-btn.selected {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border-color: #667eea;
        }

        .survey-actions {
            padding: 20px 30px 30px;
            display: flex;
            gap: 15px;
        }

        .survey-btn {
            flex: 1;
            padding: 15px;
            border: none;
            border-radius: 12px;
            font-size: 1.05em;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .survey-btn-submit {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
        }

        .survey-btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .survey-btn-skip {
            background: #e5e7eb;
            color: #6b7280;
        }

        .survey-btn-skip:hover {
            background: #d1d5db;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .course-header h1 {
                font-size: 1.8em;
            }

            .course-meta {
                gap: 15px;
            }

            .lesson-title {
                font-size: 1.1em;
            }

            .topic-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }

            .btn-start {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-content">
            <div class="nav-back">
                <a href="{{ route('dashboard') }}" class="btn-back">
                    <i class="fas fa-arrow-left"></i>
                    Back to Dashboard
                </a>
                <span class="course-title-nav">{{ $course->name }}</span>
            </div>
            <div class="progress-badge" id="progress-badge-display">
                <i class="fas fa-chart-line"></i>
                <span id="progress-value">{{ $progressPercentage }}</span>% Complete
            </div>
        </div>
    </nav>

    <div class="container">
        <!-- Course Header -->
        <div class="course-header">
            <h1>{{ $course->name }}</h1>
            <div class="course-meta">
                <div class="meta-item">
                    <i class="fas fa-book"></i>
                    <span>{{ $course->lessons->count() }} Lessons</span>
                </div>
                <div class="meta-item">
                    <i class="fas fa-tasks"></i>
                    <span>{{ $totalTopics }} Topics</span>
                </div>
                <div class="meta-item">
                    <i class="fas fa-check-circle"></i>
                    <span>{{ $completedTopics }} Completed</span>
                </div>
            </div>
            @if($course->description)
                <div class="course-description">
                    {{ $course->description }}
                </div>
            @endif
        </div>

        <!-- Overall Progress -->
        <div class="overall-progress">
            <h2>
                <i class="fas fa-chart-pie"></i>
                Your Progress
            </h2>
            <div class="progress-bar-large">
                <div class="progress-fill-large" style="width: {{ $progressPercentage }}%"></div>
            </div>
            <div class="progress-stats">
                <span>{{ $completedTopics }} of {{ $totalTopics }} topics completed</span>
                <span>{{ $progressPercentage }}%</span>
            </div>
        </div>

        <!-- Lessons -->
        <div class="lessons-section">
            <h2>
                <i class="fas fa-list"></i>
                Course Content
            </h2>

            @forelse($course->lessons as $index => $lesson)
                @php
                    $lessonTopics = $lesson->topics;
                    $lessonCompleted = 0;
                    $totalLessonTopics = $lessonTopics->count();
                    $isLessonUnlocked = $unlockedLessons[$lesson->id] ?? false;
                    
                    foreach($lessonTopics as $topic) {
                        if(isset($userProgressData[$topic->id]) && $userProgressData[$topic->id]->completed) {
                            $lessonCompleted++;
                        }
                    }
                    
                    $isLessonFullyCompleted = ($totalLessonTopics > 0 && $lessonCompleted === $totalLessonTopics);
                    
                    // Truncate description to 120 characters
                    $lessonDescription = $lesson->intro ?? '';
                    $truncatedDescription = strlen($lessonDescription) > 120 
                        ? substr($lessonDescription, 0, 120) . '...' 
                        : $lessonDescription;
                @endphp

                <div class="lesson-card {{ !$isLessonUnlocked ? 'locked' : '' }}" data-lesson-id="{{ $lesson->id }}">
                    <div class="lesson-header" onclick="{{ $isLessonUnlocked ? 'toggleLesson(' . $lesson->id . ')' : 'showLockedMessage()' }}">
                        <div class="lesson-title-area">
                            <div class="lesson-number">
                                @if($isLessonUnlocked)
                                    {{ $index + 1 }}
                                @else
                                    <i class="fas fa-lock"></i>
                                @endif
                            </div>
                            <div style="flex: 1;">
                                <div class="lesson-title">
                                    {{ $lesson->title }}
                                    @if(!$isLessonUnlocked)
                                        <span class="lock-badge">
                                            <i class="fas fa-lock"></i>
                                            Locked
                                        </span>
                                    @endif
                                </div>
                                
                                @if($truncatedDescription)
                                    <div class="lesson-description">
                                        {{ $truncatedDescription }}
                                    </div>
                                @endif
                                
                                <div class="lesson-status">
                                    @if($isLessonFullyCompleted)
                                        <span class="completion-badge">
                                            <i class="fas fa-check-circle"></i>
                                            Completed
                                        </span>
                                    @endif
                                    <span class="lesson-progress-text">
                                        {{ $lessonCompleted }} / {{ $totalLessonTopics }} topics completed
                                    </span>
                                </div>
                                
                                @if(!$isLessonUnlocked)
                                    <div style="font-size: 0.85em; color: #ef4444; margin-top: 8px;">
                                        <i class="fas fa-info-circle"></i> Complete previous lesson to unlock
                                    </div>
                                @endif
                            </div>
                        </div>
                        @if($isLessonUnlocked)
                            <button class="lesson-toggle">
                                <i class="fas fa-chevron-down"></i>
                            </button>
                        @endif
                    </div>

                    @if($isLessonUnlocked)
                        <div class="topics-list">
                            @forelse($lessonTopics as $topicIndex => $topic)
                                @php
                                    $isCompleted = isset($userProgressData[$topic->id]) && $userProgressData[$topic->id]->completed;
                                    // Check if previous topic in this lesson is completed (progressive locking within lesson)
                                    $isTopicUnlocked = true;
                                    if ($topicIndex > 0) {
                                        $previousTopic = $lessonTopics[$topicIndex - 1];
                                        $previousProgress = $userProgressData->get($previousTopic->id);
                                        $isTopicUnlocked = $previousProgress && $previousProgress->completed;
                                    }
                                @endphp

                                @if($isTopicUnlocked)
                                    <a href="{{ route('learn.topic', ['course' => $course->id, 'lesson' => $lesson->id, 'topic' => $topic->id]) }}" 
                                       class="topic-item {{ $isCompleted ? 'completed' : '' }}" 
                                       style="text-decoration: none;">
                                        <div class="topic-left">
                                            <div class="topic-icon">
                                                <i class="fas fa-{{ $isCompleted ? 'check-circle' : 'play-circle' }}"></i>
                                            </div>
                                            <div class="topic-details">
                                                <div class="topic-title">{{ $topic->title }}</div>
                                                <div class="topic-meta">
                                                    @if($topic->video_url)
                                                        <span><i class="fas fa-video"></i> Video</span>
                                                    @endif
                                                    @if($topic->quizQuestions->count() > 0)
                                                        <span><i class="fas fa-question-circle"></i> {{ $topic->quizQuestions->count() }} Questions</span>
                                                    @endif
                                                    @if($isCompleted)
                                                        <span style="color: #10b981; font-weight: 600;">
                                                            <i class="fas fa-check"></i> Completed
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <span class="btn-start">
                                            <i class="fas fa-{{ $isCompleted ? 'redo' : 'play' }}"></i>
                                            {{ $isCompleted ? 'Review' : 'Start' }}
                                        </span>
                                    </a>
                                @else
                                    <div class="topic-item locked">
                                        <div class="topic-left">
                                            <div class="topic-icon" style="background: #e5e7eb; color: #9ca3af;">
                                                <i class="fas fa-lock"></i>
                                            </div>
                                            <div class="topic-details">
                                                <div class="topic-title" style="color: #9ca3af;">{{ $topic->title }}</div>
                                                <div class="topic-meta">
                                                    <span style="color: #ef4444; font-weight: 600;">
                                                        <i class="fas fa-lock"></i> Complete previous topic to unlock
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @empty
                                <div class="empty-topics">
                                    <i class="fas fa-inbox"></i>
                                    <p>No topics in this lesson yet</p>
                                </div>
                            @endforelse
                        </div>
                    @endif
                </div>
            @empty
                <div class="empty-topics">
                    <i class="fas fa-folder-open"></i>
                    <p>No lessons in this course yet</p>
                </div>
            @endforelse
        </div>
    </div>

    <script>
        function toggleLesson(lessonId) {
            const card = document.querySelector(`[data-lesson-id="${lessonId}"]`);
            if (!card.classList.contains('locked')) {
                card.classList.toggle('expanded');
            }
        }

        function showLockedMessage() {
            // Create toast notification
            const toast = document.createElement('div');
            toast.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                background: linear-gradient(135deg, #ef4444, #dc2626);
                color: white;
                padding: 18px 25px;
                border-radius: 15px;
                box-shadow: 0 10px 30px rgba(239, 68, 68, 0.4);
                z-index: 9999;
                display: flex;
                align-items: center;
                gap: 12px;
                font-weight: 600;
                animation: slideInRight 0.4s ease;
            `;
            toast.innerHTML = `
                <i class="fas fa-lock" style="font-size: 1.5em;"></i>
                <div>
                    <div style="font-weight: 700; margin-bottom: 3px;">Lesson Locked</div>
                    <div style="font-size: 0.9em; opacity: 0.9;">Complete the previous lesson to unlock this one</div>
                </div>
            `;

            // Add animation
            const style = document.createElement('style');
            style.textContent = `
                @keyframes slideInRight {
                    from {
                        transform: translateX(400px);
                        opacity: 0;
                    }
                    to {
                        transform: translateX(0);
                        opacity: 1;
                    }
                }
                @keyframes slideOutRight {
                    from {
                        transform: translateX(0);
                        opacity: 1;
                    }
                    to {
                        transform: translateX(400px);
                        opacity: 0;
                    }
                }
            `;
            document.head.appendChild(style);
            document.body.appendChild(toast);

            // Remove after 4 seconds
            setTimeout(() => {
                toast.style.animation = 'slideOutRight 0.4s ease';
                setTimeout(() => toast.remove(), 400);
            }, 4000);
        }

        // Auto-expand first unlocked lesson
        document.addEventListener('DOMContentLoaded', function() {
            const firstUnlockedLesson = document.querySelector('.lesson-card:not(.locked)');
            if (firstUnlockedLesson) {
                firstUnlockedLesson.classList.add('expanded');
            }
            
            // Check if should show survey
            checkAndShowSurvey();
        });

        // Survey functionality
        async function checkAndShowSurvey() {
            const courseId = {{ $course->id }};
            const completedTopics = {{ $completedTopics }};
            const totalTopics = {{ $totalTopics }};
            const enableSurvey = {{ $course->enable_survey ? 'true' : 'false' }};
            
            // Only show if course has survey enabled and is completed
            if (!enableSurvey || completedTopics < totalTopics) {
                return;
            }
            
            // Check if already submitted
            const surveyKey = `survey_submitted_${courseId}`;
            if (localStorage.getItem(surveyKey)) {
                return;
            }
            
            try {
                const response = await fetch(`/api/courses/${courseId}/survey`, {
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    credentials: 'include'
                });
                
                if (!response.ok) return;
                
                const data = await response.json();
                
                if (data.questions && data.questions.length > 0) {
                    showSurveyModal(data);
                }
            } catch (error) {
                console.error('Error loading survey:', error);
            }
        }

        function showSurveyModal(surveyData) {
            const modalHTML = `
                <div class="survey-modal-overlay active" id="survey-modal">
                    <div class="survey-modal">
                        <div class="survey-header">
                            <h2>🎉 Congratulations!</h2>
                            <p style="opacity: 0.9; margin-top: 10px;">${surveyData.title || 'Course Feedback'}</p>
                            ${surveyData.description ? `<p style="font-size: 0.9em; opacity: 0.8; margin-top: 5px;">${surveyData.description}</p>` : ''}
                        </div>
                        <div class="survey-body" id="survey-questions">
                            ${surveyData.questions.map((q, index) => generateQuestionHTML(q, index)).join('')}
                        </div>
                        <div class="survey-actions">
                            <button class="survey-btn survey-btn-skip" onclick="skipSurvey()">Skip</button>
                            <button class="survey-btn survey-btn-submit" onclick="submitSurvey()">Submit Feedback</button>
                        </div>
                    </div>
                </div>
            `;
            
            document.body.insertAdjacentHTML('beforeend', modalHTML);
        }

        function generateQuestionHTML(question, index) {
            const required = question.is_required ? '<span class="required">*</span>' : '';
            
            if (question.question_type === 'rating') {
                return `
                    <div class="survey-question" data-question-id="${question.id}">
                        <label>${question.question} ${required}</label>
                        <div class="rating-buttons">
                            ${[1,2,3,4,5].map(rating => `
                                <button type="button" class="rating-btn" data-rating="${rating}" onclick="selectRating(this, ${question.id})">
                                    ${rating} ${rating === 1 ? '⭐' : rating === 5 ? '⭐⭐⭐⭐⭐' : '⭐'.repeat(rating)}
                                </button>
                            `).join('')}
                        </div>
                    </div>
                `;
            } else if (question.question_type === 'text') {
                return `
                    <div class="survey-question" data-question-id="${question.id}">
                        <label>${question.question} ${required}</label>
                        <textarea rows="4" data-question-id="${question.id}" placeholder="Share your thoughts..."></textarea>
                    </div>
                `;
            } else if (question.question_type === 'multiple_choice' && question.options) {
                const options = typeof question.options === 'string' ? JSON.parse(question.options) : question.options;
                return `
                    <div class="survey-question" data-question-id="${question.id}">
                        <label>${question.question} ${required}</label>
                        ${options.map(opt => `
                            <label style="display: block; margin-bottom: 8px; cursor: pointer;">
                                <input type="radio" name="q_${question.id}" value="${opt}" style="margin-right: 8px;">
                                ${opt}
                            </label>
                        `).join('')}
                    </div>
                `;
            }
            return '';
        }

        function selectRating(btn, questionId) {
            // Remove selected from siblings
            btn.parentElement.querySelectorAll('.rating-btn').forEach(b => b.classList.remove('selected'));
            // Add selected to clicked button
            btn.classList.add('selected');
        }

        async function submitSurvey() {
            const courseId = {{ $course->id }};
            const responses = {};
            
            // Collect responses
            document.querySelectorAll('.survey-question').forEach(q => {
                const questionId = q.dataset.questionId;
                
                // Rating
                const selectedRating = q.querySelector('.rating-btn.selected');
                if (selectedRating) {
                    responses[questionId] = {
                        type: 'rating',
                        value: selectedRating.dataset.rating
                    };
                }
                
                // Text
                const textarea = q.querySelector('textarea');
                if (textarea && textarea.value.trim()) {
                    responses[questionId] = {
                        type: 'text',
                        value: textarea.value.trim()
                    };
                }
                
                // Multiple choice
                const radio = q.querySelector('input[type="radio"]:checked');
                if (radio) {
                    responses[questionId] = {
                        type: 'multiple_choice',
                        value: radio.value
                    };
                }
            });
            
            try {
                const response = await fetch(`/api/courses/${courseId}/survey/submit`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    credentials: 'include',
                    body: JSON.stringify({ responses })
                });
                
                if (response.ok) {
                    localStorage.setItem(`survey_submitted_${courseId}`, 'true');
                    document.getElementById('survey-modal').remove();
                    showThankYouMessage();
                }
            } catch (error) {
                console.error('Error submitting survey:', error);
                alert('Error submitting feedback. Please try again.');
            }
        }

        function skipSurvey() {
            const courseId = {{ $course->id }};
            localStorage.setItem(`survey_submitted_${courseId}`, 'true');
            document.getElementById('survey-modal').remove();
        }

        function showThankYouMessage() {
            const toast = document.createElement('div');
            toast.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                background: linear-gradient(135deg, #10b981, #059669);
                color: white;
                padding: 20px 30px;
                border-radius: 12px;
                box-shadow: 0 10px 30px rgba(0,0,0,0.2);
                z-index: 9999;
                animation: slideInRight 0.5s ease;
            `;
            toast.innerHTML = `
                <div style="display: flex; align-items: center; gap: 15px;">
                    <i class="fas fa-check-circle" style="font-size: 2em;"></i>
                    <div>
                        <div style="font-weight: 700; margin-bottom: 3px;">Thank You!</div>
                        <div style="font-size: 0.9em; opacity: 0.9;">Your feedback helps us improve</div>
                    </div>
                </div>
            `;
            document.body.appendChild(toast);
            setTimeout(() => toast.remove(), 4000);
        }

        // Update progress badge on page load
        async function updateProgressBadge() {
            try {
                const response = await fetch(`/api/course/{{ $course->id }}/progress`);
                const data = await response.json();
                
                if (data.progress !== undefined) {
                    const progressBadge = document.getElementById('progress-badge-display');
                    if (progressBadge) {
                        const progressSpan = progressBadge.querySelector('#progress-value');
                        if (progressSpan) {
                            progressSpan.textContent = data.progress;
                        }
                    }
                    
                    // Also update the overall progress section
                    const overallProgress = document.querySelector('.progress-fill-large');
                    if (overallProgress) {
                        overallProgress.style.width = data.progress + '%';
                    }
                    
                    const progressText = document.querySelector('.progress-stats span:first-child');
                    if (progressText) {
                        progressText.textContent = `${data.completed_topics} of ${data.total_topics} topics completed`;
                    }
                    
                    const progressPercent = document.querySelector('.progress-stats span:last-child');
                    if (progressPercent) {
                        progressPercent.textContent = data.progress + '%';
                    }
                }
            } catch (error) {
                console.log('Could not update progress:', error);
            }
        }

        // Update progress when page loads
        updateProgressBadge();
    </script>
</body>
</html>
