@extends('layouts.student')

@section('title', 'Leaderboard')

@section('content')
<style>
    .leaderboard-header {
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(20px);
        padding: 40px;
        border-radius: 25px;
        margin-bottom: 30px;
        border: 1px solid rgba(255,255,255,0.3);
    }

    .leaderboard-header h1 {
        color: white;
        font-size: 2.5em;
        margin-bottom: 15px;
        font-weight: 800;
    }

    .leaderboard-header p {
        color: rgba(255,255,255,0.95);
        font-size: 1.1em;
    }

    .your-rank-card {
        background: linear-gradient(135deg, #667eea, #764ba2);
        padding: 40px;
        border-radius: 25px;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        color: white;
    }

    .rank-header {
        font-size: 1.2em;
        margin-bottom: 20px;
        opacity: 0.9;
        font-weight: 600;
    }

    .rank-display {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 20px;
    }

    .rank-number {
        font-size: 5em;
        font-weight: 800;
        text-shadow: 0 4px 10px rgba(0,0,0,0.2);
    }

    .rank-stats {
        display: flex;
        gap: 40px;
        flex-wrap: wrap;
    }

    .rank-stat {
        text-align: center;
    }

    .rank-stat-value {
        font-size: 2em;
        font-weight: 700;
        margin-bottom: 5px;
    }

    .rank-stat-label {
        font-size: 0.9em;
        opacity: 0.9;
    }

    .leaderboard-card {
        background: white;
        border-radius: 25px;
        padding: 40px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }

    .leaderboard-card h2 {
        font-size: 2em;
        color: #333;
        margin-bottom: 30px;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .leaderboard-item {
        display: flex;
        align-items: center;
        gap: 25px;
        padding: 25px;
        background: #f9fafb;
        border-radius: 15px;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }

    .leaderboard-item:hover {
        transform: translateX(10px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        border-color: #667eea;
    }

    .leaderboard-item.current-user {
        background: linear-gradient(135deg, #ecfdf5, #d1fae5);
        border-color: #10b981;
    }

    .leaderboard-item.rank-1 {
        background: linear-gradient(135deg, #fef3c7, #fde68a);
        border-color: #f59e0b;
    }

    .leaderboard-item.rank-2 {
        background: linear-gradient(135deg, #e0e7ff, #c7d2fe);
        border-color: #818cf8;
    }

    .leaderboard-item.rank-3 {
        background: linear-gradient(135deg, #fce7f3, #fbcfe8);
        border-color: #f472b6;
    }

    .rank-badge {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5em;
        font-weight: 800;
        flex-shrink: 0;
    }

    .rank-1 .rank-badge {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
        box-shadow: 0 4px 15px rgba(245, 158, 11, 0.4);
    }

    .rank-2 .rank-badge {
        background: linear-gradient(135deg, #818cf8, #6366f1);
        color: white;
        box-shadow: 0 4px 15px rgba(129, 140, 248, 0.4);
    }

    .rank-3 .rank-badge {
        background: linear-gradient(135deg, #f472b6, #ec4899);
        color: white;
        box-shadow: 0 4px 15px rgba(244, 114, 182, 0.4);
    }

    .rank-badge-default {
        background: #e5e7eb;
        color: #6b7280;
    }

    .user-avatar {
        width: 55px;
        height: 55px;
        border-radius: 50%;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 800;
        font-size: 1.3em;
        flex-shrink: 0;
    }

    .user-info {
        flex: 1;
    }

    .user-name {
        font-size: 1.2em;
        font-weight: 700;
        color: #333;
        margin-bottom: 8px;
    }

    .user-stats {
        display: flex;
        gap: 20px;
        color: #6b7280;
        font-size: 0.9em;
    }

    .points-badge {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        padding: 12px 25px;
        border-radius: 20px;
        font-weight: 700;
        font-size: 1.1em;
        white-space: nowrap;
    }

    .medal-icon {
        font-size: 1.5em;
        margin-right: 8px;
    }

    .rank-1 .medal-icon::before { content: '🥇'; }
    .rank-2 .medal-icon::before { content: '🥈'; }
    .rank-3 .medal-icon::before { content: '🥉'; }

    @media (max-width: 768px) {
        .leaderboard-item {
            flex-direction: column;
            text-align: center;
        }

        .rank-display {
            flex-direction: column;
            text-align: center;
        }

        .rank-stats {
            justify-content: center;
        }
    }
</style>

<div class="leaderboard-header">
    <h1>🏆 Leaderboard</h1>
    <p>See how you rank among fellow learners!</p>
</div>

<!-- Your Current Rank -->
@if($currentUserRank)
    <div class="your-rank-card">
        <div class="rank-header">
            <i class="fas fa-user-circle"></i> Your Current Rank
        </div>
        <div class="rank-display">
            <div class="rank-number">#{{ $currentUserRank->rank }}</div>
            <div class="rank-stats">
                <div class="rank-stat">
                    <div class="rank-stat-value">{{ $currentUserRank->total_points }}</div>
                    <div class="rank-stat-label">Total Points</div>
                </div>
                <div class="rank-stat">
                    <div class="rank-stat-value">{{ $currentUserRank->completed_topics }}</div>
                    <div class="rank-stat-label">Topics Done</div>
                </div>
                <div class="rank-stat">
                    <div class="rank-stat-value">{{ $currentUserRank->average_score }}%</div>
                    <div class="rank-stat-label">Avg Score</div>
                </div>
            </div>
        </div>
    </div>
@endif

<!-- Leaderboard Table -->
<div class="leaderboard-card">
    <h2>
        <i class="fas fa-ranking-star"></i>
        Top Learners
    </h2>

    @forelse($users as $user)
        <div class="leaderboard-item {{ $user->id == Auth::id() ? 'current-user' : '' }} rank-{{ $user->rank <= 3 ? $user->rank : 'other' }}">
            <div class="rank-badge {{ $user->rank > 3 ? 'rank-badge-default' : '' }}">
                @if($user->rank <= 3)
                    <span class="medal-icon"></span>
                @else
                    {{ $user->rank }}
                @endif
            </div>

            <div class="user-avatar">
                {{ strtoupper(substr($user->name, 0, 1)) }}
            </div>

            <div class="user-info">
                <div class="user-name">
                    {{ $user->name }}
                    @if($user->id == Auth::id())
                        <span style="background: #10b981; color: white; padding: 4px 10px; border-radius: 10px; font-size: 0.7em; margin-left: 10px;">YOU</span>
                    @endif
                </div>
                <div class="user-stats">
                    <span>
                        <i class="fas fa-book"></i> {{ $user->enrolled_courses }} Courses
                    </span>
                    <span>
                        <i class="fas fa-check-circle"></i> {{ $user->completed_topics }} Topics
                    </span>
                    <span>
                        <i class="fas fa-star"></i> {{ $user->average_score }}% Avg
                    </span>
                </div>
            </div>

            <div class="points-badge">
                <i class="fas fa-trophy"></i> {{ $user->total_points }} pts
            </div>
        </div>
    @empty
        <div style="text-align: center; padding: 60px 20px; color: #9ca3af;">
            <i class="fas fa-users" style="font-size: 4em; margin-bottom: 20px; opacity: 0.5;"></i>
            <h3 style="color: #6b7280; font-size: 1.3em; margin-bottom: 10px;">No learners yet</h3>
            <p>Be the first to start learning!</p>
        </div>
    @endforelse
</div>

<!-- How Points Work -->
<div class="leaderboard-card" style="margin-top: 30px; background: linear-gradient(135deg, #f3f4f6, #e5e7eb);">
    <h2>
        <i class="fas fa-info-circle"></i>
        How Points Work
    </h2>
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
        <div style="background: white; padding: 25px; border-radius: 15px; text-align: center;">
            <div style="font-size: 3em; margin-bottom: 15px;">🎯</div>
            <div style="font-size: 1.5em; font-weight: 700; color: #333; margin-bottom: 10px;">+10 Points</div>
            <div style="color: #6b7280;">Per Topic Completed</div>
        </div>
        <div style="background: white; padding: 25px; border-radius: 15px; text-align: center;">
            <div style="font-size: 3em; margin-bottom: 15px;">⭐</div>
            <div style="font-size: 1.5em; font-weight: 700; color: #333; margin-bottom: 10px;">+Score</div>
            <div style="color: #6b7280;">Your Average Quiz Score</div>
        </div>
        <div style="background: white; padding: 25px; border-radius: 15px; text-align: center;">
            <div style="font-size: 3em; margin-bottom: 15px;">🏆</div>
            <div style="font-size: 1.5em; font-weight: 700; color: #333; margin-bottom: 10px;">Total</div>
            <div style="color: #6b7280;">Topics × 10 + Avg Score</div>
        </div>
    </div>
</div>
@endsection
