@extends('layouts.student')

@section('title', 'My Progress & Achievements')

@section('content')
<style>
    .progress-header {
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(20px);
        padding: 40px;
        border-radius: 25px;
        margin-bottom: 30px;
        border: 1px solid rgba(255,255,255,0.3);
    }

    .progress-header h1 {
        color: white;
        font-size: 2.5em;
        margin-bottom: 15px;
        font-weight: 800;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-card {
        background: white;
        padding: 30px;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        text-align: center;
        transition: all 0.3s ease;
    }

    .stat-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 15px 40px rgba(102, 126, 234, 0.3);
    }

    .stat-icon {
        font-size: 3em;
        margin-bottom: 15px;
    }

    .stat-value {
        font-size: 2.5em;
        font-weight: 800;
        color: #333;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6b7280;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.85em;
        letter-spacing: 0.5px;
    }

    .section-card {
        background: white;
        border-radius: 25px;
        padding: 40px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        margin-bottom: 30px;
    }

    .section-card h2 {
        font-size: 2em;
        color: #333;
        margin-bottom: 30px;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .achievements-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 25px;
    }

    .achievement-badge {
        background: white;
        padding: 30px 20px;
        border-radius: 20px;
        text-align: center;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        transition: all 0.3s ease;
        cursor: pointer;
        border: 3px solid transparent;
    }

    .achievement-badge:hover {
        transform: translateY(-8px) rotate(2deg);
        box-shadow: 0 15px 30px rgba(102, 126, 234, 0.3);
    }

    .achievement-badge.earned {
        border-color: #10b981;
        background: linear-gradient(135deg, #ecfdf5, #d1fae5);
    }

    .badge-icon {
        font-size: 4em;
        margin-bottom: 15px;
        display: block;
        filter: grayscale(100%);
        opacity: 0.4;
        transition: all 0.3s ease;
    }

    .achievement-badge.earned .badge-icon {
        filter: grayscale(0%);
        opacity: 1;
        animation: badgePop 0.5s ease;
    }

    @keyframes badgePop {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.15); }
    }

    .badge-name {
        font-size: 1em;
        font-weight: 700;
        color: #333;
        margin-bottom: 8px;
    }

    .badge-description {
        font-size: 0.85em;
        color: #6b7280;
        line-height: 1.4;
    }

    .achievement-badge.earned .checkmark {
        position: absolute;
        top: 10px;
        right: 10px;
        background: #10b981;
        color: white;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.85em;
    }

    .achievement-badge {
        position: relative;
    }

    .course-progress-item {
        background: #f9fafb;
        padding: 25px;
        border-radius: 15px;
        margin-bottom: 20px;
        border-left: 4px solid #667eea;
    }

    .course-progress-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 15px;
    }

    .course-name {
        font-size: 1.3em;
        font-weight: 700;
        color: #333;
    }

    .course-score {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        padding: 8px 20px;
        border-radius: 20px;
        font-weight: 700;
        font-size: 0.9em;
    }

    .course-stats-row {
        display: flex;
        gap: 30px;
        margin-bottom: 15px;
        color: #6b7280;
        font-size: 0.95em;
    }

    .progress-bar-container {
        background: #e5e7eb;
        height: 12px;
        border-radius: 10px;
        overflow: hidden;
        margin-bottom: 10px;
    }

    .progress-bar {
        height: 100%;
        background: linear-gradient(90deg, #10b981, #34d399);
        border-radius: 10px;
        transition: width 0.6s ease;
        position: relative;
    }

    .progress-bar::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
        animation: shimmer 2s infinite;
    }

    @keyframes shimmer {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(100%); }
    }

    .progress-text {
        font-size: 0.9em;
        color: #6b7280;
        font-weight: 600;
    }
</style>

<div class="progress-header">
    <h1>🏆 My Progress & Achievements</h1>
    <p style="color: rgba(255,255,255,0.95); font-size: 1.1em;">Track your learning journey and celebrate your achievements!</p>
</div>

<!-- Overall Stats -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon">📚</div>
        <div class="stat-value">{{ $stats['total_courses'] }}</div>
        <div class="stat-label">Total Courses</div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">✅</div>
        <div class="stat-value">{{ $stats['completed_courses'] }}</div>
        <div class="stat-label">Completed</div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">⏳</div>
        <div class="stat-value">{{ $stats['in_progress'] }}</div>
        <div class="stat-label">In Progress</div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">📝</div>
        <div class="stat-value">{{ $stats['total_topics_completed'] }}</div>
        <div class="stat-label">Topics Done</div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">🎯</div>
        <div class="stat-value">{{ round($stats['average_score']) }}%</div>
        <div class="stat-label">Avg Score</div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">🔥</div>
        <div class="stat-value">{{ $stats['streak'] }}</div>
        <div class="stat-label">Day Streak</div>
    </div>
</div>

<!-- Achievements -->
<div class="section-card">
    <h2>
        <i class="fas fa-trophy"></i>
        Achievements & Badges
    </h2>
    <div class="achievements-grid">
        @foreach($achievements as $achievement)
            <div class="achievement-badge {{ $achievement['earned'] ? 'earned' : '' }}">
                @if($achievement['earned'])
                    <div class="checkmark">
                        <i class="fas fa-check"></i>
                    </div>
                @endif
                <span class="badge-icon">{{ $achievement['icon'] }}</span>
                <div class="badge-name">{{ $achievement['name'] }}</div>
                <div class="badge-description">{{ $achievement['description'] }}</div>
            </div>
        @endforeach
    </div>
</div>

<!-- Course Progress Details -->
<div class="section-card">
    <h2>
        <i class="fas fa-chart-bar"></i>
        Course Progress Details
    </h2>

    @forelse($courses as $course)
        <div class="course-progress-item">
            <div class="course-progress-header">
                <div class="course-name">{{ $course->name }}</div>
                @if($course->average_quiz_score > 0)
                    <div class="course-score">
                        <i class="fas fa-star"></i> {{ $course->average_quiz_score }}% Avg
                    </div>
                @endif
            </div>
            <div class="course-stats-row">
                <span>
                    <i class="fas fa-book"></i> {{ $course->lessons->count() }} Lessons
                </span>
                <span>
                    <i class="fas fa-tasks"></i> {{ $course->total_topics }} Topics
                </span>
                <span>
                    <i class="fas fa-check-circle"></i> {{ $course->completed_topics }} Completed
                </span>
            </div>
            <div class="progress-bar-container">
                <div class="progress-bar" style="width: {{ $course->progress_percentage }}%"></div>
            </div>
            <div class="progress-text">{{ $course->progress_percentage }}% Complete</div>
        </div>
    @empty
        <div style="text-align: center; padding: 40px; color: #9ca3af;">
            <i class="fas fa-inbox" style="font-size: 3em; margin-bottom: 15px; opacity: 0.5;"></i>
            <p>No courses enrolled yet. Start learning to track your progress!</p>
        </div>
    @endforelse
</div>
@endsection
